/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model.idp;

import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.federation.model.AbstractFederationResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.handlers.HandlerResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.idp.AttributeManagerResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.idp.IdentityProviderAddHandler;
import org.wildfly.extension.picketlink.federation.model.idp.IdentityProviderMetricsOperationHandler;
import org.wildfly.extension.picketlink.federation.model.idp.IdentityProviderRemoveHandler;
import org.wildfly.extension.picketlink.federation.model.idp.IdentityProviderValidationStepHandler;
import org.wildfly.extension.picketlink.federation.model.idp.RoleGeneratorResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.idp.TrustDomainResourceDefinition;
import org.wildfly.extension.picketlink.federation.service.IdentityProviderService;

public class IdentityProviderResourceDefinition
extends AbstractFederationResourceDefinition {
    public static final SimpleAttributeDefinition URL = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ModelElement.COMMON_URL.getName(), ModelType.STRING, false).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ModelElement.COMMON_SECURITY_DOMAIN.getName(), ModelType.STRING, true).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SECURITY_DOMAIN_REF})).build();
    public static final SimpleAttributeDefinition ENCRYPT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ModelElement.IDENTITY_PROVIDER_ENCRYPT.getName(), ModelType.BOOLEAN, true).setDefaultValue(new ModelNode().set(false))).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition SUPPORT_SIGNATURES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ModelElement.COMMON_SUPPORTS_SIGNATURES.getName(), ModelType.BOOLEAN, true).setDefaultValue(new ModelNode().set(false))).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition STRICT_POST_BINDING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ModelElement.COMMON_STRICT_POST_BINDING.getName(), ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(true))).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition EXTERNAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ModelElement.IDENTITY_PROVIDER_EXTERNAL.getName(), ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition SUPPORT_METADATA = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ModelElement.COMMON_SUPPORT_METADATA.getName(), ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition SSL_AUTHENTICATION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ModelElement.IDENTITY_PROVIDER_SSL_AUTHENTICATION.getName(), ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false))).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition[] ATTRIBUTE_DEFINITIONS = new SimpleAttributeDefinition[]{URL, SECURITY_DOMAIN, EXTERNAL, ENCRYPT, SUPPORT_SIGNATURES, STRICT_POST_BINDING, SSL_AUTHENTICATION, SUPPORT_METADATA};
    private final ExtensionContext extensionContext;

    public IdentityProviderResourceDefinition(ExtensionContext extensionContext) {
        super(ModelElement.IDENTITY_PROVIDER, (OperationStepHandler)IdentityProviderAddHandler.INSTANCE, (OperationStepHandler)IdentityProviderRemoveHandler.INSTANCE, ATTRIBUTE_DEFINITIONS);
        this.extensionContext = extensionContext;
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        this.addChildResourceDefinition(TrustDomainResourceDefinition.INSTANCE, resourceRegistration);
        this.addChildResourceDefinition(HandlerResourceDefinition.INSTANCE, resourceRegistration);
        this.addChildResourceDefinition(RoleGeneratorResourceDefinition.INSTANCE, resourceRegistration);
        this.addChildResourceDefinition(AttributeManagerResourceDefinition.INSTANCE, resourceRegistration);
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        if (this.extensionContext.isRuntimeOnlyRegistrationValid()) {
            for (SimpleAttributeDefinition def : IdentityProviderMetricsOperationHandler.ATTRIBUTES) {
                resourceRegistration.registerMetric((AttributeDefinition)def, (OperationStepHandler)IdentityProviderMetricsOperationHandler.INSTANCE);
            }
        }
    }

    @Override
    protected OperationStepHandler createAttributeWriterHandler() {
        List<SimpleAttributeDefinition> attributes = this.getAttributes();
        return new RestartParentWriteAttributeHandler(ModelElement.IDENTITY_PROVIDER.getName(), attributes.toArray(new AttributeDefinition[attributes.size()])){

            protected ServiceName getParentServiceName(PathAddress parentAddress) {
                return IdentityProviderService.createServiceName(parentAddress.getLastElement().getValue());
            }

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.addStep((OperationStepHandler)new IdentityProviderValidationStepHandler(), OperationContext.Stage.MODEL);
                super.execute(context, operation);
            }

            protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
                IdentityProviderAddHandler.launchServices(context, parentModel, null, null, parentAddress, true);
            }

            protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
                IdentityProviderAddHandler.launchServices(context, parentModel, null, null, parentAddress, true);
            }
        };
    }
}

