/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.analyzer.definition.impl;

import java.util.Properties;
import org.hibernate.search.analyzer.definition.spi.LuceneAnalyzerDefinitionProvider;
import org.hibernate.search.analyzer.definition.spi.LuceneAnalyzerDefinitionSourceService;
import org.hibernate.search.engine.service.spi.Startable;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class PropertiesBasedLuceneAnalyzerDefinitionSourceService
implements LuceneAnalyzerDefinitionSourceService,
Startable {
    private static final Log log = LoggerFactory.make();
    private LuceneAnalyzerDefinitionProvider provider;

    @Override
    public void start(Properties properties, BuildContext context) {
        String providerClassName = properties.getProperty("hibernate.search.lucene.analyzer_definition_provider");
        if (providerClassName != null) {
            try {
                Class providerClazz = ClassLoaderHelper.classForName(providerClassName, context.getServiceManager());
                this.provider = (LuceneAnalyzerDefinitionProvider)ReflectionHelper.createInstance(providerClazz, true);
            }
            catch (RuntimeException e) {
                throw log.invalidLuceneAnalyzerDefinitionProvider(providerClassName, e);
            }
        }
    }

    @Override
    public LuceneAnalyzerDefinitionProvider getLuceneAnalyzerDefinitionProvider() {
        return this.provider;
    }
}

