/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.analyzer.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerReference;
import org.hibernate.search.analyzer.impl.ScopedLuceneAnalyzer;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.analyzer.spi.ScopedAnalyzerReference;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ScopedLuceneAnalyzerReference
extends LuceneAnalyzerReference
implements ScopedAnalyzerReference {
    private static final Log LOG = LoggerFactory.make();
    private ScopedLuceneAnalyzer analyzer;
    private DeferredInitializationBuilder builder;

    public ScopedLuceneAnalyzerReference(ScopedLuceneAnalyzer analyzer) {
        this.builder = null;
        this.analyzer = analyzer;
    }

    private ScopedLuceneAnalyzerReference(DeferredInitializationBuilder builder) {
        this.builder = builder;
        this.analyzer = null;
    }

    @Override
    public ScopedLuceneAnalyzer getAnalyzer() {
        if (this.analyzer == null) {
            throw LOG.lazyLuceneAnalyzerReferenceNotInitialized(this);
        }
        return this.analyzer;
    }

    public boolean isInitialized() {
        return this.analyzer != null;
    }

    public void initialize() {
        if (this.analyzer != null) {
            throw new AssertionFailure("A lucene analyzer reference has been initialized more than once: " + this);
        }
        this.analyzer = this.builder.buildAnalyzer();
        this.builder = null;
    }

    @Override
    public void close() {
        if (this.isInitialized()) {
            this.getAnalyzer().close();
        }
    }

    @Override
    public CopyBuilder startCopy() {
        return new CopyBuilder(this.getAnalyzer());
    }

    private static LuceneAnalyzerReference getLuceneAnalyzerReference(AnalyzerReference analyzerReference) {
        if (!analyzerReference.is(LuceneAnalyzerReference.class)) {
            throw LOG.analyzerReferenceIsNotLucene(analyzerReference);
        }
        return analyzerReference.unwrap(LuceneAnalyzerReference.class);
    }

    public static class CopyBuilder
    implements ScopedAnalyzerReference.CopyBuilder {
        private final ScopedLuceneAnalyzer baseAnalyzer;
        private final Map<String, Analyzer> scopedAnalyzersOverrides = new HashMap<String, Analyzer>();

        protected CopyBuilder(ScopedLuceneAnalyzer baseAnalyzer) {
            this.baseAnalyzer = baseAnalyzer;
        }

        @Override
        public void addAnalyzerReference(String scope, AnalyzerReference analyzerReference) {
            this.scopedAnalyzersOverrides.put(scope, ScopedLuceneAnalyzerReference.getLuceneAnalyzerReference(analyzerReference).getAnalyzer());
        }

        @Override
        public ScopedLuceneAnalyzerReference build() {
            Analyzer globalAnalyzer = this.baseAnalyzer.getGlobalAnalyzer();
            HashMap<String, Analyzer> scopedAnalyzers = new HashMap<String, Analyzer>(this.baseAnalyzer.getScopedAnalyzers());
            scopedAnalyzers.putAll(this.scopedAnalyzersOverrides);
            ScopedLuceneAnalyzer scopedAnalyzer = new ScopedLuceneAnalyzer(globalAnalyzer, scopedAnalyzers);
            return new ScopedLuceneAnalyzerReference(scopedAnalyzer);
        }
    }

    public static class DeferredInitializationBuilder
    implements ScopedAnalyzerReference.Builder {
        private LuceneAnalyzerReference globalAnalyzerReference;
        private final Map<String, LuceneAnalyzerReference> scopedAnalyzerReferences = new HashMap<String, LuceneAnalyzerReference>();

        public DeferredInitializationBuilder(LuceneAnalyzerReference globalAnalyzerReference, Map<String, LuceneAnalyzerReference> scopedAnalyzers) {
            this.globalAnalyzerReference = globalAnalyzerReference;
            this.scopedAnalyzerReferences.putAll(scopedAnalyzers);
        }

        @Override
        public LuceneAnalyzerReference getGlobalAnalyzerReference() {
            return this.globalAnalyzerReference;
        }

        @Override
        public void setGlobalAnalyzerReference(AnalyzerReference globalAnalyzerReference) {
            this.globalAnalyzerReference = ScopedLuceneAnalyzerReference.getLuceneAnalyzerReference(globalAnalyzerReference);
        }

        @Override
        public void addAnalyzerReference(String scope, AnalyzerReference analyzerReference) {
            this.scopedAnalyzerReferences.put(scope, ScopedLuceneAnalyzerReference.getLuceneAnalyzerReference(analyzerReference));
        }

        @Override
        public ScopedLuceneAnalyzerReference build() {
            return new ScopedLuceneAnalyzerReference(this);
        }

        protected final ScopedLuceneAnalyzer buildAnalyzer() {
            Analyzer globalAnalyzer = this.globalAnalyzerReference.getAnalyzer();
            HashMap<String, Analyzer> scopedAnalyzers = new HashMap<String, Analyzer>();
            for (Map.Entry<String, LuceneAnalyzerReference> entry : this.scopedAnalyzerReferences.entrySet()) {
                scopedAnalyzers.put(entry.getKey(), entry.getValue().getAnalyzer());
            }
            return new ScopedLuceneAnalyzer(globalAnalyzer, scopedAnalyzers);
        }
    }
}

