/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.IndexWriterDelegate;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkExecutor;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.store.Workspace;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class PurgeAllWorkExecutor
implements LuceneWorkExecutor {
    private static final Log log = LoggerFactory.make();
    protected final Workspace workspace;

    PurgeAllWorkExecutor(Workspace workspace) {
        this.workspace = workspace;
    }

    @Override
    public void performWork(LuceneWork work, IndexWriterDelegate delegate, IndexingMonitor monitor) {
        Class<?> entityType = work.getEntityClass();
        String tenantId = work.getTenantId();
        try {
            Term entityTypeTerm = new Term("_hibernate_class", entityType.getName());
            if (tenantId == null) {
                log.tracef("purgeAll Lucene index using IndexWriter for type: %s", entityType);
                delegate.deleteDocuments(entityTypeTerm);
            } else {
                log.tracef("purgeAll Lucene index using IndexWriter for type $1%s and tenant $2%s", entityType, tenantId);
                Term tenantIdTerm = tenantId == null ? null : new Term("__HSearch_TenantId", tenantId);
                BooleanQuery deleteDocumentsQuery = new BooleanQuery.Builder().add((Query)new TermQuery(entityTypeTerm), BooleanClause.Occur.FILTER).add((Query)new TermQuery(tenantIdTerm), BooleanClause.Occur.FILTER).build();
                delegate.deleteDocuments((Query)deleteDocumentsQuery);
            }
        }
        catch (Exception e) {
            throw new SearchException("Unable to purge all from Lucene index: " + entityType, e);
        }
        this.workspace.notifyWorkApplied(work);
    }
}

