/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spi.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class TypeHierarchy {
    private static final Log log = LoggerFactory.make();
    private Map<Class<?>, Set<Class<?>>> classToConfiguredClass = new HashMap();

    public void addConfiguredClass(Class<?> configuredClass) {
        this.addClass(configuredClass, configuredClass);
        for (Class<?> superClass = configuredClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            this.addClass(superClass, configuredClass);
        }
        for (Class<?> clazz : configuredClass.getInterfaces()) {
            this.addClass(clazz, configuredClass);
        }
    }

    private void addClass(Class<?> superclass, Class<?> indexedClass) {
        Set<Class<?>> classesSet = this.classToConfiguredClass.get(superclass);
        if (classesSet == null) {
            classesSet = new HashSet();
            this.classToConfiguredClass.put(superclass, classesSet);
        }
        classesSet.add(indexedClass);
    }

    public Set<Class<?>> getConfiguredClasses(Class<?>[] classes) {
        if (classes == null) {
            return Collections.emptySet();
        }
        HashSet indexedClasses = new HashSet();
        for (Class<?> clazz : classes) {
            Set<Class<?>> set = this.classToConfiguredClass.get(clazz);
            if (set == null) continue;
            indexedClasses.addAll(set);
        }
        if (log.isTraceEnabled()) {
            log.tracef("Targeted indexed classes for %s: %s", Arrays.toString(classes), indexedClasses);
        }
        return indexedClasses;
    }
}

