/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;

public class InfinispanRequest {
    private final FullHttpRequest request;
    private final Optional<String> streamId;
    private final ChannelHandlerContext nettyChannelContext;
    private final Optional<String> cacheName;
    private final String context;
    private final Optional<String> key;
    private final QueryStringDecoder queryStringDecoder;

    private InfinispanRequest(FullHttpRequest request, ChannelHandlerContext ctx) {
        this.request = request;
        this.queryStringDecoder = new QueryStringDecoder(request.uri());
        this.streamId = Optional.ofNullable(request.headers().get((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text()));
        this.nettyChannelContext = ctx;
        StringTokenizer pathTokenizer = new StringTokenizer(this.queryStringDecoder.path(), "/");
        this.context = pathTokenizer.nextToken();
        this.cacheName = pathTokenizer.hasMoreTokens() ? Optional.of(pathTokenizer.nextToken()) : Optional.empty();
        this.key = pathTokenizer.hasMoreTokens() ? Optional.of(pathTokenizer.nextToken()) : Optional.empty();
    }

    public static InfinispanRequest newRequest(FullHttpRequest request, ChannelHandlerContext ctx) {
        return new InfinispanRequest(request, ctx);
    }

    public Optional<String> getStreamId() {
        return this.streamId;
    }

    public FullHttpRequest getRawRequest() {
        return this.request;
    }

    public ChannelHandlerContext getRawContext() {
        return this.nettyChannelContext;
    }

    public Optional<String> getCacheName() {
        return this.cacheName;
    }

    public Optional<String> getKey() {
        return this.key;
    }

    public Optional<Boolean> getUseAsync() {
        String performAsync = this.request.headers().get("performAsync");
        if ("true".equals(performAsync)) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<String> getAcceptContentType() {
        return Optional.ofNullable(this.request.headers().get((CharSequence)HttpHeaderNames.ACCEPT));
    }

    public Optional<String> getContentType() {
        return Optional.ofNullable(this.request.headers().get("Content-type"));
    }

    public Optional<String> getAuthorization() {
        return Optional.ofNullable(this.request.headers().get((CharSequence)HttpHeaderNames.AUTHORIZATION));
    }

    public Optional<byte[]> data() {
        if (this.request.content() != null) {
            ByteBuf content = this.request.content();
            if (content.hasArray()) {
                return Optional.of(content.array());
            }
            return Optional.of(content.copy().array());
        }
        return Optional.empty();
    }

    public Optional<Long> getTimeToLiveSeconds() {
        String timeToLiveSeconds = this.request.headers().get("timeToLiveSeconds");
        if (timeToLiveSeconds != null) {
            try {
                return Optional.of(Long.valueOf(timeToLiveSeconds));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public Optional<Long> getMaxIdleTimeSeconds() {
        String maxIdleTimeSeconds = this.request.headers().get("maxIdleTimeSeconds");
        if (maxIdleTimeSeconds != null) {
            try {
                return Optional.of(Long.valueOf(maxIdleTimeSeconds));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public Optional<String> getEtagIfNoneMatch() {
        return Optional.ofNullable(this.request.headers().get("If-None-Match"));
    }

    public Optional<String> getEtagIfUnmodifiedSince() {
        return Optional.ofNullable(this.request.headers().get("If-Unmodified-Since"));
    }

    public Optional<String> getEtagIfModifiedSince() {
        return Optional.ofNullable(this.request.headers().get("If-Modified-Since"));
    }

    public Optional<String> getEtagIfMatch() {
        return Optional.ofNullable(this.request.headers().get("If-Match"));
    }

    public Optional<String> getCacheControl() {
        return Optional.ofNullable(this.request.headers().get((CharSequence)HttpHeaderNames.CACHE_CONTROL));
    }

    public Optional<String> getExtended() {
        List extendedParameters = (List)this.queryStringDecoder.parameters().get("extended");
        if (extendedParameters != null && extendedParameters.size() > 0) {
            return Optional.ofNullable(extendedParameters.get(0));
        }
        return Optional.empty();
    }

    public String getContext() {
        return this.context;
    }
}

