/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.infinispan.scripting.impl.ScriptMetadata;
import org.infinispan.scripting.impl.ScriptTask;
import org.infinispan.scripting.impl.ScriptingManagerImpl;
import org.infinispan.tasks.Task;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.TaskExecutionMode;
import org.infinispan.tasks.spi.TaskEngine;

public class ScriptingTaskEngine
implements TaskEngine {
    private final ScriptingManagerImpl scriptingManager;

    public ScriptingTaskEngine(ScriptingManagerImpl scriptingManager) {
        this.scriptingManager = scriptingManager;
    }

    public String getName() {
        return "Script";
    }

    public List<Task> getTasks() {
        ArrayList<Task> tasks = new ArrayList<Task>();
        this.scriptingManager.getScriptNames().forEach(s -> {
            ScriptMetadata scriptMetadata = this.scriptingManager.getScriptMetadata((String)s);
            tasks.add(new ScriptTask((String)s, scriptMetadata.mode().isClustered() ? TaskExecutionMode.ALL_NODES : TaskExecutionMode.ONE_NODE, scriptMetadata.parameters()));
        });
        return tasks;
    }

    public <T> CompletableFuture<T> runTask(String taskName, TaskContext context, Executor executor) {
        return this.scriptingManager.runScript(taskName, context);
    }

    public boolean handles(String taskName) {
        return this.scriptingManager.containsScript(taskName);
    }
}

