/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.logging.Log;
import org.jgroups.stack.Protocol;
import org.jgroups.util.BoundedHashMap;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

public class ForwardQueue {
    protected Protocol up_prot;
    protected Protocol down_prot;
    protected Address local_addr;
    protected final NavigableMap<Long, Message> forward_table = new ConcurrentSkipListMap<Long, Message>();
    protected final Lock send_lock = new ReentrantLock();
    protected final Condition send_cond = this.send_lock.newCondition();
    protected volatile boolean flushing = false;
    protected volatile boolean running = true;
    protected final AtomicInteger in_flight_sends = new AtomicInteger(0);
    protected final ConcurrentMap<Address, BoundedHashMap<Long, Long>> delivery_table = Util.createConcurrentMap();
    protected volatile Flusher flusher;
    protected final Promise<Long> ack_promise = new Promise();
    protected final Log log;
    protected int delivery_table_max_size = 500;

    public ForwardQueue(Log log) {
        this.log = log;
    }

    public Protocol getUpProt() {
        return this.up_prot;
    }

    public void setUpProt(Protocol up_prot) {
        this.up_prot = up_prot;
    }

    public Protocol getDownProt() {
        return this.down_prot;
    }

    public void setDownProt(Protocol down_prot) {
        this.down_prot = down_prot;
    }

    public Address getLocalAddr() {
        return this.local_addr;
    }

    public void setLocalAddr(Address local_addr) {
        this.local_addr = local_addr;
    }

    public int getDeliveryTableMaxSize() {
        return this.delivery_table_max_size;
    }

    public void setDeliveryTableMaxSize(int max_size) {
        this.delivery_table_max_size = max_size;
    }

    public int deliveryTableSize() {
        int retval = 0;
        for (BoundedHashMap val : this.delivery_table.values()) {
            retval += val.size();
        }
        return retval;
    }

    public void start() {
        this.running = true;
    }

    public void stop() {
        this.running = false;
        this.unblockAll();
        this.stopFlusher();
        this.forward_table.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(long id, Message msg) {
        if (this.flushing) {
            this.block();
        }
        this.in_flight_sends.incrementAndGet();
        try {
            this.forward_table.put(id, msg);
            if (this.running && !this.flushing) {
                this.down_prot.down(new Event(1, msg));
            }
        }
        finally {
            this.in_flight_sends.decrementAndGet();
        }
    }

    public void receive(long id, Message msg) {
        Address sender = msg.getSrc();
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(this.local_addr + ": sender is null, cannot deliver message " + "::" + id);
            }
            return;
        }
        if (!this.canDeliver(sender, id)) {
            if (this.log.isWarnEnabled()) {
                this.log.warn(this.local_addr + ": dropped duplicate message " + sender + "::" + id);
            }
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": delivering " + sender + "::" + id);
        }
        this.up_prot.up(new Event(1, msg));
    }

    public void flush(Address new_target, List<Address> mbrs) {
        this.delivery_table.keySet().retainAll(mbrs);
        if (new_target != null) {
            this.stopFlusher();
            this.startFlusher(new_target);
        }
    }

    public void ack(long id) {
        this.forward_table.remove(id);
        this.ack_promise.setResult(id);
    }

    public int size() {
        return this.forward_table.size();
    }

    protected void doFlush(Address new_target) throws InterruptedException {
        while (this.flushing && this.running && this.in_flight_sends.get() != 0) {
            Thread.sleep(100L);
        }
        this.send_lock.lockInterruptibly();
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": target changed to " + new_target);
            }
            this.flushMessagesInForwardTable(new_target);
        }
        finally {
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": flushing completed");
            }
            this.flushing = false;
            this.send_cond.signalAll();
            this.send_lock.unlock();
        }
    }

    protected void flushMessagesInForwardTable(Address target) {
        Message forward_msg;
        Map.Entry<Long, Message> first = this.forward_table.firstEntry();
        if (first == null) {
            return;
        }
        Long key = first.getKey();
        Message val = first.getValue();
        while (this.flushing && this.running && !this.forward_table.isEmpty()) {
            forward_msg = val.copy();
            forward_msg.setDest(target);
            forward_msg.setFlag(Message.Flag.DONT_BUNDLE);
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": flushing (forwarding) " + "::" + key + " to target " + target);
            }
            this.ack_promise.reset();
            this.down_prot.down(new Event(1, forward_msg));
            Long ack = this.ack_promise.getResult(500L);
            if ((ack == null || !ack.equals(key)) && this.forward_table.containsKey(key)) continue;
            break;
        }
        for (Map.Entry entry : this.forward_table.entrySet()) {
            key = (Long)entry.getKey();
            val = (Message)entry.getValue();
            if (!this.flushing || !this.running) continue;
            forward_msg = val.copy();
            forward_msg.setDest(target);
            forward_msg.setFlag(Message.Flag.DONT_BUNDLE);
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": flushing (forwarding) " + "::" + key + " to target " + target);
            }
            this.down_prot.down(new Event(1, forward_msg));
        }
    }

    protected boolean canDeliver(Address sender, long seqno) {
        BoundedHashMap existing;
        BoundedHashMap<Long, Long> seqno_set = (BoundedHashMap<Long, Long>)this.delivery_table.get(sender);
        if (seqno_set == null && (existing = this.delivery_table.put(sender, seqno_set = new BoundedHashMap<Long, Long>(this.delivery_table_max_size))) != null) {
            seqno_set = existing;
        }
        return seqno_set.add(seqno, seqno);
    }

    protected void block() {
        this.send_lock.lock();
        try {
            while (this.flushing && this.running) {
                try {
                    this.send_cond.await();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            this.send_lock.unlock();
        }
    }

    protected void unblockAll() {
        this.flushing = false;
        this.send_lock.lock();
        try {
            this.send_cond.signalAll();
            this.ack_promise.setResult(null);
        }
        finally {
            this.send_lock.unlock();
        }
    }

    protected synchronized void startFlusher(Address new_coord) {
        if (this.flusher == null || !this.flusher.isAlive()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": flushing started");
            }
            this.flushing = true;
            this.flusher = new Flusher(new_coord);
            this.flusher.setName("Flusher");
            this.flusher.start();
        }
    }

    protected void stopFlusher() {
        this.flushing = false;
        Flusher tmp = this.flusher;
        while (tmp != null && tmp.isAlive()) {
            tmp.interrupt();
            this.ack_promise.setResult(null);
            try {
                tmp.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected class Flusher
    extends Thread {
        protected final Address new_coord;

        public Flusher(Address new_coord) {
            this.new_coord = new_coord;
        }

        @Override
        public void run() {
            try {
                ForwardQueue.this.doFlush(this.new_coord);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

