/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.ping.common.server;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jgroups.ping.common.server.JDKServerFactory;
import org.jgroups.ping.common.server.Server;
import org.jgroups.ping.common.server.ServerFactory;
import org.jgroups.ping.common.server.UndertowServerFactory;

public final class Servers {
    private static final Logger log = Logger.getLogger(Servers.class.getName());
    private static final List<ServerFactory> factories = new ArrayList<ServerFactory>();

    public static Server getServer(int port) {
        for (ServerFactory factory : factories) {
            if (factory.isAvailable()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(factory.getClass().getSimpleName() + " is available.");
                }
                return factory.getServer(port);
            }
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine(factory.getClass().getSimpleName() + " is not available.");
        }
        throw new IllegalStateException("No available ServerFactory.");
    }

    private Servers() {
    }

    static {
        factories.add(new UndertowServerFactory());
        factories.add(new JDKServerFactory());
    }
}

