/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Set;
import org.infinispan.atomic.impl.Operation;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;

public class PutOperation<K, V>
extends Operation<K, V> {
    private K key;
    private V oldValue;
    private V newValue;

    public PutOperation() {
    }

    PutOperation(K key, V oldValue, V newValue) {
        this.key = key;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    @Override
    public void rollback(Map<K, V> delegate) {
        if (this.oldValue == null) {
            delegate.remove(this.key);
        } else {
            delegate.put(this.key, this.oldValue);
        }
    }

    @Override
    public void replay(Map<K, V> delegate) {
        delegate.put(this.key, this.newValue);
    }

    @Override
    public K keyAffected() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PutOperation)) {
            return false;
        }
        PutOperation that = (PutOperation)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        if (this.newValue != null ? !this.newValue.equals(that.newValue) : that.newValue != null) {
            return false;
        }
        return !(this.oldValue != null ? !this.oldValue.equals(that.oldValue) : that.oldValue != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.oldValue != null ? this.oldValue.hashCode() : 0);
        result = 31 * result + (this.newValue != null ? this.newValue.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PutOperation{key=" + this.key + ", oldValue=" + this.oldValue + ", newValue=" + this.newValue + '}';
    }

    public static class Externalizer
    extends AbstractExternalizer<PutOperation> {
        public void writeObject(ObjectOutput output, PutOperation put) throws IOException {
            output.writeObject(put.key);
            output.writeObject(put.newValue);
        }

        public PutOperation readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            PutOperation put = new PutOperation();
            put.key = input.readObject();
            put.newValue = input.readObject();
            return put;
        }

        public Integer getId() {
            return 24;
        }

        public Set<Class<? extends PutOperation>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{PutOperation.class});
        }
    }
}

