/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.security.auth.Subject;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheSet;
import org.infinispan.atomic.Delta;
import org.infinispan.batch.BatchContainer;
import org.infinispan.cache.impl.AbstractDelegatingCache;
import org.infinispan.cache.impl.CacheImpl;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.metadata.Metadata;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.stats.Stats;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.util.concurrent.locks.LockManager;

@MBean(objectName="Cache", description="Component that represents an individual cache instance.")
public class AbstractDelegatingAdvancedCache<K, V>
extends AbstractDelegatingCache<K, V>
implements AdvancedCache<K, V> {
    protected final AdvancedCache<K, V> cache;
    private final AdvancedCacheWrapper<K, V> wrapper;

    public AbstractDelegatingAdvancedCache(AdvancedCache<K, V> cache) {
        this(cache, new AdvancedCacheWrapper<K, V>(){

            @Override
            public AdvancedCache<K, V> wrap(AdvancedCache<K, V> cache) {
                return new AbstractDelegatingAdvancedCache(cache);
            }
        });
    }

    protected AbstractDelegatingAdvancedCache(AdvancedCache<K, V> cache, AdvancedCacheWrapper<K, V> wrapper) {
        super(cache);
        this.cache = cache;
        this.wrapper = wrapper;
    }

    @Override
    public void addInterceptor(CommandInterceptor i, int position) {
        this.cache.getAsyncInterceptorChain().addInterceptor(i, position);
    }

    @Override
    public AsyncInterceptorChain getAsyncInterceptorChain() {
        return this.cache.getAsyncInterceptorChain();
    }

    @Override
    public boolean addInterceptorAfter(CommandInterceptor i, Class<? extends CommandInterceptor> afterInterceptor) {
        return this.cache.getAsyncInterceptorChain().addInterceptorAfter(i, afterInterceptor);
    }

    @Override
    public boolean addInterceptorBefore(CommandInterceptor i, Class<? extends CommandInterceptor> beforeInterceptor) {
        return this.cache.getAsyncInterceptorChain().addInterceptorBefore(i, beforeInterceptor);
    }

    @Override
    public void removeInterceptor(int position) {
        this.cache.getAsyncInterceptorChain().removeInterceptor(position);
    }

    @Override
    public void removeInterceptor(Class<? extends CommandInterceptor> interceptorType) {
        this.cache.getAsyncInterceptorChain().removeInterceptor(interceptorType);
    }

    @Override
    public AdvancedCache<K, V> getAdvancedCache() {
        return this;
    }

    @Override
    public List<CommandInterceptor> getInterceptorChain() {
        return this.cache.getInterceptorChain();
    }

    @Override
    public EvictionManager getEvictionManager() {
        return this.cache.getEvictionManager();
    }

    @Override
    public ExpirationManager<K, V> getExpirationManager() {
        return this.cache.getExpirationManager();
    }

    @Override
    public ComponentRegistry getComponentRegistry() {
        return this.cache.getComponentRegistry();
    }

    @Override
    public DistributionManager getDistributionManager() {
        return this.cache.getDistributionManager();
    }

    @Override
    public AuthorizationManager getAuthorizationManager() {
        return this.cache.getAuthorizationManager();
    }

    @Override
    public RpcManager getRpcManager() {
        return this.cache.getRpcManager();
    }

    @Override
    public BatchContainer getBatchContainer() {
        return this.cache.getBatchContainer();
    }

    @Override
    public InvocationContextContainer getInvocationContextContainer() {
        return this.cache.getInvocationContextContainer();
    }

    @Override
    public DataContainer<K, V> getDataContainer() {
        return this.cache.getDataContainer();
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.cache.getTransactionManager();
    }

    @Override
    public LockManager getLockManager() {
        return this.cache.getLockManager();
    }

    @Override
    public XAResource getXAResource() {
        return this.cache.getXAResource();
    }

    @Override
    public AvailabilityMode getAvailability() {
        return this.cache.getAvailability();
    }

    @Override
    public void setAvailability(AvailabilityMode availabilityMode) {
        this.cache.setAvailability(availabilityMode);
    }

    @ManagedAttribute(description="Returns the cache availability", displayName="Cache availability", dataType=DataType.TRAIT, writable=true)
    public String getCacheAvailability() {
        return this.getAvailability().toString();
    }

    public void setCacheAvailability(String availabilityString) throws Exception {
        this.setAvailability(AvailabilityMode.valueOf(availabilityString));
    }

    @ManagedAttribute(description="Returns whether cache rebalancing is enabled", displayName="Cache rebalacing", dataType=DataType.TRAIT, writable=true)
    public boolean isRebalancingEnabled() {
        LocalTopologyManager localTopologyManager = this.getComponentRegistry().getComponent(LocalTopologyManager.class);
        if (localTopologyManager != null) {
            try {
                return localTopologyManager.isCacheRebalancingEnabled(this.getName());
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
        return false;
    }

    public void setRebalancingEnabled(boolean enabled) {
        LocalTopologyManager localTopologyManager = this.getComponentRegistry().getComponent(LocalTopologyManager.class);
        if (localTopologyManager != null) {
            try {
                localTopologyManager.setCacheRebalancingEnabled(this.getName(), enabled);
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
    }

    @Override
    public AdvancedCache<K, V> withFlags(Flag ... flags) {
        AdvancedCache<K, V> flagCache = this.cache.withFlags(flags);
        if (flagCache != this.cache) {
            return this.wrapper.wrap(flagCache);
        }
        return this;
    }

    @Override
    public AdvancedCache<K, V> withSubject(Subject subject) {
        return this.wrapper.wrap(this.cache.withSubject(subject));
    }

    @Override
    public boolean lock(K ... key) {
        return this.cache.lock(key);
    }

    @Override
    public boolean lock(Collection<? extends K> keys) {
        return this.cache.lock(keys);
    }

    @Override
    public void applyDelta(K deltaAwareValueKey, Delta delta, Object ... locksToAcquire) {
        this.cache.applyDelta(deltaAwareValueKey, delta, locksToAcquire);
    }

    @Override
    public Stats getStats() {
        return this.cache.getStats();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.cache.getClassLoader();
    }

    @Override
    public AdvancedCache<K, V> with(ClassLoader classLoader) {
        AdvancedCache<K, V> loaderCache = this.cache.with(classLoader);
        if (loaderCache != this.cache) {
            return this.wrapper.wrap(loaderCache);
        }
        return this;
    }

    @Override
    public Map<K, V> getAll(Set<?> keys) {
        return this.cache.getAll(keys);
    }

    @Override
    public CacheEntry<K, V> getCacheEntry(Object key) {
        return this.cache.getCacheEntry(key);
    }

    @Override
    public Map<K, CacheEntry<K, V>> getAllCacheEntries(Set<?> keys) {
        return this.cache.getAllCacheEntries(keys);
    }

    @Override
    public Map<K, V> getGroup(String groupName) {
        return this.cache.getGroup(groupName);
    }

    @Override
    public void removeGroup(String groupName) {
        this.cache.removeGroup(groupName);
    }

    @Override
    public V put(K key, V value, Metadata metadata) {
        return this.cache.put(key, value, metadata);
    }

    @Override
    public V replace(K key, V value, Metadata metadata) {
        return this.cache.replace(key, value, metadata);
    }

    @Override
    public boolean replace(K key, V oldValue, V value, Metadata metadata) {
        return this.cache.replace(key, oldValue, value, metadata);
    }

    @Override
    public V putIfAbsent(K key, V value, Metadata metadata) {
        return this.cache.putIfAbsent(key, value, metadata);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, Metadata metadata) {
        return this.cache.putAsync(key, value, metadata);
    }

    @Override
    public void putForExternalRead(K key, V value, Metadata metadata) {
        this.cache.putForExternalRead(key, value, metadata);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, Metadata metadata) {
        this.cache.putAll(map, metadata);
    }

    @Override
    public CacheSet<CacheEntry<K, V>> cacheEntrySet() {
        return this.cache.cacheEntrySet();
    }

    @Override
    public void removeExpired(K key, V value, Long lifespan) {
        this.cache.removeExpired(key, value, lifespan);
    }

    protected final void putForExternalRead(K key, V value, EnumSet<Flag> flags, ClassLoader classLoader) {
        ((CacheImpl)this.cache).putForExternalRead(key, value, EnumUtil.bitSetOf(flags));
    }

    protected final void putForExternalRead(K key, V value, Metadata metadata, EnumSet<Flag> flags, ClassLoader classLoader) {
        ((CacheImpl)this.cache).putForExternalRead(key, value, metadata, EnumUtil.bitSetOf(flags));
    }

    public static interface AdvancedCacheWrapper<K, V> {
        public AdvancedCache<K, V> wrap(AdvancedCache<K, V> var1);
    }
}

