/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.util.concurrent.CompletableFuture;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.batch.BatchContainer;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.api.functional.FunctionalMap;
import org.infinispan.commons.api.functional.Status;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.Params;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

abstract class AbstractFunctionalMap<K, V>
implements FunctionalMap<K, V> {
    private static final Log log = LogFactory.getLog(FunctionalMap.class);
    protected final FunctionalMapImpl<K, V> fmap;
    protected final Params params;
    private final boolean transactional;
    private final boolean autoCommit;
    private final BatchContainer batchContainer;
    private final TransactionManager transactionManager;

    protected AbstractFunctionalMap(Params params, FunctionalMapImpl<K, V> fmap) {
        this.fmap = fmap;
        Configuration config = fmap.cache.getCacheConfiguration();
        this.transactional = config.transaction().transactionMode().isTransactional();
        this.autoCommit = config.transaction().autoCommit();
        this.transactionManager = this.transactional ? fmap.cache.getTransactionManager() : null;
        this.batchContainer = this.transactional && config.invocationBatching().enabled() ? fmap.cache.getBatchContainer() : null;
        this.params = params;
    }

    public String getName() {
        return "";
    }

    public Status getStatus() {
        return this.fmap.getStatus();
    }

    public void close() throws Exception {
        this.fmap.close();
    }

    protected InvocationContext getInvocationContext(boolean isWrite, int keyCount) {
        InvocationContext invocationContext;
        boolean txInjected = false;
        if (this.transactional) {
            Transaction transaction = this.getOngoingTransaction();
            if (transaction == null && this.autoCommit && this.transactionManager != null) {
                try {
                    this.transactionManager.begin();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new CacheException("Unable to begin implicit transaction.", (Throwable)e);
                }
                transaction = this.getOngoingTransaction();
                txInjected = true;
            }
            invocationContext = this.fmap.invCtxFactory.createInvocationContext(transaction, txInjected);
        } else {
            invocationContext = this.fmap.invCtxFactory.createInvocationContext(isWrite, keyCount);
        }
        return invocationContext;
    }

    private Transaction getOngoingTransaction() {
        try {
            Transaction transaction = null;
            if (this.transactionManager != null && (transaction = this.transactionManager.getTransaction()) == null && this.batchContainer != null) {
                transaction = this.batchContainer.getBatchTransaction();
            }
            return transaction;
        }
        catch (SystemException e) {
            throw new CacheException("Unable to get transaction", (Throwable)e);
        }
    }

    protected <T> CompletableFuture<T> invokeAsync(InvocationContext ctx, VisitableCommand cmd) {
        CompletableFuture<Object> cf;
        Transaction implicitTransaction;
        boolean isImplicitTx = ctx.isInTxScope() && ((TxInvocationContext)ctx).isImplicitTransaction();
        try {
            if (isImplicitTx) {
                implicitTransaction = this.transactionManager.suspend();
                assert (implicitTransaction != null);
            } else {
                implicitTransaction = null;
            }
            cf = this.fmap.chain.invokeAsync(ctx, cmd);
        }
        catch (SystemException e) {
            throw new CacheException("Cannot suspend implicit transaction", (Throwable)e);
        }
        catch (Throwable t) {
            if (isImplicitTx) {
                try {
                    if (this.transactionManager != null) {
                        this.transactionManager.rollback();
                    }
                }
                catch (Throwable t2) {
                    log.trace("Could not rollback", t2);
                    t.addSuppressed(t2);
                }
            }
            throw t;
        }
        if (isImplicitTx) {
            return cf.handle((result, throwable) -> {
                if (throwable != null) {
                    try {
                        implicitTransaction.rollback();
                    }
                    catch (SystemException e) {
                        log.trace("Could not rollback", e);
                        throwable.addSuppressed(e);
                    }
                    throw CompletableFutures.asCompletionException(throwable);
                }
                try {
                    implicitTransaction.commit();
                }
                catch (Exception e) {
                    log.couldNotCompleteInjectedTransaction(e);
                    throw CompletableFutures.asCompletionException(e);
                }
                return result;
            });
        }
        return cf;
    }
}

