/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.commons.api.functional.FunctionalMap;
import org.infinispan.commons.api.functional.Listeners;
import org.infinispan.commons.api.functional.Param;
import org.infinispan.commons.api.functional.Traversable;
import org.infinispan.commons.util.Experimental;
import org.infinispan.context.InvocationContext;
import org.infinispan.functional.impl.AbstractFunctionalMap;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.Params;
import org.infinispan.functional.impl.Traversables;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Experimental
public final class ReadWriteMapImpl<K, V>
extends AbstractFunctionalMap<K, V>
implements FunctionalMap.ReadWriteMap<K, V> {
    private static final Log log = LogFactory.getLog(ReadWriteMapImpl.class);

    private ReadWriteMapImpl(Params params, FunctionalMapImpl<K, V> functionalMap) {
        super(params, functionalMap);
    }

    public static <K, V> FunctionalMap.ReadWriteMap<K, V> create(FunctionalMapImpl<K, V> functionalMap) {
        return new ReadWriteMapImpl<K, V>(Params.from(functionalMap.params.params), functionalMap);
    }

    private static <K, V> FunctionalMap.ReadWriteMap<K, V> create(Params params, FunctionalMapImpl<K, V> functionalMap) {
        return new ReadWriteMapImpl<K, V>(params, functionalMap);
    }

    public <R> CompletableFuture<R> eval(K key, Function<EntryView.ReadWriteEntryView<K, V>, R> f) {
        log.tracef("Invoked eval(k=%s, %s)", key, this.params);
        ReadWriteKeyCommand<K, V, R> cmd = this.fmap.commandsFactory.buildReadWriteKeyCommand(key, f, this.params);
        InvocationContext ctx = this.getInvocationContext(true, 1);
        ctx.setLockOwner(cmd.getKeyLockOwner());
        return this.invokeAsync(ctx, cmd);
    }

    public <R> CompletableFuture<R> eval(K key, V value, BiFunction<V, EntryView.ReadWriteEntryView<K, V>, R> f) {
        log.tracef("Invoked eval(k=%s, v=%s, %s)", key, value, this.params);
        ReadWriteKeyValueCommand<K, V, R> cmd = this.fmap.commandsFactory.buildReadWriteKeyValueCommand(key, value, f, this.params);
        InvocationContext ctx = this.getInvocationContext(true, 1);
        ctx.setLockOwner(cmd.getKeyLockOwner());
        return this.invokeAsync(ctx, cmd);
    }

    public <R> Traversable<R> evalMany(Map<? extends K, ? extends V> entries, BiFunction<V, EntryView.ReadWriteEntryView<K, V>, R> f) {
        log.tracef("Invoked evalMany(entries=%s, %s)", entries, this.params);
        ReadWriteManyEntriesCommand<K, V, R> cmd = this.fmap.commandsFactory.buildReadWriteManyEntriesCommand(entries, f, this.params);
        InvocationContext ctx = this.getInvocationContext(true, entries.size());
        ctx.setLockOwner(cmd.getKeyLockOwner());
        return Traversables.of(((List)this.invokeAsync(ctx, cmd).join()).stream());
    }

    public <R> Traversable<R> evalMany(Set<? extends K> keys, Function<EntryView.ReadWriteEntryView<K, V>, R> f) {
        log.tracef("Invoked evalMany(keys=%s, %s)", keys, this.params);
        ReadWriteManyCommand<K, V, R> cmd = this.fmap.commandsFactory.buildReadWriteManyCommand(keys, f, this.params);
        InvocationContext ctx = this.getInvocationContext(true, keys.size());
        ctx.setLockOwner(cmd.getKeyLockOwner());
        return Traversables.of(((List)this.invokeAsync(ctx, cmd).join()).stream());
    }

    public <R> Traversable<R> evalAll(Function<EntryView.ReadWriteEntryView<K, V>, R> f) {
        log.tracef("Invoked evalAll(%s)", this.params);
        HashSet keys = new HashSet(this.fmap.cache.keySet());
        ReadWriteManyCommand cmd = this.fmap.commandsFactory.buildReadWriteManyCommand(keys, f, this.params);
        InvocationContext ctx = this.getInvocationContext(true, keys.size());
        ctx.setLockOwner(cmd.getKeyLockOwner());
        return Traversables.of(((List)this.invokeAsync(ctx, cmd).join()).stream());
    }

    public Listeners.ReadWriteListeners<K, V> listeners() {
        return this.fmap.notifier;
    }

    public FunctionalMap.ReadWriteMap<K, V> withParams(Param<?> ... ps) {
        if (ps == null || ps.length == 0) {
            return this;
        }
        if (this.params.containsAll(ps)) {
            return this;
        }
        return ReadWriteMapImpl.create(this.params.addAll(ps), this.fmap);
    }
}

