/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.commons.api.functional.FunctionalMap;
import org.infinispan.commons.api.functional.Listeners;
import org.infinispan.commons.api.functional.Param;
import org.infinispan.commons.util.Experimental;
import org.infinispan.context.InvocationContext;
import org.infinispan.functional.impl.AbstractFunctionalMap;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.Params;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Experimental
public final class WriteOnlyMapImpl<K, V>
extends AbstractFunctionalMap<K, V>
implements FunctionalMap.WriteOnlyMap<K, V> {
    private static final Log log = LogFactory.getLog(WriteOnlyMapImpl.class);

    private WriteOnlyMapImpl(Params params, FunctionalMapImpl<K, V> functionalMap) {
        super(params, functionalMap);
    }

    public static <K, V> FunctionalMap.WriteOnlyMap<K, V> create(FunctionalMapImpl<K, V> functionalMap) {
        return new WriteOnlyMapImpl<K, V>(Params.from(functionalMap.params.params), functionalMap);
    }

    private static <K, V> FunctionalMap.WriteOnlyMap<K, V> create(Params params, FunctionalMapImpl<K, V> functionalMap) {
        return new WriteOnlyMapImpl<K, V>(params, functionalMap);
    }

    public CompletableFuture<Void> eval(K key, Consumer<EntryView.WriteEntryView<V>> f) {
        log.tracef("Invoked eval(k=%s, %s)", key, this.params);
        WriteOnlyKeyCommand<K, V> cmd = this.fmap.commandsFactory.buildWriteOnlyKeyCommand(key, f, this.params);
        InvocationContext ctx = this.getInvocationContext(true, 1);
        ctx.setLockOwner(cmd.getKeyLockOwner());
        return this.invokeAsync(ctx, cmd);
    }

    public CompletableFuture<Void> eval(K key, V value, BiConsumer<V, EntryView.WriteEntryView<V>> f) {
        log.tracef("Invoked eval(k=%s, v=%s, %s)", key, value, this.params);
        WriteOnlyKeyValueCommand<K, V> cmd = this.fmap.commandsFactory.buildWriteOnlyKeyValueCommand(key, value, f, this.params);
        InvocationContext ctx = this.getInvocationContext(true, 1);
        ctx.setLockOwner(cmd.getKeyLockOwner());
        return this.invokeAsync(ctx, cmd);
    }

    public CompletableFuture<Void> evalMany(Map<? extends K, ? extends V> entries, BiConsumer<V, EntryView.WriteEntryView<V>> f) {
        log.tracef("Invoked evalMany(entries=%s, %s)", entries, this.params);
        WriteOnlyManyEntriesCommand<K, V> cmd = this.fmap.commandsFactory.buildWriteOnlyManyEntriesCommand(entries, f, this.params);
        InvocationContext ctx = this.getInvocationContext(true, entries.size());
        ctx.setLockOwner(cmd.getKeyLockOwner());
        return this.invokeAsync(ctx, cmd);
    }

    public CompletableFuture<Void> evalMany(Set<? extends K> keys, Consumer<EntryView.WriteEntryView<V>> f) {
        log.tracef("Invoked evalMany(keys=%s, %s)", keys, this.params);
        WriteOnlyManyCommand<K, V> cmd = this.fmap.commandsFactory.buildWriteOnlyManyCommand(keys, f, this.params);
        InvocationContext ctx = this.getInvocationContext(true, keys.size());
        ctx.setLockOwner(cmd.getKeyLockOwner());
        return this.invokeAsync(ctx, cmd);
    }

    public CompletableFuture<Void> evalAll(Consumer<EntryView.WriteEntryView<V>> f) {
        log.tracef("Invoked evalAll(%s)", this.params);
        HashSet keys = new HashSet(this.fmap.cache.keySet());
        WriteOnlyManyCommand cmd = this.fmap.commandsFactory.buildWriteOnlyManyCommand(keys, f, this.params);
        InvocationContext ctx = this.getInvocationContext(true, keys.size());
        ctx.setLockOwner(cmd.getKeyLockOwner());
        return this.invokeAsync(ctx, cmd);
    }

    public CompletableFuture<Void> truncate() {
        log.tracef("Invoked truncate(%s)", this.params);
        return this.fmap.cache.clearAsync();
    }

    public FunctionalMap.WriteOnlyMap<K, V> withParams(Param<?> ... ps) {
        if (ps == null || ps.length == 0) {
            return this;
        }
        if (this.params.containsAll(ps)) {
            return this;
        }
        return WriteOnlyMapImpl.create(this.params.addAll(ps), this.fmap);
    }

    public Listeners.WriteListeners<K, V> listeners() {
        return this.fmap.notifier;
    }
}

