/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.util.ReadOnlySegmentAwareCollection;
import org.infinispan.distribution.util.ReadOnlySegmentAwareMap;
import org.infinispan.interceptors.BaseAsyncInterceptor;
import org.infinispan.interceptors.InvocationFinallyAction;
import org.infinispan.interceptors.InvocationSuccessFunction;
import org.infinispan.interceptors.distribution.BaseDistributionInterceptor;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class NonTxDistributionInterceptor
extends BaseDistributionInterceptor {
    private static Log log = LogFactory.getLog(NonTxDistributionInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private final PutMapHelper putMapHelper = new PutMapHelper();
    private final ReadWriteManyHelper readWriteManyHelper = new ReadWriteManyHelper();
    private final ReadWriteManyEntriesHelper readWriteManyEntriesHelper = new ReadWriteManyEntriesHelper();
    private final WriteOnlyManyEntriesHelper writeOnlyManyEntriesHelper = new WriteOnlyManyEntriesHelper();
    private final WriteOnlyManyHelper writeOnlyManyHelper = new WriteOnlyManyHelper();

    private static BiConsumer<BaseDistributionInterceptor.MergingCompletableFuture<Object>, Object> moveListItemsToFuture(int myOffset) {
        return (f, rv) -> {
            Collection items;
            if (rv == null && f.results == null) {
                return;
            }
            if (rv instanceof Map) {
                items = ((Map)rv).entrySet();
            } else if (rv instanceof Collection) {
                items = (Collection)rv;
            } else {
                f.completeExceptionally(new IllegalArgumentException("Unexpected result value " + rv));
                return;
            }
            if (trace) {
                log.tracef("Copying %d items %s to results (%s), starting offset %d", new Object[]{items.size(), items, Arrays.toString(f.results), myOffset});
            }
            Iterator it = items.iterator();
            int i = 0;
            while (it.hasNext()) {
                f.results[myOffset + i] = it.next();
                ++i;
            }
        };
    }

    private Map<Address, Set<Integer>> primaryOwnersOfSegments(ConsistentHash ch) {
        HashMap<Address, Set<Integer>> map = new HashMap<Address, Set<Integer>>(ch.getMembers().size());
        for (int segment = 0; segment < ch.getNumSegments(); ++segment) {
            Address owner = ch.locatePrimaryOwnerForSegment(segment);
            map.computeIfAbsent(owner, o -> new HashSet()).add(segment);
        }
        return map;
    }

    private Map<Address, Set<Integer>> backupOwnersOfSegments(ConsistentHash ch, Set<Integer> segments) {
        HashMap<Address, Set<Integer>> map = new HashMap<Address, Set<Integer>>(ch.getMembers().size());
        if (ch.isReplicated()) {
            for (Address member : ch.getMembers()) {
                map.put(member, segments);
            }
            map.remove(this.rpcManager.getAddress());
        } else if (ch.getNumOwners() > 1) {
            for (Integer segment : segments) {
                List<Address> owners = ch.locateOwnersForSegment(segment);
                for (int i = 1; i < owners.size(); ++i) {
                    map.computeIfAbsent(owners.get(i), o -> new HashSet()).add(segment);
                }
            }
        }
        return map;
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleReadWriteManyCommand(ctx, command, this.putMapHelper);
    }

    @Override
    public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) throws Throwable {
        return this.handleWriteOnlyManyCommand(ctx, command, this.writeOnlyManyEntriesHelper);
    }

    @Override
    public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) throws Throwable {
        return this.handleWriteOnlyManyCommand(ctx, command, this.writeOnlyManyHelper);
    }

    @Override
    public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) throws Throwable {
        return this.handleReadWriteManyCommand(ctx, command, this.readWriteManyHelper);
    }

    @Override
    public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) throws Throwable {
        return this.handleReadWriteManyCommand(ctx, command, this.readWriteManyEntriesHelper);
    }

    private <C extends WriteCommand, Container, Item> Object handleWriteOnlyManyCommand(InvocationContext ctx, C command, WriteManyCommandHelper<C, Container, Item> helper) throws Exception {
        LocalizedCacheTopology cacheTopology = this.checkTopologyId(command);
        ConsistentHash ch = cacheTopology.getWriteConsistentHash();
        if (ctx.isOriginLocal()) {
            Map<Address, Set<Integer>> segmentMap = this.primaryOwnersOfSegments(ch);
            BaseDistributionInterceptor.CountDownCompletableFuture allFuture = new BaseDistributionInterceptor.CountDownCompletableFuture(ctx, segmentMap.size());
            for (Map.Entry<Address, Set<Integer>> pair : segmentMap.entrySet()) {
                Address member = pair.getKey();
                Set<Integer> segments = pair.getValue();
                this.handleSegmentsForWriteOnlyManyCommand(ctx, command, helper, ch, allFuture, member, segments);
            }
            return NonTxDistributionInterceptor.asyncValue(allFuture);
        }
        return this.handleRemoteWriteOnlyManyCommand(ctx, command, helper);
    }

    private <C extends WriteCommand, Container, Item> void handleSegmentsForWriteOnlyManyCommand(InvocationContext ctx, C command, WriteManyCommandHelper<C, Container, Item> helper, ConsistentHash ch, BaseDistributionInterceptor.CountDownCompletableFuture allFuture, Address member, Set<Integer> segments) {
        if (member.equals(this.rpcManager.getAddress())) {
            Container myItems = this.filterAndWrap(ctx, command, segments, helper);
            C localCommand = helper.copyForLocal(command, myItems);
            this.invokeNextAndFinally(ctx, (VisitableCommand)localCommand, this.createLocalInvocationHandler(ch, allFuture, segments, helper, (f, rv) -> {}));
            return;
        }
        C copy = helper.copyForPrimary(command, ch, segments);
        int size = helper.getItems(copy).size();
        if (size <= 0) {
            allFuture.countDown();
            return;
        }
        this.rpcManager.invokeRemotelyAsync((Collection<Address>)Collections.singletonList(member), (ReplicableCommand)copy, this.defaultSyncOptions).whenComplete((responseMap, throwable) -> {
            if (throwable != null) {
                allFuture.completeExceptionally((Throwable)throwable);
            } else {
                try {
                    this.getSingleSuccessfulResponseOrFail((Map<Address, Response>)responseMap, allFuture);
                    allFuture.countDown();
                }
                catch (Throwable t) {
                    allFuture.completeExceptionally(t);
                }
            }
        });
    }

    private <C extends WriteCommand, Item> Object handleRemoteWriteOnlyManyCommand(InvocationContext ctx, C command, WriteManyCommandHelper<C, ?, Item> helper) {
        for (Item item : helper.getItems(command)) {
            Object key = helper.item2key(item);
            if (ctx.lookupEntry(key) != null) continue;
            this.entryFactory.wrapExternalEntry(ctx, key, null, false, true);
        }
        if (helper.shouldRegisterRemoteCallback(command, null)) {
            return this.invokeNextThenApply(ctx, command, helper);
        }
        return this.invokeNext(ctx, command);
    }

    private <C extends WriteCommand, Container, Item> Container filterAndWrap(InvocationContext ctx, C command, Set<Integer> segments, WriteManyCommandHelper<C, Container, Item> helper) {
        Container myItems = helper.newContainer();
        for (Item item : helper.getItems(command)) {
            Object key = helper.item2key(item);
            if (!segments.contains(this.keyPartitioner.getSegment(key))) continue;
            helper.accumulate(myItems, item);
            CacheEntry entry = ctx.lookupEntry(key);
            if (entry != null) continue;
            this.entryFactory.wrapExternalEntry(ctx, key, null, false, true);
        }
        return myItems;
    }

    private <C extends WriteCommand, Container, Item> Object handleReadWriteManyCommand(InvocationContext ctx, C command, WriteManyCommandHelper<C, Item, Container> helper) throws Exception {
        ConsistentHash ch = this.checkTopologyId(command).getWriteConsistentHash();
        if (ctx.isOriginLocal()) {
            Map<Address, Set<Integer>> segmentMap = this.primaryOwnersOfSegments(ch);
            Object[] results = null;
            if (!command.hasAnyFlag(FlagBitSets.IGNORE_RETURN_VALUES)) {
                results = new Object[helper.getItems(command).size()];
            }
            BaseDistributionInterceptor.MergingCompletableFuture<Object> allFuture = new BaseDistributionInterceptor.MergingCompletableFuture<Object>(ctx, segmentMap.size(), results, helper::transformResult);
            MutableInt offset = new MutableInt();
            for (Map.Entry<Address, Set<Integer>> pair : segmentMap.entrySet()) {
                Address member = pair.getKey();
                Set<Integer> segments = pair.getValue();
                if (member.equals(this.rpcManager.getAddress())) {
                    this.handleLocalSegmentsForReadWriteManyCommand(ctx, command, helper, ch, allFuture, offset, segments);
                    continue;
                }
                this.handleRemoteSegmentsForReadWriteManyCommand(command, helper, ch, allFuture, offset, member, segments);
            }
            return NonTxDistributionInterceptor.asyncValue(allFuture);
        }
        return this.handleRemoteReadWriteManyCommand(ctx, command, helper, ch);
    }

    private <C extends WriteCommand, Container, Item> void handleLocalSegmentsForReadWriteManyCommand(InvocationContext ctx, C command, WriteManyCommandHelper<C, Container, Item> helper, ConsistentHash ch, BaseDistributionInterceptor.MergingCompletableFuture<Object> allFuture, MutableInt offset, Set<Integer> segments) throws Exception {
        Container myItems = helper.newContainer();
        List<CompletableFuture<?>> retrievals = null;
        for (Item item : helper.getItems(command)) {
            Object key = helper.item2key(item);
            if (!segments.contains(this.keyPartitioner.getSegment(key))) continue;
            helper.accumulate(myItems, item);
            retrievals = this.addRemoteGet(ctx, command, retrievals, key);
        }
        int size = helper.containerSize(myItems);
        if (size == 0) {
            allFuture.countDown();
            return;
        }
        int myOffset = offset.value;
        offset.value += size;
        C localCommand = helper.copyForLocal(command, myItems);
        InvocationFinallyAction handler = this.createLocalInvocationHandler(ch, allFuture, segments, helper, NonTxDistributionInterceptor.moveListItemsToFuture(myOffset));
        if (retrievals == null) {
            this.invokeNextAndFinally(ctx, (VisitableCommand)localCommand, handler);
        } else {
            CompletableFuture[] ra = retrievals.toArray(new CompletableFuture[retrievals.size()]);
            Object result = this.asyncInvokeNext(ctx, command, CompletableFuture.allOf(ra));
            NonTxDistributionInterceptor.makeStage(result).andFinally(ctx, command, handler);
        }
    }

    private <C extends WriteCommand, Item> void handleRemoteSegmentsForReadWriteManyCommand(C command, WriteManyCommandHelper<C, ?, Item> helper, ConsistentHash ch, BaseDistributionInterceptor.MergingCompletableFuture<Object> allFuture, MutableInt offset, Address member, Set<Integer> segments) {
        int myOffset = offset.value;
        C copy = helper.copyForPrimary(command, ch, segments);
        int size = helper.getItems(copy).size();
        offset.value += size;
        if (size <= 0) {
            allFuture.countDown();
            return;
        }
        this.rpcManager.invokeRemotelyAsync((Collection<Address>)Collections.singletonList(member), (ReplicableCommand)copy, this.defaultSyncOptions).whenComplete((responses, throwable) -> {
            if (throwable != null) {
                allFuture.completeExceptionally((Throwable)throwable);
            } else {
                Response response = this.getSingleSuccessfulResponseOrFail((Map<Address, Response>)responses, (CompletableFuture<?>)allFuture);
                if (response == null) {
                    return;
                }
                Object responseValue = ((SuccessfulResponse)response).getResponseValue();
                NonTxDistributionInterceptor.moveListItemsToFuture(myOffset).accept(allFuture, responseValue);
                allFuture.countDown();
            }
        });
    }

    private <C extends WriteCommand, Item> Object handleRemoteReadWriteManyCommand(InvocationContext ctx, C command, WriteManyCommandHelper<C, ?, Item> helper, ConsistentHash ch) throws Exception {
        CompletableFuture<Object> delay;
        List<CompletableFuture<?>> retrievals = null;
        for (Item item : helper.getItems(command)) {
            retrievals = this.addRemoteGet(ctx, command, retrievals, helper.item2key(item));
        }
        if (retrievals != null) {
            CompletableFuture[] ra = retrievals.toArray(new CompletableFuture[retrievals.size()]);
            delay = CompletableFuture.allOf(ra);
        } else {
            delay = CompletableFutures.completedNull();
        }
        Object result = this.asyncInvokeNext(ctx, command, delay);
        if (helper.shouldRegisterRemoteCallback(command, ch)) {
            return NonTxDistributionInterceptor.makeStage(result).thenApply(ctx, command, helper);
        }
        return result;
    }

    private List<CompletableFuture<?>> addRemoteGet(InvocationContext ctx, WriteCommand command, List<CompletableFuture<?>> retrievals, Object key) throws Exception {
        CacheEntry cacheEntry = ctx.lookupEntry(key);
        if (cacheEntry == null) {
            if (command.hasAnyFlag(FlagBitSets.SKIP_REMOTE_LOOKUP) || command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL)) {
                this.entryFactory.wrapExternalEntry(ctx, key, null, false, true);
            } else {
                if (retrievals == null) {
                    retrievals = new ArrayList();
                }
                GetCacheEntryCommand fakeGetCommand = this.cf.buildGetCacheEntryCommand(key, command.getFlagsBitSet());
                CompletableFuture<Void> getFuture = this.remoteGet(ctx, fakeGetCommand, fakeGetCommand.getKey(), true);
                retrievals.add(getFuture);
            }
        }
        return retrievals;
    }

    private <C extends WriteCommand, F extends BaseDistributionInterceptor.CountDownCompletableFuture, Item> InvocationFinallyAction createLocalInvocationHandler(ConsistentHash ch, F allFuture, Set<Integer> segments, WriteManyCommandHelper<C, ?, Item> helper, BiConsumer<F, Object> returnValueConsumer) {
        return (rCtx, rCommand, rv, throwable) -> {
            if (throwable != null) {
                allFuture.completeExceptionally(throwable);
            } else {
                try {
                    returnValueConsumer.accept(allFuture, rv);
                    Map<Address, Set<Integer>> backupOwners = this.backupOwnersOfSegments(ch, segments);
                    for (Map.Entry<Address, Set<Integer>> backup : backupOwners.entrySet()) {
                        WriteCommand backupCopy = helper.copyForBackup((WriteCommand)rCommand, ch, backup.getValue());
                        if (helper.getItems(backupCopy).isEmpty()) continue;
                        Set<Address> backupOwner = Collections.singleton(backup.getKey());
                        if (this.isSynchronous(backupCopy)) {
                            allFuture.increment();
                            this.rpcManager.invokeRemotelyAsync(backupOwner, backupCopy, this.defaultSyncOptions).whenComplete((responseMap, remoteThrowable) -> {
                                if (remoteThrowable != null) {
                                    allFuture.completeExceptionally((Throwable)remoteThrowable);
                                } else {
                                    allFuture.countDown();
                                }
                            });
                            continue;
                        }
                        this.rpcManager.invokeRemotelyAsync(backupOwner, backupCopy, this.defaultAsyncOptions);
                    }
                    allFuture.countDown();
                }
                catch (Throwable t) {
                    allFuture.completeExceptionally(t);
                }
            }
        };
    }

    @Override
    public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    private class WriteOnlyManyHelper
    extends WriteManyCommandHelper<WriteOnlyManyCommand, Collection<Object>, Object> {
        private WriteOnlyManyHelper() {
        }

        @Override
        public WriteOnlyManyCommand copyForLocal(WriteOnlyManyCommand cmd, Collection<Object> keys) {
            return new WriteOnlyManyCommand(cmd).withKeys(keys);
        }

        @Override
        public WriteOnlyManyCommand copyForPrimary(WriteOnlyManyCommand cmd, ConsistentHash ch, Set<Integer> segments) {
            return new WriteOnlyManyCommand(cmd).withKeys(new ReadOnlySegmentAwareCollection(cmd.getAffectedKeys(), ch, segments));
        }

        @Override
        public WriteOnlyManyCommand copyForBackup(WriteOnlyManyCommand cmd, ConsistentHash ch, Set<Integer> segments) {
            WriteOnlyManyCommand copy = new WriteOnlyManyCommand(cmd).withKeys(new ReadOnlySegmentAwareCollection(cmd.getAffectedKeys(), ch, segments));
            copy.setForwarded(true);
            return copy;
        }

        @Override
        public Collection<Object> getItems(WriteOnlyManyCommand cmd) {
            return cmd.getAffectedKeys();
        }

        @Override
        public Object item2key(Object key) {
            return key;
        }

        @Override
        public Collection<Object> newContainer() {
            return new ArrayList<Object>();
        }

        @Override
        public void accumulate(Collection<Object> list, Object key) {
            list.add(key);
        }

        @Override
        public int containerSize(Collection<Object> list) {
            return list.size();
        }

        @Override
        public boolean shouldRegisterRemoteCallback(WriteOnlyManyCommand cmd, ConsistentHash ch) {
            return !cmd.isForwarded();
        }

        @Override
        public Object transformResult(Object[] results) {
            return results == null ? null : Arrays.asList(results);
        }
    }

    private class WriteOnlyManyEntriesHelper
    extends WriteManyCommandHelper<WriteOnlyManyEntriesCommand, Map<Object, Object>, Map.Entry<Object, Object>> {
        private WriteOnlyManyEntriesHelper() {
        }

        @Override
        public WriteOnlyManyEntriesCommand copyForLocal(WriteOnlyManyEntriesCommand cmd, Map<Object, Object> entries) {
            return new WriteOnlyManyEntriesCommand<Object, Object>(cmd).withEntries(entries);
        }

        @Override
        public WriteOnlyManyEntriesCommand copyForPrimary(WriteOnlyManyEntriesCommand cmd, ConsistentHash ch, Set<Integer> segments) {
            return new WriteOnlyManyEntriesCommand(cmd).withEntries(new ReadOnlySegmentAwareMap(cmd.getEntries(), ch, segments));
        }

        @Override
        public WriteOnlyManyEntriesCommand copyForBackup(WriteOnlyManyEntriesCommand cmd, ConsistentHash ch, Set<Integer> segments) {
            WriteOnlyManyEntriesCommand copy = new WriteOnlyManyEntriesCommand(cmd).withEntries(new ReadOnlySegmentAwareMap(cmd.getEntries(), ch, segments));
            copy.setForwarded(true);
            return copy;
        }

        @Override
        public Collection<Map.Entry<Object, Object>> getItems(WriteOnlyManyEntriesCommand cmd) {
            return cmd.getEntries().entrySet();
        }

        @Override
        public Object item2key(Map.Entry<Object, Object> entry) {
            return entry.getKey();
        }

        @Override
        public Map<Object, Object> newContainer() {
            return new HashMap<Object, Object>();
        }

        @Override
        public void accumulate(Map<Object, Object> map, Map.Entry<Object, Object> entry) {
            map.put(entry.getKey(), entry.getValue());
        }

        @Override
        public int containerSize(Map<Object, Object> map) {
            return map.size();
        }

        @Override
        public boolean shouldRegisterRemoteCallback(WriteOnlyManyEntriesCommand cmd, ConsistentHash ch) {
            return !cmd.isForwarded();
        }

        @Override
        public Object transformResult(Object[] results) {
            return results == null ? null : Arrays.asList(results);
        }
    }

    private class ReadWriteManyHelper
    extends WriteManyCommandHelper<ReadWriteManyCommand, Collection<Object>, Object> {
        private ReadWriteManyHelper() {
        }

        @Override
        public ReadWriteManyCommand copyForLocal(ReadWriteManyCommand cmd, Collection<Object> keys) {
            return new ReadWriteManyCommand(cmd).withKeys(keys);
        }

        @Override
        public ReadWriteManyCommand copyForPrimary(ReadWriteManyCommand cmd, ConsistentHash ch, Set<Integer> segments) {
            return new ReadWriteManyCommand(cmd).withKeys(new ReadOnlySegmentAwareCollection(cmd.getAffectedKeys(), ch, segments));
        }

        @Override
        public ReadWriteManyCommand copyForBackup(ReadWriteManyCommand cmd, ConsistentHash ch, Set<Integer> segments) {
            ReadWriteManyCommand copy = new ReadWriteManyCommand(cmd).withKeys(new ReadOnlySegmentAwareCollection(cmd.getAffectedKeys(), ch, segments));
            copy.setForwarded(true);
            return copy;
        }

        @Override
        public Collection<Object> getItems(ReadWriteManyCommand cmd) {
            return cmd.getAffectedKeys();
        }

        @Override
        public Object item2key(Object key) {
            return key;
        }

        @Override
        public Collection<Object> newContainer() {
            return new ArrayList<Object>();
        }

        @Override
        public void accumulate(Collection<Object> list, Object key) {
            list.add(key);
        }

        @Override
        public int containerSize(Collection<Object> list) {
            return list.size();
        }

        @Override
        public boolean shouldRegisterRemoteCallback(ReadWriteManyCommand cmd, ConsistentHash ch) {
            return !cmd.isForwarded() && ch.getNumOwners() > 1;
        }

        @Override
        public Object transformResult(Object[] results) {
            return results == null ? null : Arrays.asList(results);
        }
    }

    private class ReadWriteManyEntriesHelper
    extends WriteManyCommandHelper<ReadWriteManyEntriesCommand, Map<Object, Object>, Map.Entry<Object, Object>> {
        private ReadWriteManyEntriesHelper() {
        }

        @Override
        public ReadWriteManyEntriesCommand copyForLocal(ReadWriteManyEntriesCommand cmd, Map<Object, Object> entries) {
            return new ReadWriteManyEntriesCommand(cmd).withEntries(entries);
        }

        @Override
        public ReadWriteManyEntriesCommand copyForPrimary(ReadWriteManyEntriesCommand cmd, ConsistentHash ch, Set<Integer> segments) {
            return new ReadWriteManyEntriesCommand(cmd).withEntries(new ReadOnlySegmentAwareMap(cmd.getEntries(), ch, segments));
        }

        @Override
        public ReadWriteManyEntriesCommand copyForBackup(ReadWriteManyEntriesCommand cmd, ConsistentHash ch, Set<Integer> segments) {
            ReadWriteManyEntriesCommand copy = new ReadWriteManyEntriesCommand(cmd).withEntries(new ReadOnlySegmentAwareMap(cmd.getEntries(), ch, segments));
            copy.setForwarded(true);
            return copy;
        }

        @Override
        public Collection<Map.Entry<Object, Object>> getItems(ReadWriteManyEntriesCommand cmd) {
            return cmd.getEntries().entrySet();
        }

        @Override
        public Object item2key(Map.Entry<Object, Object> entry) {
            return entry.getKey();
        }

        @Override
        public Map<Object, Object> newContainer() {
            return new HashMap<Object, Object>();
        }

        @Override
        public void accumulate(Map<Object, Object> map, Map.Entry<Object, Object> entry) {
            map.put(entry.getKey(), entry.getValue());
        }

        @Override
        public int containerSize(Map<Object, Object> map) {
            return map.size();
        }

        @Override
        public boolean shouldRegisterRemoteCallback(ReadWriteManyEntriesCommand cmd, ConsistentHash ch) {
            return !cmd.isForwarded() && ch.getNumOwners() > 1;
        }

        @Override
        public Object transformResult(Object[] results) {
            return results == null ? null : Arrays.asList(results);
        }
    }

    private class PutMapHelper
    extends WriteManyCommandHelper<PutMapCommand, Map<Object, Object>, Map.Entry<Object, Object>> {
        private PutMapHelper() {
        }

        @Override
        public PutMapCommand copyForLocal(PutMapCommand cmd, Map<Object, Object> container) {
            return new PutMapCommand(cmd).withMap(container);
        }

        @Override
        public PutMapCommand copyForPrimary(PutMapCommand cmd, ConsistentHash ch, Set<Integer> segments) {
            return new PutMapCommand(cmd).withMap(new ReadOnlySegmentAwareMap<Object, Object>(cmd.getMap(), ch, segments));
        }

        @Override
        public PutMapCommand copyForBackup(PutMapCommand cmd, ConsistentHash ch, Set<Integer> segments) {
            PutMapCommand copy = new PutMapCommand(cmd).withMap(new ReadOnlySegmentAwareMap<Object, Object>(cmd.getMap(), ch, segments));
            copy.setForwarded(true);
            return copy;
        }

        @Override
        public Collection<Map.Entry<Object, Object>> getItems(PutMapCommand cmd) {
            return cmd.getMap().entrySet();
        }

        @Override
        public Object item2key(Map.Entry<Object, Object> entry) {
            return entry.getKey();
        }

        @Override
        public Map<Object, Object> newContainer() {
            return new HashMap<Object, Object>();
        }

        @Override
        public void accumulate(Map<Object, Object> map, Map.Entry<Object, Object> entry) {
            map.put(entry.getKey(), entry.getValue());
        }

        @Override
        public int containerSize(Map<Object, Object> map) {
            return map.size();
        }

        @Override
        public boolean shouldRegisterRemoteCallback(PutMapCommand cmd, ConsistentHash ch) {
            return !cmd.isForwarded() && ch.getNumOwners() > 1;
        }

        @Override
        public Object transformResult(Object[] results) {
            if (results == null) {
                return null;
            }
            HashMap result = new HashMap();
            for (Object r : results) {
                Map.Entry entry = (Map.Entry)r;
                result.put(entry.getKey(), entry.getValue());
            }
            return result;
        }
    }

    private abstract class WriteManyCommandHelper<C extends WriteCommand, Container, Item>
    implements InvocationSuccessFunction {
        private WriteManyCommandHelper() {
        }

        public abstract C copyForLocal(C var1, Container var2);

        public abstract C copyForPrimary(C var1, ConsistentHash var2, Set<Integer> var3);

        public abstract C copyForBackup(C var1, ConsistentHash var2, Set<Integer> var3);

        public abstract Collection<Item> getItems(C var1);

        public abstract Object item2key(Item var1);

        public abstract Container newContainer();

        public abstract void accumulate(Container var1, Item var2);

        public abstract int containerSize(Container var1);

        public abstract boolean shouldRegisterRemoteCallback(C var1, ConsistentHash var2);

        public abstract Object transformResult(Object[] var1);

        @Override
        public Object apply(InvocationContext rCtx, VisitableCommand rCommand, Object rv) throws Throwable {
            WriteCommand original = (WriteCommand)rCommand;
            ConsistentHash ch = NonTxDistributionInterceptor.this.checkTopologyId(original).getWriteConsistentHash();
            Map backups = NonTxDistributionInterceptor.this.backupOwnersOfSegments(ch, ch.getPrimarySegmentsForOwner(NonTxDistributionInterceptor.this.rpcManager.getAddress()));
            if (backups.isEmpty()) {
                return rv;
            }
            boolean isSync = NonTxDistributionInterceptor.this.isSynchronous(original);
            CompletableFuture[] futures = isSync ? new CompletableFuture[backups.size()] : null;
            int future = 0;
            for (Map.Entry backup : backups.entrySet()) {
                WriteCommand copy = this.copyForBackup(original, ch, (Set)backup.getValue());
                if (isSync) {
                    futures[future++] = NonTxDistributionInterceptor.this.rpcManager.invokeRemotelyAsync(Collections.singleton(backup.getKey()), copy, NonTxDistributionInterceptor.this.defaultSyncOptions);
                    continue;
                }
                NonTxDistributionInterceptor.this.rpcManager.invokeRemotelyAsync(Collections.singleton(backup.getKey()), copy, NonTxDistributionInterceptor.this.defaultAsyncOptions);
            }
            return isSync ? BaseAsyncInterceptor.asyncValue(CompletableFuture.allOf(futures).thenApply(nil -> rv)) : rv;
        }
    }

    private static final class MutableInt {
        public int value;

        private MutableInt() {
        }
    }
}

