/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.atomic.impl.AtomicHashMap;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.FunctionalCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.api.functional.Param;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.DeltaAwareCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.impl.JmxStatsCommandInterceptor;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.marshall.core.MarshalledEntryImpl;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="CacheStore", description="Component that handles storing of entries to a CacheStore from memory.")
public class CacheWriterInterceptor
extends JmxStatsCommandInterceptor {
    private final boolean trace = this.getLog().isTraceEnabled();
    PersistenceConfiguration loaderConfig = null;
    final AtomicLong cacheStores = new AtomicLong(0L);
    protected PersistenceManager persistenceManager;
    private InternalEntryFactory entryFactory;
    private TransactionManager transactionManager;
    private StreamingMarshaller marshaller;
    private static final Log log = LogFactory.getLog(CacheWriterInterceptor.class);

    protected Log getLog() {
        return log;
    }

    @Inject
    protected void init(PersistenceManager pm, InternalEntryFactory entryFactory, TransactionManager transactionManager, StreamingMarshaller marshaller) {
        this.persistenceManager = pm;
        this.entryFactory = entryFactory;
        this.transactionManager = transactionManager;
        this.marshaller = marshaller;
    }

    @Start(priority=15)
    protected void start() {
        this.setStatisticsEnabled(this.cacheConfiguration.jmxStatistics().enabled());
        this.loaderConfig = this.cacheConfiguration.persistence();
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        this.commitCommand(ctx);
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (command.isOnePhaseCommit()) {
            this.commitCommand(ctx);
        }
        return this.invokeNext(ctx, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitCommand(TxInvocationContext ctx) throws Throwable {
        if (!((AbstractCacheTransaction)ctx.getCacheTransaction()).getAllModifications().isEmpty()) {
            GlobalTransaction tx = ctx.getGlobalTransaction();
            if (this.trace) {
                this.getLog().tracef("Calling loader.commit() for transaction %s", tx);
            }
            Transaction xaTx = null;
            try {
                xaTx = this.suspendRunningTx(ctx);
                this.store(ctx);
            }
            finally {
                this.resumeRunningTx(xaTx);
            }
        } else if (this.trace) {
            this.getLog().trace("Commit called with no modifications; ignoring.");
        }
    }

    private void resumeRunningTx(Transaction xaTx) throws InvalidTransactionException, SystemException {
        if (this.transactionManager != null && xaTx != null) {
            this.transactionManager.resume(xaTx);
        }
    }

    private Transaction suspendRunningTx(TxInvocationContext ctx) throws SystemException {
        Transaction xaTx = null;
        if (this.transactionManager != null && (xaTx = this.transactionManager.suspend()) != null && !ctx.isOriginLocal()) {
            throw new IllegalStateException("It is only possible to be in the context of an JRA transaction in the local node.");
        }
        return xaTx;
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.invokeNextThenAccept(ctx, command, (rCtx, rCommand, rv) -> {
            RemoveCommand removeCommand = (RemoveCommand)rCommand;
            if (!this.isStoreEnabled(removeCommand) || rCtx.isInTxScope() || !removeCommand.isSuccessful()) {
                return;
            }
            if (!this.isProperWriter(rCtx, removeCommand, removeCommand.getKey())) {
                return;
            }
            Object key = removeCommand.getKey();
            boolean resp = this.persistenceManager.deleteFromAllStores(key, PersistenceManager.AccessMode.BOTH);
            if (this.trace) {
                this.getLog().tracef("Removed entry under key %s and got response %s from CacheStore", key, resp);
            }
        });
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        if (this.isStoreEnabled(command) && !ctx.isInTxScope()) {
            this.persistenceManager.clearAllStores(ctx.isOriginLocal() ? PersistenceManager.AccessMode.BOTH : PersistenceManager.AccessMode.PRIVATE);
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.invokeNextThenAccept(ctx, command, (rCtx, rCommand, rv) -> {
            PutKeyValueCommand putKeyValueCommand = (PutKeyValueCommand)rCommand;
            if (!this.isStoreEnabled(putKeyValueCommand) || rCtx.isInTxScope() || !putKeyValueCommand.isSuccessful()) {
                return;
            }
            if (!this.isProperWriter(rCtx, putKeyValueCommand, putKeyValueCommand.getKey())) {
                return;
            }
            Object key = putKeyValueCommand.getKey();
            this.storeEntry(rCtx, key, putKeyValueCommand);
            if (this.getStatisticsEnabled()) {
                this.cacheStores.incrementAndGet();
            }
        });
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.invokeNextThenAccept(ctx, command, (rCtx, rCommand, rv) -> {
            ReplaceCommand replaceCommand = (ReplaceCommand)rCommand;
            if (!this.isStoreEnabled(replaceCommand) || rCtx.isInTxScope() || !replaceCommand.isSuccessful()) {
                return;
            }
            if (!this.isProperWriter(rCtx, replaceCommand, replaceCommand.getKey())) {
                return;
            }
            Object key = replaceCommand.getKey();
            this.storeEntry(rCtx, key, replaceCommand);
            if (this.getStatisticsEnabled()) {
                this.cacheStores.incrementAndGet();
            }
        });
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.invokeNextThenAccept(ctx, command, (rCtx, rCommand, rv) -> {
            PutMapCommand putMapCommand = (PutMapCommand)rCommand;
            if (!this.isStoreEnabled(putMapCommand) || rCtx.isInTxScope()) {
                return;
            }
            Map<Object, Object> map = putMapCommand.getMap();
            for (Object key : map.keySet()) {
                if (!this.isProperWriter(rCtx, putMapCommand, key)) continue;
                this.storeEntry(rCtx, key, putMapCommand);
            }
            if (this.getStatisticsEnabled()) {
                this.cacheStores.getAndAdd(map.size());
            }
        });
    }

    @Override
    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
        return this.visitWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) throws Throwable {
        return this.visitWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) throws Throwable {
        return this.visitWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) throws Throwable {
        return this.visitWriteCommand(ctx, command);
    }

    private <T extends DataWriteCommand & FunctionalCommand> Object visitWriteCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
        return this.invokeNextThenAccept(ctx, command, (rCtx, rCommand, rv) -> {
            DataWriteCommand dataWriteCommand = (DataWriteCommand)rCommand;
            if (!this.isStoreEnabled(dataWriteCommand) || rCtx.isInTxScope() || !dataWriteCommand.isSuccessful()) {
                return;
            }
            if (!this.isProperWriter(rCtx, dataWriteCommand, dataWriteCommand.getKey())) {
                return;
            }
            Param persistMode = ((FunctionalCommand)((Object)dataWriteCommand)).getParams().get(0);
            switch ((Param.PersistenceMode)persistMode.get()) {
                case PERSIST: {
                    Object key = dataWriteCommand.getKey();
                    CacheEntry entry = rCtx.lookupEntry(key);
                    if (entry != null) {
                        if (entry.isRemoved()) {
                            boolean resp = this.persistenceManager.deleteFromAllStores(key, PersistenceManager.AccessMode.BOTH);
                            if (this.trace) {
                                this.getLog().tracef("Removed entry under key %s and got response %s from CacheStore", key, resp);
                            }
                        } else if (entry.isChanged()) {
                            this.storeEntry(rCtx, key, dataWriteCommand);
                        }
                    }
                    log.trace("Skipping cache store since entry was not found in context");
                    break;
                }
                case SKIP: {
                    log.trace("Skipping cache store since persistence mode parameter is SKIP");
                }
            }
        });
    }

    @Override
    public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) throws Throwable {
        return this.visitWriteManyCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) throws Throwable {
        return this.visitWriteManyCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) throws Throwable {
        return this.visitWriteManyCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) throws Throwable {
        return this.visitWriteManyCommand(ctx, command);
    }

    private <T extends WriteCommand & FunctionalCommand> Object visitWriteManyCommand(InvocationContext ctx, WriteCommand command) throws Throwable {
        return this.invokeNextThenAccept(ctx, command, (rCtx, rCommand, rv) -> {
            WriteCommand manyEntriesCommand = (WriteCommand)rCommand;
            if (!this.isStoreEnabled(manyEntriesCommand) || rCtx.isInTxScope()) {
                return;
            }
            Param persistMode = ((FunctionalCommand)((Object)manyEntriesCommand)).getParams().get(0);
            switch ((Param.PersistenceMode)persistMode.get()) {
                case PERSIST: {
                    int storedCount = 0;
                    for (Object key : ((WriteCommand)rCommand).getAffectedKeys()) {
                        CacheEntry entry = rCtx.lookupEntry(key);
                        if (entry == null) continue;
                        if (entry.isRemoved()) {
                            boolean resp = this.persistenceManager.deleteFromAllStores(key, PersistenceManager.AccessMode.BOTH);
                            if (!this.trace) continue;
                            this.getLog().tracef("Removed entry under key %s and got response %s from CacheStore", key, resp);
                            continue;
                        }
                        if (!entry.isChanged() || !this.isProperWriter(rCtx, manyEntriesCommand, key)) continue;
                        this.storeEntry(rCtx, key, manyEntriesCommand);
                        ++storedCount;
                    }
                    if (!this.getStatisticsEnabled()) break;
                    this.cacheStores.getAndAdd(storedCount);
                    break;
                }
                case SKIP: {
                    log.trace("Skipping cache store since persistence mode parameter is SKIP");
                }
            }
        });
    }

    protected final void store(TxInvocationContext ctx) throws Throwable {
        List<WriteCommand> modifications = ((AbstractCacheTransaction)ctx.getCacheTransaction()).getAllModifications();
        if (modifications.isEmpty()) {
            if (this.trace) {
                this.getLog().trace("Transaction has not logged any modifications!");
            }
            return;
        }
        if (this.trace) {
            this.getLog().tracef("Cache loader modification list: %s", modifications);
        }
        Updater modsBuilder = new Updater(this.getStatisticsEnabled());
        for (WriteCommand cacheCommand : modifications) {
            if (!this.isStoreEnabled(cacheCommand)) continue;
            cacheCommand.acceptVisitor(ctx, modsBuilder);
        }
        if (this.getStatisticsEnabled() && modsBuilder.putCount > 0) {
            this.cacheStores.getAndAdd(modsBuilder.putCount);
        }
    }

    protected boolean isStoreEnabled(FlagAffectedCommand command) {
        if (command.hasAnyFlag(FlagBitSets.SKIP_CACHE_STORE)) {
            log.trace("Skipping cache store since the call contain a skip cache store flag");
            return false;
        }
        return true;
    }

    protected boolean isProperWriter(InvocationContext ctx, FlagAffectedCommand command, Object key) {
        return true;
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset statistics")
    public void resetStatistics() {
        this.cacheStores.set(0L);
    }

    @ManagedAttribute(description="Number of writes to the store", displayName="Number of writes to the store", measurementType=MeasurementType.TRENDSUP)
    public long getWritesToTheStores() {
        return this.cacheStores.get();
    }

    void storeEntry(InvocationContext ctx, Object key, FlagAffectedCommand command) {
        InternalCacheValue sv = this.getStoredValue(key, ctx);
        this.persistenceManager.writeToAllNonTxStores(new MarshalledEntryImpl(key, sv.getValue(), PersistenceUtil.internalMetadata(sv), this.marshaller), this.skipSharedStores(ctx, key, command) ? PersistenceManager.AccessMode.PRIVATE : PersistenceManager.AccessMode.BOTH, command.getFlagsBitSet());
        if (this.trace) {
            this.getLog().tracef("Stored entry %s under key %s", sv, key);
        }
    }

    protected boolean skipSharedStores(InvocationContext ctx, Object key, FlagAffectedCommand command) {
        return !ctx.isOriginLocal() || command.hasAnyFlag(FlagBitSets.SKIP_SHARED_CACHE_STORE);
    }

    InternalCacheValue getStoredValue(Object key, InvocationContext ctx) {
        EntryVersion version;
        EntryVersionsMap updatedVersions;
        CacheEntry entry = ctx.lookupEntry(key);
        if (entry instanceof InternalCacheEntry) {
            return ((InternalCacheEntry)entry).toInternalCacheValue();
        }
        if (ctx.isInTxScope() && (updatedVersions = ((AbstractCacheTransaction)((TxInvocationContext)ctx).getCacheTransaction()).getUpdatedEntryVersions()) != null && (version = (EntryVersion)updatedVersions.get(entry.getKey())) != null) {
            Metadata metadata = entry.getMetadata();
            if (metadata == null) {
                metadata = new EmbeddedMetadata.Builder().lifespan(entry.getLifespan()).maxIdle(entry.getMaxIdle()).version(version).build();
                return this.entryFactory.create(entry.getKey(), entry.getValue(), metadata).toInternalCacheValue();
            }
            metadata = metadata.builder().version(version).build();
            return this.entryFactory.create(entry.getKey(), entry.getValue(), metadata).toInternalCacheValue();
        }
        return this.entryFactory.create(entry).toInternalCacheValue();
    }

    public class Updater
    extends AbstractVisitor {
        protected final boolean generateStatistics;
        int putCount;

        public Updater(boolean generateStatistics) {
            this.generateStatistics = generateStatistics;
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            return this.visitSingleStore(ctx, command, command.getKey());
        }

        @Override
        public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
            if (CacheWriterInterceptor.this.isProperWriter(ctx, command, command.getKey())) {
                InternalCacheEntry ice;
                CacheEntry entry;
                if (this.generateStatistics) {
                    ++this.putCount;
                }
                if ((entry = ctx.lookupEntry(command.getKey())).getValue() == null) {
                    return null;
                }
                if (entry instanceof InternalCacheEntry) {
                    ice = (InternalCacheEntry)entry;
                } else if (entry instanceof DeltaAwareCacheEntry) {
                    AtomicHashMap<?, ?> uncommittedChanges = ((DeltaAwareCacheEntry)entry).getUncommittedChages();
                    ice = CacheWriterInterceptor.this.entryFactory.create(entry.getKey(), uncommittedChanges, entry.getMetadata(), entry.getLifespan(), entry.getMaxIdle());
                } else {
                    ice = CacheWriterInterceptor.this.entryFactory.create(entry);
                }
                MarshalledEntryImpl marshalledEntry = new MarshalledEntryImpl(ice.getKey(), ice.getValue(), PersistenceUtil.internalMetadata(ice), CacheWriterInterceptor.this.marshaller);
                CacheWriterInterceptor.this.persistenceManager.writeToAllNonTxStores(marshalledEntry, CacheWriterInterceptor.this.skipSharedStores(ctx, command.getKey(), command) ? PersistenceManager.AccessMode.PRIVATE : PersistenceManager.AccessMode.BOTH);
            }
            return null;
        }

        @Override
        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
            return this.visitSingleStore(ctx, command, command.getKey());
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            Map<Object, Object> map = command.getMap();
            for (Object key : map.keySet()) {
                this.visitSingleStore(ctx, command, key);
            }
            return null;
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            Object key = command.getKey();
            if (CacheWriterInterceptor.this.isProperWriter(ctx, command, key)) {
                CacheWriterInterceptor.this.persistenceManager.deleteFromAllStores(key, CacheWriterInterceptor.this.skipSharedStores(ctx, key, command) ? PersistenceManager.AccessMode.PRIVATE : PersistenceManager.AccessMode.BOTH);
            }
            return null;
        }

        @Override
        public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
            CacheWriterInterceptor.this.persistenceManager.clearAllStores(ctx.isOriginLocal() ? PersistenceManager.AccessMode.PRIVATE : PersistenceManager.AccessMode.BOTH);
            return null;
        }

        protected Object visitSingleStore(InvocationContext ctx, FlagAffectedCommand command, Object key) throws Throwable {
            if (CacheWriterInterceptor.this.isProperWriter(ctx, command, key)) {
                InternalCacheValue sv;
                if (this.generateStatistics) {
                    ++this.putCount;
                }
                if ((sv = CacheWriterInterceptor.this.entryFactory.getValueFromCtxOrCreateNew(key, ctx)).getValue() != null) {
                    MarshalledEntryImpl me = new MarshalledEntryImpl(key, sv.getValue(), PersistenceUtil.internalMetadata(sv), CacheWriterInterceptor.this.marshaller);
                    CacheWriterInterceptor.this.persistenceManager.writeToAllNonTxStores(me, CacheWriterInterceptor.this.skipSharedStores(ctx, key, command) ? PersistenceManager.AccessMode.PRIVATE : PersistenceManager.AccessMode.BOTH);
                }
            }
            return null;
        }
    }
}

