/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.Map;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.impl.CacheWriterInterceptor;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DistCacheWriterInterceptor
extends CacheWriterInterceptor {
    private static final Log log = LogFactory.getLog(DistCacheWriterInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private DistributionManager dm;
    private boolean isUsingLockDelegation;

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void inject(DistributionManager dm) {
        this.dm = dm;
    }

    @Override
    @Start(priority=25)
    protected void start() {
        super.start();
        this.isUsingLockDelegation = !this.cacheConfiguration.transaction().transactionMode().isTransactional();
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            PutKeyValueCommand putKeyValueCommand = (PutKeyValueCommand)rCommand;
            Object key = putKeyValueCommand.getKey();
            if (!(putKeyValueCommand.hasAnyFlag(FlagBitSets.ROLLING_UPGRADE) || this.isStoreEnabled(putKeyValueCommand) && !rCtx.isInTxScope() && putKeyValueCommand.isSuccessful())) {
                return rv;
            }
            if (!this.isProperWriter(rCtx, putKeyValueCommand, putKeyValueCommand.getKey())) {
                return rv;
            }
            this.storeEntry(rCtx, key, putKeyValueCommand);
            if (this.getStatisticsEnabled()) {
                this.cacheStores.incrementAndGet();
            }
            return rv;
        });
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        if (!this.isStoreEnabled(command) || ctx.isInTxScope()) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextThenAccept(ctx, command, (rCtx, rCommand, rv) -> {
            PutMapCommand putMapCommand = (PutMapCommand)rCommand;
            LocalizedCacheTopology cacheTopology = this.dm.getCacheTopology();
            Map<Object, Object> map = putMapCommand.getMap();
            int count = 0;
            for (Object key : map.keySet()) {
                if (this.isUsingLockDelegation && putMapCommand.isForwarded() && !cacheTopology.getDistribution(key).primary().equals(rCtx.getOrigin()) || !this.isProperWriter(rCtx, putMapCommand, key)) continue;
                this.storeEntry(rCtx, key, putMapCommand);
                ++count;
            }
            if (this.getStatisticsEnabled()) {
                this.cacheStores.getAndAdd(count);
            }
        });
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            RemoveCommand removeCommand = (RemoveCommand)rCommand;
            Object key = removeCommand.getKey();
            if (!this.isStoreEnabled(removeCommand) || rCtx.isInTxScope() || !removeCommand.isSuccessful()) {
                return rv;
            }
            if (!this.isProperWriter(rCtx, removeCommand, key)) {
                return rv;
            }
            boolean resp = this.persistenceManager.deleteFromAllStores(key, this.skipSharedStores(rCtx, key, removeCommand) ? PersistenceManager.AccessMode.PRIVATE : PersistenceManager.AccessMode.BOTH);
            if (trace) {
                log.tracef("Removed entry under key %s and got response %s from CacheStore", key, resp);
            }
            return rv;
        });
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            ReplaceCommand replaceCommand = (ReplaceCommand)rCommand;
            Object key = replaceCommand.getKey();
            if (!this.isStoreEnabled(replaceCommand) || rCtx.isInTxScope() || !replaceCommand.isSuccessful()) {
                return rv;
            }
            if (!this.isProperWriter(rCtx, replaceCommand, replaceCommand.getKey())) {
                return rv;
            }
            this.storeEntry(rCtx, key, replaceCommand);
            if (this.getStatisticsEnabled()) {
                this.cacheStores.incrementAndGet();
            }
            return rv;
        });
    }

    @Override
    protected boolean skipSharedStores(InvocationContext ctx, Object key, FlagAffectedCommand command) {
        return !this.dm.getCacheTopology().getDistribution(key).isPrimary() || command.hasAnyFlag(FlagBitSets.SKIP_SHARED_CACHE_STORE);
    }

    @Override
    protected boolean isProperWriter(InvocationContext ctx, FlagAffectedCommand command, Object key) {
        if (command.hasAnyFlag(FlagBitSets.SKIP_OWNERSHIP_CHECK)) {
            return true;
        }
        if (this.isUsingLockDelegation && ctx.isOriginLocal() && !command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL)) {
            return this.dm.getCacheTopology().getDistribution(key).isPrimary();
        }
        return this.dm.getCacheTopology().isWriteOwner(key);
    }
}

