/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.InvocationCallback;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.impl.QueueAsyncInvocationStage;
import org.infinispan.util.concurrent.CompletableFutures;

public class SimpleAsyncInvocationStage
extends InvocationStage {
    protected final CompletableFuture<Object> future;

    public SimpleAsyncInvocationStage(CompletionStage<?> future) {
        this.future = (CompletableFuture)future;
    }

    public SimpleAsyncInvocationStage(Throwable throwable) {
        this.future = CompletableFutures.completedExceptionFuture(throwable);
    }

    @Override
    public Object get() throws Throwable {
        try {
            return CompletableFutures.await(this.future);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public CompletableFuture<Object> toCompletableFuture() {
        return this.future;
    }

    @Override
    public Object addCallback(InvocationContext ctx, VisitableCommand command, InvocationCallback function) {
        if (this.future.isDone()) {
            Throwable throwable;
            Object rv;
            try {
                rv = this.future.getNow(null);
                throwable = null;
            }
            catch (Throwable t) {
                rv = null;
                throwable = CompletableFutures.extractException(t);
            }
            try {
                return function.apply(ctx, command, rv, throwable);
            }
            catch (Throwable t) {
                return new SimpleAsyncInvocationStage(t);
            }
        }
        return new QueueAsyncInvocationStage(ctx, command, this.future, function);
    }
}

