/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security.impl;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.atomic.Delta;
import org.infinispan.batch.BatchContainer;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.filter.KeyFilter;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.SecureCache;
import org.infinispan.stats.Stats;
import org.infinispan.util.concurrent.locks.LockManager;

public final class SecureCacheImpl<K, V>
implements SecureCache<K, V> {
    private final AuthorizationManager authzManager;
    private final AdvancedCache<K, V> delegate;
    private final Subject subject;

    public SecureCacheImpl(AdvancedCache<K, V> delegate) {
        this(delegate, delegate.getAuthorizationManager(), null);
    }

    private SecureCacheImpl(AdvancedCache<K, V> delegate, AuthorizationManager authzManager, Subject subject) {
        this.authzManager = authzManager;
        this.delegate = delegate;
        this.subject = subject;
    }

    public AdvancedCache<K, V> getDelegate() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return this.delegate;
    }

    @Override
    public AdvancedCache<K, V> withSubject(Subject subject) {
        if (this.subject == null) {
            return new SecureCacheImpl<K, V>(this.delegate, this.authzManager, subject);
        }
        throw new IllegalArgumentException("Cannot set a Subject on a SecureCache more than once");
    }

    public boolean startBatch() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.startBatch();
    }

    @Override
    public <C> void addListener(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.LISTEN);
        this.delegate.addListener(listener, filter, converter);
    }

    @Override
    public void addListener(Object listener, KeyFilter<? super K> filter) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.LISTEN);
        this.delegate.addListener(listener, filter);
    }

    @Override
    public void addListener(Object listener) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.LISTEN);
        this.delegate.addListener(listener);
    }

    @Override
    public <C> void addFilteredListener(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.LISTEN);
        this.delegate.addFilteredListener(listener, filter, converter, filterAnnotations);
    }

    public void start() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.LIFECYCLE);
        this.delegate.start();
    }

    @Override
    public void stop() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.LIFECYCLE);
        this.delegate.stop();
    }

    public CompletableFuture<V> putAsync(K key, V value) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.putAsync(key, value);
    }

    public void endBatch(boolean successful) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        this.delegate.endBatch(successful);
    }

    @Override
    public void removeListener(Object listener) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.LISTEN);
        this.delegate.removeListener(listener);
    }

    @Override
    public Set<Object> getListeners() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.LISTEN);
        return this.delegate.getListeners();
    }

    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.putAsync(key, value, lifespan, unit);
    }

    @Override
    public AdvancedCache<K, V> withFlags(Flag ... flags) {
        return new SecureCacheImpl<K, V>(this.delegate.withFlags(flags), this.authzManager, this.subject);
    }

    public V putIfAbsent(K key, V value) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return (V)this.delegate.putIfAbsent(key, value);
    }

    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.putAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public String getName() {
        return this.delegate.getName();
    }

    public String getVersion() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return this.delegate.getVersion();
    }

    public V put(K key, V value) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return (V)this.delegate.put(key, value);
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.putAllAsync(data);
    }

    public V put(K key, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return (V)this.delegate.put(key, value, lifespan, unit);
    }

    public boolean remove(Object key, Object value) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.remove(key, value);
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.putAllAsync(data, lifespan, unit);
    }

    @Override
    public void addInterceptor(CommandInterceptor i, int position) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        this.delegate.addInterceptor(i, position);
    }

    @Override
    public AsyncInterceptorChain getAsyncInterceptorChain() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return this.delegate.getAsyncInterceptorChain();
    }

    public V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return (V)this.delegate.putIfAbsent(key, value, lifespan, unit);
    }

    @Override
    public boolean addInterceptorAfter(CommandInterceptor i, Class<? extends CommandInterceptor> afterInterceptor) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return this.delegate.addInterceptorAfter(i, afterInterceptor);
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.putAllAsync(data, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        this.delegate.putAll(map, lifespan, unit);
    }

    @Override
    public boolean addInterceptorBefore(CommandInterceptor i, Class<? extends CommandInterceptor> beforeInterceptor) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return this.delegate.addInterceptorBefore(i, beforeInterceptor);
    }

    public boolean replace(K key, V oldValue, V newValue) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.replace(key, oldValue, newValue);
    }

    public CompletableFuture<Void> clearAsync() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.BULK_WRITE);
        return this.delegate.clearAsync();
    }

    public V replace(K key, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return (V)this.delegate.replace(key, value, lifespan, unit);
    }

    @Override
    public void removeInterceptor(int position) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        this.delegate.removeInterceptor(position);
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.putIfAbsentAsync(key, value);
    }

    @Override
    public void removeInterceptor(Class<? extends CommandInterceptor> interceptorType) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        this.delegate.removeInterceptor(interceptorType);
    }

    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.replace(key, oldValue, value, lifespan, unit);
    }

    @Override
    public List<CommandInterceptor> getInterceptorChain() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return this.delegate.getInterceptorChain();
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.putIfAbsentAsync(key, value, lifespan, unit);
    }

    public V replace(K key, V value) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return (V)this.delegate.replace(key, value);
    }

    @Override
    public EvictionManager getEvictionManager() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return this.delegate.getEvictionManager();
    }

    @Override
    public ExpirationManager<K, V> getExpirationManager() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return this.delegate.getExpirationManager();
    }

    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return (V)this.delegate.put(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public void putForExternalRead(K key, V value) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        this.delegate.putForExternalRead(key, value);
    }

    @Override
    public void putForExternalRead(K key, V value, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        this.delegate.putForExternalRead(key, value);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        this.delegate.putForExternalRead(key, value);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        this.delegate.putForExternalRead(key, value);
    }

    @Override
    public ComponentRegistry getComponentRegistry() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return this.delegate.getComponentRegistry();
    }

    @Override
    public DistributionManager getDistributionManager() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return this.delegate.getDistributionManager();
    }

    @Override
    public AuthorizationManager getAuthorizationManager() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return new AuthorizationManager(){

            @Override
            public void checkPermission(AuthorizationPermission permission) {
                SecureCacheImpl.this.authzManager.checkPermission(SecureCacheImpl.this.subject, permission);
            }

            @Override
            public void checkPermission(Subject subject, AuthorizationPermission permission) {
                SecureCacheImpl.this.authzManager.checkPermission(subject, permission);
            }

            @Override
            public void checkPermission(AuthorizationPermission permission, String role) {
                SecureCacheImpl.this.authzManager.checkPermission(SecureCacheImpl.this.subject, permission, role);
            }

            @Override
            public void checkPermission(Subject subject, AuthorizationPermission permission, String role) {
                SecureCacheImpl.this.authzManager.checkPermission(subject, permission, role);
            }
        };
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.putIfAbsentAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public boolean isEmpty() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.READ);
        return this.delegate.isEmpty();
    }

    @Override
    public boolean lock(K ... keys) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.lock(keys);
    }

    public boolean containsKey(Object key) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.READ);
        return this.delegate.containsKey(key);
    }

    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return (V)this.delegate.putIfAbsent(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public boolean lock(Collection<? extends K> keys) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.lock(keys);
    }

    public CompletableFuture<V> removeAsync(Object key) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.removeAsync(key);
    }

    public boolean containsValue(Object value) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.READ);
        return this.delegate.containsValue(value);
    }

    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        this.delegate.putAll(map, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public CompletableFuture<Boolean> removeAsync(Object key, Object value) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.removeAsync(key, value);
    }

    @Override
    public void applyDelta(K deltaAwareValueKey, Delta delta, Object ... locksToAcquire) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        this.delegate.applyDelta(deltaAwareValueKey, delta, locksToAcquire);
    }

    @Override
    public void evict(K key) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        this.delegate.evict(key);
    }

    public CompletableFuture<V> replaceAsync(K key, V value) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.replaceAsync(key, value);
    }

    @Override
    public RpcManager getRpcManager() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return this.delegate.getRpcManager();
    }

    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return (V)this.delegate.replace(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public V get(Object key) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.READ);
        return (V)this.delegate.get(key);
    }

    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.replaceAsync(key, value, lifespan, unit);
    }

    @Override
    public BatchContainer getBatchContainer() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.getBatchContainer();
    }

    @Override
    public Configuration getCacheConfiguration() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return this.delegate.getCacheConfiguration();
    }

    @Override
    public EmbeddedCacheManager getCacheManager() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return this.delegate.getCacheManager();
    }

    @Override
    public InvocationContextContainer getInvocationContextContainer() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return this.delegate.getInvocationContextContainer();
    }

    @Override
    public AdvancedCache<K, V> getAdvancedCache() {
        return this;
    }

    @Override
    public ComponentStatus getStatus() {
        return this.delegate.getStatus();
    }

    @Override
    public AvailabilityMode getAvailability() {
        return this.delegate.getAvailability();
    }

    @Override
    public void setAvailability(AvailabilityMode availabilityMode) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        this.delegate.setAvailability(availabilityMode);
    }

    @Override
    public CacheSet<CacheEntry<K, V>> cacheEntrySet() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.BULK_READ);
        return this.delegate.cacheEntrySet();
    }

    @Override
    public void removeExpired(K key, V value, Long lifespan) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        this.delegate.removeExpired(key, value, lifespan);
    }

    @Override
    public int size() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.BULK_READ);
        return this.delegate.size();
    }

    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.replace(key, oldValue, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public DataContainer<K, V> getDataContainer() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return this.delegate.getDataContainer();
    }

    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.replaceAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.delegate.getTransactionManager();
    }

    @Override
    public CacheSet<K> keySet() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.BULK_READ);
        return this.delegate.keySet();
    }

    public V remove(Object key) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return (V)this.delegate.remove(key);
    }

    @Override
    public Map<K, V> getAll(Set<?> keys) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.BULK_READ);
        return this.delegate.getAll(keys);
    }

    @Override
    public LockManager getLockManager() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.getLockManager();
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.replaceAsync(key, oldValue, newValue);
    }

    @Override
    public Stats getStats() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return this.delegate.getStats();
    }

    @Override
    public XAResource getXAResource() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.ADMIN);
        return this.delegate.getXAResource();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.delegate.getClassLoader();
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit unit) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.replaceAsync(key, oldValue, newValue, lifespan, unit);
    }

    @Override
    public CacheCollection<V> values() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.BULK_READ);
        return this.delegate.values();
    }

    @Override
    public AdvancedCache<K, V> with(ClassLoader classLoader) {
        return new SecureCacheImpl<K, V>(this.delegate.with(classLoader));
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.replaceAsync(key, oldValue, newValue, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public CacheSet<Map.Entry<K, V>> entrySet() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.BULK_READ);
        return this.delegate.entrySet();
    }

    public CompletableFuture<V> getAsync(K key) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.READ);
        return this.delegate.getAsync(key);
    }

    @Override
    public V put(K key, V value, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.put(key, value, metadata);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        this.delegate.putAll(m, metadata);
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        this.delegate.putAll(m);
    }

    @Override
    public V replace(K key, V value, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.replace(key, value, metadata);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.replace(key, oldValue, newValue, metadata);
    }

    @Override
    public void clear() {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.BULK_WRITE);
        this.delegate.clear();
    }

    @Override
    public V putIfAbsent(K key, V value, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.putIfAbsent(key, value, metadata);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, Metadata metadata) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.WRITE);
        return this.delegate.putAsync(key, value, metadata);
    }

    @Override
    public CacheEntry getCacheEntry(Object key) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.READ);
        return this.delegate.getCacheEntry(key);
    }

    @Override
    public Map<K, CacheEntry<K, V>> getAllCacheEntries(Set<?> keys) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.BULK_READ);
        return this.delegate.getAllCacheEntries(keys);
    }

    @Override
    public Map<K, V> getGroup(String groupName) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.BULK_READ);
        return this.delegate.getGroup(groupName);
    }

    @Override
    public void removeGroup(String groupName) {
        this.authzManager.checkPermission(this.subject, AuthorizationPermission.BULK_WRITE);
        this.delegate.removeGroup(groupName);
    }

    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return String.format("SecureCache '%s'", this.delegate.getName());
    }
}

