/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.policy.model;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.Policy;
import org.apache.wss4j.policy.SPConstants;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.model.Attachments;
import org.apache.wss4j.policy.model.Header;
import org.apache.wss4j.policy.model.RequiredParts;

public class SignedParts
extends RequiredParts {
    private boolean body;
    private Attachments attachments;
    private boolean signAllHeaders;

    public SignedParts(SPConstants.SPVersion version, boolean body, Attachments attachments, List<Header> headers, boolean signAllHeaders) {
        super(version, headers);
        this.body = body;
        this.attachments = attachments;
        this.signAllHeaders = signAllHeaders;
    }

    @Override
    public QName getName() {
        return this.getVersion().getSPConstants().getSignedParts();
    }

    @Override
    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(this.getName().getPrefix(), this.getName().getLocalPart(), this.getName().getNamespaceURI());
        writer.writeNamespace(this.getName().getPrefix(), this.getName().getNamespaceURI());
        if (!this.isNormalized() && this.isOptional()) {
            writer.writeAttribute("wsp", writer.getNamespaceContext().getNamespaceURI("wsp"), "Optional", "true");
        }
        if (this.isIgnorable()) {
            writer.writeAttribute("wsp", writer.getNamespaceContext().getNamespaceURI("wsp"), "Ignorable", "true");
        }
        if (this.isBody()) {
            QName body = this.getVersion().getSPConstants().getBody();
            writer.writeEmptyElement(body.getPrefix(), body.getLocalPart(), body.getNamespaceURI());
        }
        for (int i = 0; i < this.getHeaders().size(); ++i) {
            Header header = this.getHeaders().get(i);
            QName headerName = this.getVersion().getSPConstants().getHeader();
            writer.writeEmptyElement(headerName.getPrefix(), headerName.getLocalPart(), headerName.getNamespaceURI());
            if (header.getName() != null) {
                writer.writeAttribute("Name", header.getName());
            }
            writer.writeAttribute("Namespace", header.getNamespace());
        }
        if (this.getAttachments() != null) {
            this.getAttachments().serialize(writer);
        }
        writer.writeEndElement();
    }

    @Override
    protected AbstractSecurityAssertion cloneAssertion(Policy nestedPolicy) {
        return new SignedParts(this.getVersion(), this.isBody(), this.getAttachments() == null ? null : (Attachments)this.getAttachments().clone(nestedPolicy), this.getHeaders(), this.isSignAllHeaders());
    }

    public boolean isBody() {
        return this.body;
    }

    protected void setBody(boolean body) {
        this.body = body;
    }

    public Attachments getAttachments() {
        return this.attachments;
    }

    protected void setAttachments(Attachments attachments) {
        this.attachments = attachments;
    }

    public boolean isSignAllHeaders() {
        return this.signAllHeaders;
    }

    protected void setSignAllHeaders(boolean signAllHeaders) {
        this.signAllHeaders = signAllHeaders;
    }
}

