/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage;

import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageUri;
import com.microsoft.azure.storage.core.PathUtility;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;

public final class StorageCredentialsSharedAccessSignature
extends StorageCredentials {
    private final String token;

    public StorageCredentialsSharedAccessSignature(String token) {
        this.token = token;
        if (token == null) {
            this.setHttpsOnly(false);
        } else {
            try {
                HashMap<String, String[]> queryParams = PathUtility.parseQueryString(token);
                String[] protocols = (String[])queryParams.get("spr");
                this.setHttpsOnly(protocols != null && "https".equals(protocols[0]));
            }
            catch (StorageException e) {
                this.setHttpsOnly(false);
            }
        }
    }

    public String getToken() {
        return this.token;
    }

    @Override
    public String toString(boolean exportSecrets) {
        return String.format("%s=%s", "SharedAccessSignature", exportSecrets ? this.token : "[signature hidden]");
    }

    @Override
    public URI transformUri(URI resourceUri, OperationContext opContext) throws URISyntaxException, StorageException {
        if (resourceUri == null) {
            return null;
        }
        if (this.isHttpsOnly() && !resourceUri.getScheme().equals("https")) {
            throw new IllegalArgumentException("Cannot use HTTP with credentials that only support HTTPS.");
        }
        URI sasUri = PathUtility.addToQuery(resourceUri, this.token);
        String apiVersion = "api-version=2015-04-05";
        return PathUtility.addToQuery(sasUri, apiVersion);
    }

    @Override
    public StorageUri transformUri(StorageUri resourceUri, OperationContext opContext) throws URISyntaxException, StorageException {
        return new StorageUri(this.transformUri(resourceUri.getPrimaryUri(), opContext), this.transformUri(resourceUri.getSecondaryUri(), opContext));
    }
}

