/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.processor.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchClient;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.gson.impl.GsonProvider;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.processor.impl.ElasticsearchWorkProcessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.builder.RefreshWorkBuilder;
import org.hibernate.search.elasticsearch.work.impl.factory.ElasticsearchWorkFactory;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class SequentialWorkExecutionContext
implements ElasticsearchWorkExecutionContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class);
    private final ElasticsearchClient client;
    private final GsonProvider gsonProvider;
    private final ElasticsearchWorkFactory workFactory;
    private final ElasticsearchWorkProcessor workProcessor;
    private final ErrorHandler errorHandler;
    private final Map<IndexingMonitor, BufferedIndexingMonitor> bufferedIndexMonitors = new HashMap<IndexingMonitor, BufferedIndexingMonitor>();
    private final Set<URLEncodedString> dirtyIndexes = new HashSet<URLEncodedString>();

    public SequentialWorkExecutionContext(ElasticsearchClient client, GsonProvider gsonProvider, ElasticsearchWorkFactory workFactory, ElasticsearchWorkProcessor workProcessor, ErrorHandler errorHandler) {
        this.client = client;
        this.gsonProvider = gsonProvider;
        this.workFactory = workFactory;
        this.workProcessor = workProcessor;
        this.errorHandler = errorHandler;
    }

    @Override
    public ElasticsearchClient getClient() {
        return this.client;
    }

    @Override
    public GsonProvider getGsonProvider() {
        return this.gsonProvider;
    }

    @Override
    public void setIndexDirty(URLEncodedString indexName) {
        this.dirtyIndexes.add(indexName);
    }

    @Override
    public IndexingMonitor getBufferedIndexingMonitor(IndexingMonitor originalMonitor) {
        return this.bufferedIndexMonitors.computeIfAbsent(originalMonitor, BufferedIndexingMonitor::new);
    }

    public void flush() {
        if (!this.dirtyIndexes.isEmpty()) {
            this.refreshDirtyIndexes();
            this.dirtyIndexes.clear();
        }
        for (BufferedIndexingMonitor buffer : this.bufferedIndexMonitors.values()) {
            try {
                buffer.flush();
            }
            catch (RuntimeException e) {
                this.errorHandler.handleException("Flushing an indexing monitor failed", (Throwable)e);
            }
        }
        this.bufferedIndexMonitors.clear();
    }

    private void refreshDirtyIndexes() {
        if (log.isTraceEnabled()) {
            log.tracef("Refreshing index(es) %s", this.dirtyIndexes);
        }
        RefreshWorkBuilder builder = this.workFactory.refresh();
        for (URLEncodedString index : this.dirtyIndexes) {
            builder.index(index);
        }
        Object work = builder.build();
        try {
            this.workProcessor.executeSyncUnsafe(work);
        }
        catch (RuntimeException e) {
            this.errorHandler.handleException("Refresh failed", (Throwable)e);
        }
    }

    private static final class BufferedIndexingMonitor
    implements IndexingMonitor {
        private final IndexingMonitor delegate;
        private long documentsAdded = 0L;

        public BufferedIndexingMonitor(IndexingMonitor delegate) {
            this.delegate = delegate;
        }

        public void documentsAdded(long increment) {
            this.documentsAdded += increment;
        }

        private void flush() {
            this.delegate.documentsAdded(this.documentsAdded);
            this.documentsAdded = 0L;
        }
    }
}

