/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.table.management;

import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.logging.Log;
import org.infinispan.persistence.jdbc.table.management.AbstractTableManager;
import org.infinispan.persistence.jdbc.table.management.DbMetaData;
import org.infinispan.persistence.jdbc.table.management.MySQLTableManager;
import org.infinispan.util.logging.LogFactory;

class SQLServerTableManager
extends AbstractTableManager {
    private static final Log LOG = (Log)LogFactory.getLog(MySQLTableManager.class, Log.class);

    SQLServerTableManager(ConnectionFactory connectionFactory, TableManipulationConfiguration config, DbMetaData metaData) {
        super(connectionFactory, config, metaData, LOG);
    }

    @Override
    public String getUpsertRowSql() {
        if (this.upsertRowSql == null) {
            this.upsertRowSql = String.format("MERGE %1$s WITH (TABLOCK) USING (VALUES (?, ?, ?)) AS tmp (%2$s, %3$s, %4$s) ON (%1$s.%2$s = tmp.%2$s) WHEN MATCHED THEN UPDATE SET %3$s = tmp.%3$s, %4$s = tmp.%4$s WHEN NOT MATCHED THEN INSERT (%2$s, %3$s, %4$s) VALUES (tmp.%2$s, tmp.%3$s, tmp.%4$s);", this.getTableName(), this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName());
        }
        return this.upsertRowSql;
    }

    @Override
    public boolean isStringEncodingRequired() {
        return this.metaData.getMajorVersion() < 13;
    }

    @Override
    public String encodeString(String string) {
        char[] srcChars = string.toCharArray();
        if (srcChars.length > 0 && srcChars[0] == '\ufeff') {
            char[] chars = new char[srcChars.length - 1];
            string.getChars(1, string.toCharArray().length, chars, 0);
            return new String(chars);
        }
        return string;
    }
}

