/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.cs.deployment;

import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.persistence.spi.CacheWriter;
import org.infinispan.persistence.spi.ExternalStore;
import org.infinispan.tasks.ServerTask;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.ServicesAttachment;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

public class ServerExtensionDependenciesProcessor
implements DeploymentUnitProcessor {
    private static final ModuleIdentifier API = ModuleIdentifier.create((String)"org.infinispan");
    private static final ModuleIdentifier TASKS_API = ModuleIdentifier.create((String)"org.infinispan.tasks.api");

    public void deploy(DeploymentPhaseContext ctx) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = ctx.getDeploymentUnit();
        if (this.hasServerTaskExtensions(deploymentUnit)) {
            this.addDependencies(deploymentUnit, API, TASKS_API);
        } else if (this.hasInfinispanExtensions(deploymentUnit)) {
            this.addDependencies(deploymentUnit, API);
        }
    }

    private void addDependencies(DeploymentUnit deploymentUnit, ModuleIdentifier ... identifiers) {
        ModuleSpecification moduleSpec = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        for (ModuleIdentifier identifier : identifiers) {
            moduleSpec.addSystemDependency(new ModuleDependency(moduleLoader, identifier, false, false, false, false));
        }
    }

    private boolean hasInfinispanExtensions(DeploymentUnit deploymentUnit) {
        ServicesAttachment sa = (ServicesAttachment)deploymentUnit.getAttachment(Attachments.SERVICES);
        return sa != null && this.hasDeployableCache(sa);
    }

    private boolean hasServerTaskExtensions(DeploymentUnit deploymentUnit) {
        ServicesAttachment sa = (ServicesAttachment)deploymentUnit.getAttachment(Attachments.SERVICES);
        return sa != null && this.hasServerTasks(sa);
    }

    public void undeploy(DeploymentUnit context) {
    }

    private boolean hasDeployableCache(ServicesAttachment sa) {
        return this.hasAdvancedCacheLoaders(sa) || this.hasAdvancedCacheWriters(sa) || this.hasAdvancedLoadWriteStores(sa) || this.hasCacheLoader(sa) || this.hasCacheWriter(sa) || this.hasExternalStores(sa);
    }

    private boolean hasServerTasks(ServicesAttachment servicesAttachment) {
        return this.hasExtension(servicesAttachment, ServerTask.class);
    }

    private boolean hasAdvancedCacheLoaders(ServicesAttachment servicesAttachment) {
        return this.hasExtension(servicesAttachment, AdvancedCacheLoader.class);
    }

    private boolean hasAdvancedCacheWriters(ServicesAttachment servicesAttachment) {
        return this.hasExtension(servicesAttachment, AdvancedCacheWriter.class);
    }

    private boolean hasAdvancedLoadWriteStores(ServicesAttachment servicesAttachment) {
        return this.hasExtension(servicesAttachment, AdvancedLoadWriteStore.class);
    }

    private boolean hasCacheLoader(ServicesAttachment servicesAttachment) {
        return this.hasExtension(servicesAttachment, CacheLoader.class);
    }

    private boolean hasCacheWriter(ServicesAttachment servicesAttachment) {
        return this.hasExtension(servicesAttachment, CacheWriter.class);
    }

    private boolean hasExternalStores(ServicesAttachment servicesAttachment) {
        return this.hasExtension(servicesAttachment, ExternalStore.class);
    }

    private boolean hasExtension(ServicesAttachment servicesAttachment, Class<?> extensionClass) {
        return !servicesAttachment.getServiceImplementations(extensionClass.getName()).isEmpty();
    }
}

