/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.externalizers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.BytesRef;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.query.impl.externalizers.ExternalizerIds;

public class LuceneTermExternalizer
extends AbstractExternalizer<Term> {
    public Set<Class<? extends Term>> getTypeClasses() {
        return Collections.singleton(Term.class);
    }

    public Term readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        String fieldName = input.readUTF();
        int payloadSize = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        byte[] readBuffer = new byte[payloadSize];
        input.readFully(readBuffer);
        return new Term(fieldName, new BytesRef(readBuffer));
    }

    public void writeObject(ObjectOutput output, Term term) throws IOException {
        output.writeUTF(term.field());
        BytesRef payload = term.bytes();
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)payload.length);
        output.write(payload.bytes, payload.offset, payload.length);
    }

    public Integer getId() {
        return ExternalizerIds.LUCENE_TERM;
    }
}

