/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.util.Collection;
import java.util.Iterator;
import org.jboss.marshalling.ObjectResolver;

public class ChainingObjectResolver
implements ObjectResolver {
    private final ObjectResolver[] resolvers;

    public ChainingObjectResolver(ObjectResolver[] resolvers) {
        if (resolvers == null) {
            throw new NullPointerException("resolvers is null");
        }
        this.resolvers = (ObjectResolver[])resolvers.clone();
    }

    public ChainingObjectResolver(Iterator<ObjectResolver> resolvers) {
        if (resolvers == null) {
            throw new NullPointerException("resolvers is null");
        }
        this.resolvers = ChainingObjectResolver.unroll(resolvers, 0);
    }

    public ChainingObjectResolver(Iterable<ObjectResolver> resolvers) {
        this(resolvers.iterator());
    }

    public ChainingObjectResolver(Collection<ObjectResolver> resolvers) {
        if (resolvers == null) {
            throw new NullPointerException("resolvers is null");
        }
        this.resolvers = resolvers.toArray(new ObjectResolver[resolvers.size()]);
    }

    private static ObjectResolver[] unroll(Iterator<ObjectResolver> iterator, int i) {
        if (iterator.hasNext()) {
            ObjectResolver factory = iterator.next();
            ObjectResolver[] array = ChainingObjectResolver.unroll(iterator, i + 1);
            array[i] = factory;
            return array;
        }
        return new ObjectResolver[i];
    }

    @Override
    public Object readResolve(Object replacement) {
        Object o = replacement;
        for (int i = this.resolvers.length - 1; i >= 0; --i) {
            ObjectResolver resolver = this.resolvers[i];
            o = resolver.readResolve(o);
        }
        return o;
    }

    @Override
    public Object writeReplace(Object original) {
        Object o = original;
        for (ObjectResolver resolver : this.resolvers) {
            o = resolver.writeReplace(o);
        }
        return o;
    }
}

