/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.value;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.jboss.msc.value.ThreadLocalValue;
import org.jboss.msc.value.Value;
import org.jboss.msc.value.Values;

public final class MethodValue<T>
implements Value<T> {
    private final Value<Method> methodValue;
    private final Value<?> targetValue;
    private final List<? extends Value<?>> parameters;

    public MethodValue(Value<Method> methodValue, Value<?> targetValue, List<? extends Value<?>> parameters) {
        this.methodValue = methodValue;
        this.targetValue = targetValue;
        this.parameters = parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T getValue() throws IllegalStateException {
        ThreadLocalValue<Object> thisValue = Values.thisValue();
        Value<?> targetValue = this.targetValue;
        try {
            Value<Object> old = thisValue.getAndSetValue(targetValue);
            try {
                Object object = this.methodValue.getValue().invoke(targetValue.getValue(), Values.getValues(this.parameters));
                return (T)object;
            }
            finally {
                thisValue.setValue(old);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Method is not accessible", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Failed to invoke method", e);
        }
    }
}

