/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.net.URISupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataQueryProtocolRequestURLBuilder
implements Function<String, String> {
    private final Logger log = LoggerFactory.getLogger(MetadataQueryProtocolRequestURLBuilder.class);
    private String base;
    private Function<String, String> transformer;

    public MetadataQueryProtocolRequestURLBuilder(@Nonnull @NotEmpty String baseURL) {
        this(baseURL, null);
    }

    public MetadataQueryProtocolRequestURLBuilder(@Nonnull @NotEmpty String baseURL, @Nullable Function<String, String> transform) {
        this.base = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)baseURL), (String)"Base URL was null or empty");
        if (!this.base.endsWith("/")) {
            this.log.debug("Base URL did not end in a trailing '/', one will be added");
            this.base = this.base + "/";
        }
        this.log.debug("Effective base URL value was: {}", (Object)this.base);
        this.transformer = transform;
    }

    @Nullable
    public String apply(@Nonnull String input) {
        String entityID = (String)Constraint.isNotNull((Object)input, (String)"Entity ID was null");
        if (this.transformer != null) {
            entityID = (String)this.transformer.apply((Object)entityID);
            this.log.debug("Transformed entityID is '{}'", (Object)entityID);
            if (entityID == null) {
                this.log.debug("Transformed entityID was null");
                return null;
            }
        }
        try {
            String result = this.base + "entities/" + URISupport.doURLEncode((String)entityID);
            this.log.debug("From entityID '{}' and base URL '{}', built request URL: {}", new Object[]{entityID, this.base, result});
            return result;
        }
        catch (Throwable t) {
            this.log.error("Encountered fatal error attempting to build request URL", t);
            return null;
        }
    }
}

