/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.util.impl;

import java.util.ArrayList;
import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.BridgeException;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.StringBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.hibernate.search.util.StringHelper;

public final class ContextualExceptionBridgeHelper
implements ConversionContext {
    private static final String IDENTIFIER = "identifier";
    private IndexedTypeIdentifier type;
    private StringBridge stringBridge;
    private FieldBridge oneWayBridge;
    private TwoWayFieldBridge twoWayBridge;
    private final ArrayList<String> propertyPath = new ArrayList(5);
    private final OneWayConversionContextImpl oneWayAdapter = new OneWayConversionContextImpl();
    private final TwoWayConversionContextImpl twoWayAdapter = new TwoWayConversionContextImpl();
    private final StringConversionContextImpl stringAdapter = new StringConversionContextImpl();

    @Override
    @Deprecated
    public ConversionContext setClass(Class<?> clazz) {
        return this.setConvertedTypeId(new PojoIndexedTypeIdentifier(clazz));
    }

    @Override
    public ConversionContext setConvertedTypeId(IndexedTypeIdentifier type) {
        this.type = type;
        return this;
    }

    @Override
    public ConversionContext pushProperty(String propertyName) {
        this.propertyPath.add(propertyName);
        return this;
    }

    @Override
    public ConversionContext popProperty() {
        if (this.propertyPath.size() == 0) {
            throw new IllegalStateException("Trying to pop a property from an empty conversion context");
        }
        this.propertyPath.remove(this.propertyPath.size() - 1);
        return this;
    }

    @Override
    public ConversionContext pushIdentifierProperty() {
        this.pushProperty(IDENTIFIER);
        return this;
    }

    protected BridgeException buildBridgeException(Exception e, String method, String fieldName, Object bridge) {
        StringBuilder errorMessage = new StringBuilder("Exception while calling bridge#").append(method);
        if (this.type != null) {
            errorMessage.append("\n\tentity class: ").append(this.type.getName());
        }
        if (this.propertyPath.size() > 0) {
            errorMessage.append("\n\tentity property path: ");
            for (String pathNode : this.propertyPath) {
                errorMessage.append(pathNode).append(".");
            }
            errorMessage.deleteCharAt(errorMessage.length() - 1);
        }
        if (StringHelper.isNotEmpty(fieldName)) {
            errorMessage.append("\n\tdocument field name: ").append(fieldName);
        }
        Exception exceptionWhenBuildingBridgeString = null;
        if (bridge != null) {
            String bridgeAsString = null;
            try {
                bridgeAsString = bridge.toString();
            }
            catch (Exception e2) {
                exceptionWhenBuildingBridgeString = e;
                bridgeAsString = "<toString() on the fieldbridge thrown " + e.getClass() + ">";
            }
            errorMessage.append("\n\tfield bridge: ").append(bridgeAsString);
        }
        BridgeException exception = new BridgeException(errorMessage.toString(), e);
        if (exceptionWhenBuildingBridgeString != null) {
            exception.addSuppressed(exceptionWhenBuildingBridgeString);
        }
        throw exception;
    }

    @Override
    public FieldBridge oneWayConversionContext(FieldBridge delegate) {
        this.oneWayBridge = delegate;
        return this.oneWayAdapter;
    }

    @Override
    public TwoWayFieldBridge twoWayConversionContext(TwoWayFieldBridge delegate) {
        this.twoWayBridge = delegate;
        return this.twoWayAdapter;
    }

    @Override
    public StringBridge stringConversionContext(StringBridge delegate) {
        this.stringBridge = delegate;
        return this.stringAdapter;
    }

    private final class StringConversionContextImpl
    implements StringBridge {
        private StringConversionContextImpl() {
        }

        @Override
        public String objectToString(Object object) {
            try {
                return ContextualExceptionBridgeHelper.this.stringBridge.objectToString(object);
            }
            catch (RuntimeException e) {
                throw ContextualExceptionBridgeHelper.this.buildBridgeException(e, "objectToString", null, ContextualExceptionBridgeHelper.this.stringBridge);
            }
        }
    }

    private final class TwoWayConversionContextImpl
    implements TwoWayFieldBridge {
        private TwoWayConversionContextImpl() {
        }

        @Override
        public Object get(String name, Document document) {
            try {
                return ContextualExceptionBridgeHelper.this.twoWayBridge.get(name, document);
            }
            catch (RuntimeException e) {
                throw ContextualExceptionBridgeHelper.this.buildBridgeException(e, "get", name, ContextualExceptionBridgeHelper.this.twoWayBridge);
            }
        }

        @Override
        public String objectToString(Object object) {
            try {
                return ContextualExceptionBridgeHelper.this.twoWayBridge.objectToString(object);
            }
            catch (RuntimeException e) {
                throw ContextualExceptionBridgeHelper.this.buildBridgeException(e, "objectToString", null, ContextualExceptionBridgeHelper.this.twoWayBridge);
            }
        }

        @Override
        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            try {
                ContextualExceptionBridgeHelper.this.twoWayBridge.set(name, value, document, luceneOptions);
            }
            catch (RuntimeException e) {
                throw ContextualExceptionBridgeHelper.this.buildBridgeException(e, "set", name, ContextualExceptionBridgeHelper.this.twoWayBridge);
            }
        }
    }

    private final class OneWayConversionContextImpl
    implements FieldBridge {
        private OneWayConversionContextImpl() {
        }

        @Override
        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            try {
                ContextualExceptionBridgeHelper.this.oneWayBridge.set(name, value, document, luceneOptions);
            }
            catch (RuntimeException e) {
                throw ContextualExceptionBridgeHelper.this.buildBridgeException(e, "set", name, ContextualExceptionBridgeHelper.this.oneWayBridge);
            }
        }
    }
}

