/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.channel.Channel;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.factories.threads.DefaultThreadFactory;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.filter.AbstractCacheEventFilterConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterFactory;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.server.hotrod.ClientEventType;
import org.infinispan.server.hotrod.Events;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.KeyValueVersionConverterFactory;
import org.infinispan.server.hotrod.Response;
import org.infinispan.server.hotrod.VersionedDecoder;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.util.KeyValuePair;

class ClientListenerRegistry {
    private final HotRodServerConfiguration configuration;
    private static final Log log = (Log)LogFactory.getLog(ClientListenerRegistry.class, Log.class);
    private static final boolean isTrace = log.isTraceEnabled();
    private final AtomicLong messageId = new AtomicLong();
    private final ConcurrentMap<WrappedByteArray, Object> eventSenders = new ConcurrentHashMap<WrappedByteArray, Object>();
    private volatile Optional<Marshaller> marshaller = Optional.empty();
    private final ConcurrentMap<String, CacheEventFilterFactory> cacheEventFilterFactories = CollectionFactory.makeConcurrentMap((int)4, (float)0.9f, (int)16);
    private final ConcurrentMap<String, CacheEventConverterFactory> cacheEventConverterFactories = CollectionFactory.makeConcurrentMap((int)4, (float)0.9f, (int)16);
    private final ConcurrentMap<String, CacheEventFilterConverterFactory> cacheEventFilterConverterFactories = CollectionFactory.makeConcurrentMap((int)4, (float)0.9f, (int)16);
    private final ExecutorService addListenerExecutor = new ThreadPoolExecutor(0, 10, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new DefaultThreadFactory(null, 1, "add-listener-thread-%t", null, null));

    ClientListenerRegistry(HotRodServerConfiguration configuration) {
        this.configuration = configuration;
    }

    void setEventMarshaller(Optional<Marshaller> eventMarshaller) {
        this.marshaller = eventMarshaller;
    }

    void addCacheEventFilterFactory(String name, CacheEventFilterFactory factory) {
        if (factory instanceof CacheEventConverterFactory) {
            throw log.illegalFilterConverterEventFactory(name);
        }
        this.cacheEventFilterFactories.put(name, factory);
    }

    void removeCacheEventFilterFactory(String name) {
        this.cacheEventFilterFactories.remove(name);
    }

    void addCacheEventConverterFactory(String name, CacheEventConverterFactory factory) {
        if (factory instanceof CacheEventFilterFactory) {
            throw log.illegalFilterConverterEventFactory(name);
        }
        this.cacheEventConverterFactories.put(name, factory);
    }

    void removeCacheEventConverterFactory(String name) {
        this.cacheEventConverterFactories.remove(name);
    }

    void addCacheEventFilterConverterFactory(String name, CacheEventFilterConverterFactory factory) {
        this.cacheEventFilterConverterFactories.put(name, factory);
    }

    void removeCacheEventFilterConverterFactory(String name) {
        this.cacheEventFilterConverterFactories.remove(name);
    }

    void addClientListener(VersionedDecoder decoder, Channel ch, HotRodHeader h, byte[] listenerId, AdvancedCache<byte[], byte[]> cache, boolean includeState, KeyValuePair<Optional<KeyValuePair<String, List<byte[]>>>, Optional<KeyValuePair<String, List<byte[]>>>> namedFactories, boolean useRawData, int listenerInterests) {
        KeyValuePair kvp;
        ClientEventType eventType = ClientEventType.createType(((Optional)namedFactories.getValue()).isPresent(), useRawData, h.version);
        Object clientEventSender = this.getClientEventSender(includeState, ch, h.version, (Cache)cache, listenerId, eventType);
        List<byte[]> binaryFilterParams = ((Optional)namedFactories.getKey()).map(KeyValuePair::getValue).orElse(Collections.emptyList());
        List<byte[]> binaryConverterParams = ((Optional)namedFactories.getValue()).map(KeyValuePair::getValue).orElse(Collections.emptyList());
        boolean compatEnabled = cache.getCacheConfiguration().compatibility().enabled();
        if (((Optional)namedFactories.getKey()).isPresent()) {
            KeyValuePair filterFactory = (KeyValuePair)((Optional)namedFactories.getKey()).get();
            if (((Optional)namedFactories.getValue()).isPresent()) {
                KeyValuePair converterFactory = (KeyValuePair)((Optional)namedFactories.getValue()).get();
                if (((String)filterFactory.getKey()).equals(converterFactory.getKey())) {
                    List<byte[]> binaryParams = binaryFilterParams.isEmpty() ? binaryConverterParams : binaryFilterParams;
                    CacheEventFilterConverter<byte[], byte[], byte[]> filterConverter = this.getFilterConverter((String)filterFactory.getKey(), compatEnabled, useRawData, binaryParams);
                    kvp = new KeyValuePair(filterConverter, filterConverter);
                } else {
                    kvp = new KeyValuePair(this.getFilter((String)filterFactory.getKey(), compatEnabled, useRawData, binaryFilterParams), this.getConverter((String)converterFactory.getKey(), compatEnabled, useRawData, binaryConverterParams));
                }
            } else {
                kvp = new KeyValuePair(this.getFilter((String)((KeyValuePair)((Optional)namedFactories.getKey()).get()).getKey(), compatEnabled, useRawData, binaryFilterParams), null);
            }
        } else {
            kvp = ((Optional)namedFactories.getValue()).isPresent() ? new KeyValuePair(null, this.getConverter((String)((KeyValuePair)((Optional)namedFactories.getValue()).get()).getKey(), compatEnabled, useRawData, binaryConverterParams)) : new KeyValuePair(null, null);
        }
        this.eventSenders.put(new WrappedByteArray(listenerId), clientEventSender);
        if (includeState) {
            CompletableFuture<Void> cf = CompletableFuture.runAsync(() -> this.addCacheListener(cache, clientEventSender, (KeyValuePair<CacheEventFilter<byte[], byte[]>, CacheEventConverter<byte[], byte[], byte[]>>)kvp, listenerInterests), this.addListenerExecutor);
            cf.whenComplete((t, cause) -> {
                Response resp = cause != null ? (cause instanceof CompletionException ? decoder.createErrorResponse(h, cause.getCause()) : decoder.createErrorResponse(h, (Throwable)cause)) : decoder.createSuccessResponse(h, null);
                ch.writeAndFlush((Object)resp);
            });
        } else {
            this.addCacheListener(cache, clientEventSender, (KeyValuePair<CacheEventFilter<byte[], byte[]>, CacheEventConverter<byte[], byte[], byte[]>>)kvp, listenerInterests);
            ch.writeAndFlush((Object)decoder.createSuccessResponse(h, null));
        }
    }

    private void addCacheListener(AdvancedCache<byte[], byte[]> cache, Object clientEventSender, KeyValuePair<CacheEventFilter<byte[], byte[]>, CacheEventConverter<byte[], byte[], byte[]>> kvp, int listenerInterests) {
        HashSet<Object> filterAnnotations;
        if (listenerInterests == 0) {
            filterAnnotations = new HashSet<Class>(Arrays.asList(CacheEntryCreated.class, CacheEntryModified.class, CacheEntryRemoved.class, CacheEntryExpired.class));
        } else {
            filterAnnotations = new HashSet<Class<CacheEntryRemoved>>();
            if ((listenerInterests & 1) == 1) {
                filterAnnotations.add(CacheEntryCreated.class);
            }
            if ((listenerInterests & 2) == 2) {
                filterAnnotations.add(CacheEntryModified.class);
            }
            if ((listenerInterests & 4) == 4) {
                filterAnnotations.add(CacheEntryRemoved.class);
            }
            if ((listenerInterests & 8) == 8) {
                filterAnnotations.add(CacheEntryExpired.class);
            }
        }
        cache.addFilteredListener(clientEventSender, (CacheEventFilter)kvp.getKey(), (CacheEventConverter)kvp.getValue(), filterAnnotations);
    }

    CacheEventFilter<byte[], byte[]> getFilter(String name, Boolean compatEnabled, Boolean useRawData, List<byte[]> binaryParams) {
        KeyValuePair<CacheEventFilterFactory, Marshaller> factory = this.findFactory(name, compatEnabled, this.cacheEventFilterFactories, "key/value filter", useRawData);
        List<? extends Object> params = this.unmarshallParams(binaryParams, (Marshaller)factory.getValue(), useRawData);
        return ((CacheEventFilterFactory)factory.getKey()).getFilter(params.toArray());
    }

    CacheEventConverter<byte[], byte[], byte[]> getConverter(String name, boolean compatEnabled, Boolean useRawData, List<byte[]> binaryParams) {
        KeyValuePair<CacheEventConverterFactory, Marshaller> factory = this.findConverterFactory(name, compatEnabled, this.cacheEventConverterFactories, "converter", useRawData);
        List<? extends Object> params = this.unmarshallParams(binaryParams, (Marshaller)factory.getValue(), useRawData);
        return ((CacheEventConverterFactory)factory.getKey()).getConverter(params.toArray());
    }

    CacheEventFilterConverter<byte[], byte[], byte[]> getFilterConverter(String name, boolean compatEnabled, boolean useRawData, List<byte[]> binaryParams) {
        KeyValuePair<CacheEventFilterConverterFactory, Marshaller> factory = this.findFactory(name, compatEnabled, this.cacheEventFilterConverterFactories, "converter", useRawData);
        List<? extends Object> params = this.unmarshallParams(binaryParams, (Marshaller)factory.getValue(), useRawData);
        return ((CacheEventFilterConverterFactory)factory.getKey()).getFilterConverter(params.toArray());
    }

    KeyValuePair<CacheEventConverterFactory, Marshaller> findConverterFactory(String name, boolean compatEnabled, ConcurrentMap<String, CacheEventConverterFactory> factories, String factoryType, boolean useRawData) {
        if (name.equals("___eager-key-value-version-converter")) {
            return new KeyValuePair((Object)KeyValueVersionConverterFactory.SINGLETON, (Object)new GenericJBossMarshaller());
        }
        return this.findFactory(name, compatEnabled, factories, factoryType, useRawData);
    }

    <T> KeyValuePair<T, Marshaller> findFactory(String name, boolean compatEnabled, ConcurrentMap<String, T> factories, String factoryType, boolean useRawData) {
        Object factory = factories.get(name);
        if (factory == null) {
            throw log.missingCacheEventFactory(factoryType, name);
        }
        Marshaller m = this.marshaller.orElse((Marshaller)new GenericJBossMarshaller(factory.getClass().getClassLoader()));
        if (useRawData || compatEnabled) {
            return new KeyValuePair(factory, (Object)m);
        }
        return new KeyValuePair(this.createFactory(factory, m), (Object)m);
    }

    <T> T createFactory(T factory, Marshaller marshaller) {
        if (factory instanceof CacheEventConverterFactory) {
            return (T)new UnmarshallConverterFactory((CacheEventConverterFactory)factory, marshaller);
        }
        if (factory instanceof CacheEventFilterFactory) {
            return (T)new UnmarshallFilterFactory((CacheEventFilterFactory)factory, marshaller);
        }
        if (factory instanceof CacheEventFilterConverterFactory) {
            return (T)new UnmarshallFilterConverterFactory((CacheEventFilterConverterFactory)factory, marshaller);
        }
        throw new IllegalArgumentException("Unsupported factory: " + factory);
    }

    private List<? extends Object> unmarshallParams(List<byte[]> binaryParams, Marshaller marshaller, boolean useRawData) {
        if (!useRawData) {
            return binaryParams.stream().map(bp -> {
                try {
                    return marshaller.objectFromByteBuffer(bp);
                }
                catch (IOException | ClassNotFoundException e) {
                    throw new CacheException((Throwable)e);
                }
            }).collect(Collectors.toList());
        }
        return binaryParams;
    }

    boolean removeClientListener(byte[] listenerId, Cache cache) {
        Object sender = this.eventSenders.get(new WrappedByteArray(listenerId));
        if (sender != null) {
            cache.removeListener(sender);
            return true;
        }
        return false;
    }

    public void stop() {
        this.eventSenders.clear();
        this.cacheEventFilterFactories.clear();
        this.cacheEventConverterFactories.clear();
        this.addListenerExecutor.shutdown();
    }

    void findAndWriteEvents(Channel channel) {
        channel.eventLoop().execute(() -> this.eventSenders.values().forEach(s -> {
            BaseClientEventSender bces;
            if (s instanceof BaseClientEventSender && (bces = (BaseClientEventSender)s).hasChannel(channel)) {
                bces.writeEventsIfPossible();
            }
        }));
    }

    Object getClientEventSender(boolean includeState, Channel ch, byte version, Cache cache, byte[] listenerId, ClientEventType eventType) {
        Encoder keyEncoder = cache.getAdvancedCache().getKeyEncoder();
        Encoder valueEncoder = cache.getAdvancedCache().getValueEncoder();
        Wrapper keyWrapper = cache.getAdvancedCache().getKeyWrapper();
        Wrapper valueWrapper = cache.getAdvancedCache().getValueWrapper();
        if (includeState) {
            return new StatefulClientEventSender(cache, ch, listenerId, version, eventType, keyEncoder, valueEncoder, keyWrapper, valueWrapper);
        }
        return new StatelessClientEventSender(cache, ch, listenerId, version, eventType, keyEncoder, valueEncoder, keyWrapper, valueWrapper);
    }

    private static <T> Marshaller constructMarshaller(T t, Class<? extends Marshaller> marshallerClass) {
        Constructor<? extends Marshaller> constructor = ClientListenerRegistry.findClassloaderConstructor(marshallerClass);
        try {
            if (constructor != null) {
                return constructor.newInstance(t.getClass().getClassLoader());
            }
            return marshallerClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private static Constructor<? extends Marshaller> findClassloaderConstructor(Class<? extends Marshaller> clazz) {
        try {
            return clazz.getConstructor(ClassLoader.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    static class UnmarshallFilterConverterExternalizer
    extends AbstractExternalizer<UnmarshallFilterConverter> {
        UnmarshallFilterConverterExternalizer() {
        }

        public void writeObject(ObjectOutput output, UnmarshallFilterConverter obj) throws IOException {
            output.writeObject(obj.filterConverter);
            output.writeObject(obj.marshaller.getClass());
        }

        public UnmarshallFilterConverter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            CacheEventFilterConverter filterConverter = (CacheEventFilterConverter)input.readObject();
            Class marshallerClass = (Class)input.readObject();
            Marshaller marshaller = ClientListenerRegistry.constructMarshaller(filterConverter, marshallerClass);
            return new UnmarshallFilterConverter((CacheEventFilterConverter<Object, Object, Object>)filterConverter, marshaller);
        }

        public Set<Class<? extends UnmarshallFilterConverter>> getTypeClasses() {
            return Collections.singleton(UnmarshallFilterConverter.class);
        }
    }

    static class UnmarshallFilterConverter
    extends AbstractCacheEventFilterConverter<byte[], byte[], byte[]> {
        private final CacheEventFilterConverter<Object, Object, Object> filterConverter;
        private final Marshaller marshaller;

        UnmarshallFilterConverter(CacheEventFilterConverter<Object, Object, Object> filterConverter, Marshaller marshaller) {
            this.filterConverter = filterConverter;
            this.marshaller = marshaller;
        }

        public byte[] filterAndConvert(byte[] key, byte[] oldValue, Metadata oldMetadata, byte[] newValue, Metadata newMetadata, EventType eventType) {
            try {
                Object unmarshalledKey = this.marshaller.objectFromByteBuffer(key);
                Object unmarshalledPrevValue = oldValue != null ? this.marshaller.objectFromByteBuffer(oldValue) : null;
                Object unmarshalledValue = newValue != null ? this.marshaller.objectFromByteBuffer(newValue) : null;
                Object converted = this.filterConverter.filterAndConvert(unmarshalledKey, unmarshalledPrevValue, oldMetadata, unmarshalledValue, newMetadata, eventType);
                return this.marshaller.objectToByteBuffer(converted);
            }
            catch (IOException | ClassNotFoundException | InterruptedException e) {
                throw new CacheException((Throwable)e);
            }
        }
    }

    static class UnmarshallConverterExternalizer
    extends AbstractExternalizer<UnmarshallConverter> {
        UnmarshallConverterExternalizer() {
        }

        public void writeObject(ObjectOutput output, UnmarshallConverter obj) throws IOException {
            output.writeObject(obj.converter);
            output.writeObject(obj.marshaller.getClass());
        }

        public UnmarshallConverter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            CacheEventConverter converter = (CacheEventConverter)input.readObject();
            Class marshallerClass = (Class)input.readObject();
            Marshaller marshaller = ClientListenerRegistry.constructMarshaller(converter, marshallerClass);
            return new UnmarshallConverter((CacheEventConverter<Object, Object, Object>)converter, marshaller);
        }

        public Set<Class<? extends UnmarshallConverter>> getTypeClasses() {
            return Collections.singleton(UnmarshallConverter.class);
        }
    }

    static class UnmarshallConverter
    implements CacheEventConverter<byte[], byte[], byte[]> {
        private final CacheEventConverter<Object, Object, Object> converter;
        private final Marshaller marshaller;

        UnmarshallConverter(CacheEventConverter<Object, Object, Object> converter, Marshaller marshaller) {
            this.converter = converter;
            this.marshaller = marshaller;
        }

        public byte[] convert(byte[] key, byte[] oldValue, Metadata oldMetadata, byte[] newValue, Metadata newMetadata, EventType eventType) {
            try {
                Object unmarshalledKey = this.marshaller.objectFromByteBuffer(key);
                Object unmarshalledPrevValue = oldValue != null ? this.marshaller.objectFromByteBuffer(oldValue) : null;
                Object unmarshalledValue = newValue != null ? this.marshaller.objectFromByteBuffer(newValue) : null;
                Object converted = this.converter.convert(unmarshalledKey, unmarshalledPrevValue, oldMetadata, unmarshalledValue, newMetadata, eventType);
                return this.marshaller.objectToByteBuffer(converted);
            }
            catch (IOException | ClassNotFoundException | InterruptedException e) {
                throw new CacheException((Throwable)e);
            }
        }
    }

    static class UnmarshallFilterExternalizer
    extends AbstractExternalizer<UnmarshallFilter> {
        UnmarshallFilterExternalizer() {
        }

        public void writeObject(ObjectOutput output, UnmarshallFilter obj) throws IOException {
            output.writeObject(obj.filter);
            output.writeObject(obj.marshaller.getClass());
        }

        public UnmarshallFilter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            CacheEventFilter filter = (CacheEventFilter)input.readObject();
            Class marshallerClass = (Class)input.readObject();
            Marshaller marshaller = ClientListenerRegistry.constructMarshaller(filter, marshallerClass);
            return new UnmarshallFilter((CacheEventFilter<Object, Object>)filter, marshaller);
        }

        public Set<Class<? extends UnmarshallFilter>> getTypeClasses() {
            return Collections.singleton(UnmarshallFilter.class);
        }
    }

    static class UnmarshallFilter
    implements CacheEventFilter<byte[], byte[]> {
        private final CacheEventFilter<Object, Object> filter;
        private final Marshaller marshaller;

        UnmarshallFilter(CacheEventFilter<Object, Object> filter, Marshaller marshaller) {
            this.filter = filter;
            this.marshaller = marshaller;
        }

        public boolean accept(byte[] key, byte[] oldValue, Metadata oldMetadata, byte[] newValue, Metadata newMetadata, EventType eventType) {
            Object unmarshalledValue;
            Object unmarshalledPrevValue;
            Object unmarshalledKey;
            try {
                unmarshalledKey = this.marshaller.objectFromByteBuffer(key);
                unmarshalledPrevValue = oldValue != null ? this.marshaller.objectFromByteBuffer(oldValue) : null;
                unmarshalledValue = newValue != null ? this.marshaller.objectFromByteBuffer(newValue) : null;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new CacheException((Throwable)e);
            }
            return this.filter.accept(unmarshalledKey, unmarshalledPrevValue, oldMetadata, unmarshalledValue, newMetadata, eventType);
        }
    }

    class UnmarshallFilterConverterFactory
    implements CacheEventFilterConverterFactory {
        private final CacheEventFilterConverterFactory filterConverterFactory;
        private final Marshaller marshaller;

        UnmarshallFilterConverterFactory(CacheEventFilterConverterFactory filterConverterFactory, Marshaller marshaller) {
            this.filterConverterFactory = filterConverterFactory;
            this.marshaller = marshaller;
        }

        public <K, V, C> CacheEventFilterConverter<K, V, C> getFilterConverter(Object[] params) {
            return new UnmarshallFilterConverter((CacheEventFilterConverter<Object, Object, Object>)this.filterConverterFactory.getFilterConverter(params), this.marshaller);
        }
    }

    class UnmarshallConverterFactory
    implements CacheEventConverterFactory {
        private final CacheEventConverterFactory converterFactory;
        private final Marshaller marshaller;

        UnmarshallConverterFactory(CacheEventConverterFactory converterFactory, Marshaller marshaller) {
            this.converterFactory = converterFactory;
            this.marshaller = marshaller;
        }

        public <K, V, C> CacheEventConverter<K, V, C> getConverter(Object[] params) {
            return new UnmarshallConverter((CacheEventConverter<Object, Object, Object>)this.converterFactory.getConverter(params), this.marshaller);
        }
    }

    private class UnmarshallFilterFactory
    implements CacheEventFilterFactory {
        private final CacheEventFilterFactory filterFactory;
        private final Marshaller marshaller;

        private UnmarshallFilterFactory(CacheEventFilterFactory filterFactory, Marshaller marshaller) {
            this.filterFactory = filterFactory;
            this.marshaller = marshaller;
        }

        public <K, V> CacheEventFilter<K, V> getFilter(Object[] params) {
            return new UnmarshallFilter((CacheEventFilter<Object, Object>)this.filterFactory.getFilter(params), this.marshaller);
        }
    }

    private abstract class BaseClientEventSender {
        protected final Channel ch;
        protected final byte[] listenerId;
        protected final byte version;
        protected final ClientEventType targetEventType;
        private final Encoder keyEncoder;
        private final Encoder valueEncoder;
        private final Wrapper keyWrapper;
        private final Wrapper valueWrapper;
        protected final Cache cache;
        BlockingQueue<Object> eventQueue = new LinkedBlockingQueue<Object>(100);
        private final Runnable writeEventsIfPossible = this::writeEventsIfPossible;

        protected BaseClientEventSender(Cache cache, Channel ch, byte[] listenerId, byte version, ClientEventType targetEventType, Encoder keyEncoder, Encoder valueEncoder, Wrapper keyWrapper, Wrapper valueWrapper) {
            this.cache = cache;
            this.ch = ch;
            this.listenerId = listenerId;
            this.version = version;
            this.targetEventType = targetEventType;
            this.keyEncoder = keyEncoder;
            this.valueEncoder = valueEncoder;
            this.keyWrapper = keyWrapper;
            this.valueWrapper = valueWrapper;
        }

        boolean hasChannel(Channel channel) {
            return this.ch == channel;
        }

        void writeEventsIfPossible() {
            boolean written = false;
            while (!this.eventQueue.isEmpty() && this.ch.isWritable()) {
                Object event = this.eventQueue.poll();
                if (isTrace) {
                    log.tracef("Write event: %s to channel %s", event, this.ch);
                }
                this.ch.write(event);
                written = true;
            }
            if (written) {
                this.ch.flush();
            }
        }

        @CacheEntryCreated
        @CacheEntryModified
        @CacheEntryRemoved
        @CacheEntryExpired
        public void onCacheEvent(CacheEntryEvent<byte[], byte[]> event) {
            if (this.isSendEvent(event)) {
                Metadata metadata = event.getMetadata();
                long version = metadata != null && metadata.version() != null ? ((NumericVersion)metadata.version()).getVersion() : 0L;
                Object k = event.getKey();
                Object v = event.getValue();
                if (this.keyEncoder.isStorageFormatFilterable()) {
                    k = this.keyEncoder.fromStorage(this.keyWrapper.unwrap(k));
                }
                if (this.valueEncoder.isStorageFormatFilterable()) {
                    v = this.valueEncoder.fromStorage(this.keyWrapper.unwrap(v));
                }
                this.sendEvent((byte[])k, (byte[])v, version, event);
            }
        }

        boolean isSendEvent(CacheEntryEvent<?, ?> event) {
            if (this.isChannelDisconnected()) {
                log.debug("Channel disconnected, remove event sender listener");
                event.getCache().removeListener((Object)this);
                return false;
            }
            switch (event.getType()) {
                case CACHE_ENTRY_CREATED: 
                case CACHE_ENTRY_MODIFIED: {
                    return !event.isPre();
                }
                case CACHE_ENTRY_REMOVED: {
                    CacheEntryRemovedEvent removedEvent = (CacheEntryRemovedEvent)event;
                    return !event.isPre() && removedEvent.getOldValue() != null;
                }
                case CACHE_ENTRY_EXPIRED: {
                    return true;
                }
            }
            throw log.unexpectedEvent((Event)event);
        }

        boolean isChannelDisconnected() {
            return !this.ch.isOpen();
        }

        void sendEvent(byte[] key, byte[] value, long dataVersion, CacheEntryEvent event) {
            Object remoteEvent = this.createRemoteEvent(key, value, dataVersion, event);
            if (isTrace) {
                log.tracef("Queue event %s, before queuing event queue size is %d", remoteEvent, this.eventQueue.size());
            }
            boolean waitingForFlush = !this.ch.isWritable();
            try {
                this.eventQueue.put(remoteEvent);
            }
            catch (InterruptedException e) {
                throw new CacheException((Throwable)e);
            }
            if (!waitingForFlush) {
                this.ch.eventLoop().submit(this.writeEventsIfPossible);
            }
        }

        private Object createRemoteEvent(byte[] key, byte[] value, long dataVersion, CacheEntryEvent event) {
            long id = ClientListenerRegistry.this.messageId.incrementAndGet();
            switch (this.targetEventType) {
                case PLAIN: {
                    switch (event.getType()) {
                        case CACHE_ENTRY_CREATED: 
                        case CACHE_ENTRY_MODIFIED: {
                            KeyValuePair<HotRodOperation, Boolean> responseType = this.getEventResponseType(event);
                            return this.keyWithVersionEvent(key, dataVersion, (HotRodOperation)((Object)responseType.getKey()), (Boolean)responseType.getValue());
                        }
                        case CACHE_ENTRY_REMOVED: 
                        case CACHE_ENTRY_EXPIRED: {
                            KeyValuePair<HotRodOperation, Boolean> responseType = this.getEventResponseType(event);
                            return new Events.KeyEvent(this.version, id, (HotRodOperation)((Object)responseType.getKey()), this.listenerId, (boolean)((Boolean)responseType.getValue()), key);
                        }
                    }
                    throw log.unexpectedEvent((Event)event);
                }
                case CUSTOM_PLAIN: {
                    KeyValuePair<HotRodOperation, Boolean> responseType = this.getEventResponseType(event);
                    return new Events.CustomEvent(this.version, id, (HotRodOperation)((Object)responseType.getKey()), this.listenerId, (boolean)((Boolean)responseType.getValue()), value);
                }
                case CUSTOM_RAW: {
                    KeyValuePair<HotRodOperation, Boolean> responseType = this.getEventResponseType(event);
                    return new Events.CustomRawEvent(this.version, id, (HotRodOperation)((Object)responseType.getKey()), this.listenerId, (boolean)((Boolean)responseType.getValue()), value);
                }
            }
            throw new IllegalArgumentException("Event type not supported: " + (Object)((Object)this.targetEventType));
        }

        private KeyValuePair<HotRodOperation, Boolean> getEventResponseType(CacheEntryEvent event) {
            switch (event.getType()) {
                case CACHE_ENTRY_CREATED: {
                    return new KeyValuePair((Object)HotRodOperation.CACHE_ENTRY_CREATED_EVENT, (Object)((CacheEntryCreatedEvent)event).isCommandRetried());
                }
                case CACHE_ENTRY_MODIFIED: {
                    return new KeyValuePair((Object)HotRodOperation.CACHE_ENTRY_MODIFIED_EVENT, (Object)((CacheEntryModifiedEvent)event).isCommandRetried());
                }
                case CACHE_ENTRY_REMOVED: {
                    return new KeyValuePair((Object)HotRodOperation.CACHE_ENTRY_REMOVED_EVENT, (Object)((CacheEntryRemovedEvent)event).isCommandRetried());
                }
                case CACHE_ENTRY_EXPIRED: {
                    return new KeyValuePair((Object)HotRodOperation.CACHE_ENTRY_EXPIRED_EVENT, (Object)false);
                }
            }
            throw log.unexpectedEvent((Event)event);
        }

        private Events.KeyWithVersionEvent keyWithVersionEvent(byte[] key, long dataVersion, HotRodOperation op, boolean isRetried) {
            return new Events.KeyWithVersionEvent(this.version, ClientListenerRegistry.this.messageId.get(), op, this.listenerId, isRetried, key, dataVersion);
        }
    }

    @Listener(clustered=true, includeCurrentState=false)
    private class StatelessClientEventSender
    extends BaseClientEventSender {
        protected StatelessClientEventSender(Cache cache, Channel ch, byte[] listenerId, byte version, ClientEventType targetEventType, Encoder keyEncoder, Encoder valueEncoder, Wrapper keyWrapper, Wrapper valueWrapper) {
            super(cache, ch, listenerId, version, targetEventType, keyEncoder, valueEncoder, keyWrapper, valueWrapper);
        }
    }

    @Listener(clustered=true, includeCurrentState=true)
    private class StatefulClientEventSender
    extends BaseClientEventSender {
        protected StatefulClientEventSender(Cache cache, Channel ch, byte[] listenerId, byte version, ClientEventType targetEventType, Encoder keyEncoder, Encoder valueEncoder, Wrapper keyWrapper, Wrapper valueWrapper) {
            super(cache, ch, listenerId, version, targetEventType, keyEncoder, valueEncoder, keyWrapper, valueWrapper);
        }
    }
}

