/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.registry;

import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.clustering.naming.BinderServiceBuilder;
import org.jboss.as.clustering.naming.JndiNameFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.registry.RegistryEntryProvider;
import org.wildfly.clustering.registry.RegistryFactory;
import org.wildfly.clustering.service.AliasServiceBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.spi.CacheGroupAliasBuilderProvider;
import org.wildfly.clustering.spi.CacheGroupServiceName;

public class RegistryFactoryAliasBuilderProvider
implements CacheGroupAliasBuilderProvider {
    public Collection<Builder<?>> getBuilders(String containerName, String aliasCacheName, String targetCacheName) {
        AliasServiceBuilder factoryBuilder = new AliasServiceBuilder(CacheGroupServiceName.REGISTRY_FACTORY.getServiceName(containerName, aliasCacheName), CacheGroupServiceName.REGISTRY_FACTORY.getServiceName(containerName, targetCacheName), RegistryFactory.class);
        AliasServiceBuilder registryBuilder = new AliasServiceBuilder(CacheGroupServiceName.REGISTRY.getServiceName(containerName, aliasCacheName), CacheGroupServiceName.REGISTRY.getServiceName(containerName, targetCacheName), Registry.class);
        AliasServiceBuilder entryBuilder = new AliasServiceBuilder(CacheGroupServiceName.REGISTRY_ENTRY.getServiceName(containerName, targetCacheName), CacheGroupServiceName.REGISTRY_ENTRY.getServiceName(containerName, aliasCacheName), RegistryEntryProvider.class);
        ContextNames.BindInfo binding = ContextNames.bindInfoFor((String)JndiNameFactory.createJndiName((String)"java:jboss", (String[])new String[]{"clustering", CacheGroupServiceName.REGISTRY.toString(), containerName, aliasCacheName}).getAbsoluteName());
        BinderServiceBuilder bindingBuilder = new BinderServiceBuilder(binding, factoryBuilder.getServiceName(), RegistryFactory.class);
        return Arrays.asList(factoryBuilder, registryBuilder, entryBuilder, bindingBuilder);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

