/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.spec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.CopyUtil;
import org.jboss.jca.common.api.metadata.CopyableMetaData;
import org.jboss.jca.common.api.metadata.MergeUtil;
import org.jboss.jca.common.api.metadata.spec.AdminObject;
import org.jboss.jca.common.api.metadata.spec.ConfigProperty;
import org.jboss.jca.common.api.metadata.spec.InboundResourceAdapter;
import org.jboss.jca.common.api.metadata.spec.MergeableMetadata;
import org.jboss.jca.common.api.metadata.spec.OutboundResourceAdapter;
import org.jboss.jca.common.api.metadata.spec.ResourceAdapter;
import org.jboss.jca.common.api.metadata.spec.SecurityPermission;
import org.jboss.jca.common.api.metadata.spec.XsdString;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.spec.XML;
import org.jboss.logging.Messages;

public class ResourceAdapterImpl
implements ResourceAdapter {
    private static final long serialVersionUID = 1L;
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    private XsdString resourceadapterClass;
    private List<ConfigProperty> configProperties;
    private OutboundResourceAdapter outboundResourceadapter;
    private InboundResourceAdapter inboundResourceadapter;
    private List<AdminObject> adminobjects;
    private List<SecurityPermission> securityPermissions;
    private String id;

    public ResourceAdapterImpl(XsdString resourceadapterClass, List<ConfigProperty> configProperties, OutboundResourceAdapter outboundResourceadapter, InboundResourceAdapter inboundResourceadapter, List<AdminObject> adminobjects, List<SecurityPermission> securityPermissions, String id) {
        this.resourceadapterClass = resourceadapterClass;
        if (!XsdString.isNull((XsdString)this.resourceadapterClass)) {
            this.resourceadapterClass.setTag(XML.ResourceAdapterTag.RESOURCEADAPTER_CLASS.toString());
        }
        this.configProperties = configProperties != null ? new ArrayList<ConfigProperty>(configProperties) : new ArrayList<ConfigProperty>(0);
        this.outboundResourceadapter = outboundResourceadapter;
        this.inboundResourceadapter = inboundResourceadapter;
        this.adminobjects = adminobjects != null ? new ArrayList<AdminObject>(adminobjects) : new ArrayList<AdminObject>(0);
        this.securityPermissions = securityPermissions != null ? new ArrayList<SecurityPermission>(securityPermissions) : new ArrayList<SecurityPermission>(0);
        this.id = id;
    }

    public String getResourceadapterClass() {
        if (XsdString.isNull((XsdString)this.resourceadapterClass)) {
            return null;
        }
        return this.resourceadapterClass.getValue();
    }

    public List<ConfigProperty> getConfigProperties() {
        return this.configProperties;
    }

    public synchronized void forceConfigProperties(List<ConfigProperty> newContents) {
        this.configProperties = newContents != null ? new ArrayList<ConfigProperty>(newContents) : new ArrayList<ConfigProperty>(0);
    }

    public OutboundResourceAdapter getOutboundResourceadapter() {
        return this.outboundResourceadapter;
    }

    public InboundResourceAdapter getInboundResourceadapter() {
        return this.inboundResourceadapter;
    }

    public List<AdminObject> getAdminObjects() {
        return Collections.unmodifiableList(this.adminobjects);
    }

    public synchronized void forceAdminObjects(List<AdminObject> newContent) {
        this.adminobjects = newContent != null ? new ArrayList<AdminObject>(newContent) : new ArrayList<AdminObject>(0);
    }

    public List<SecurityPermission> getSecurityPermissions() {
        return Collections.unmodifiableList(this.securityPermissions);
    }

    public String getId() {
        return this.id;
    }

    public void validate() throws ValidateException {
        boolean inboundOrOutbound = false;
        if (this.getOutboundResourceadapter() != null && this.getOutboundResourceadapter().validationAsBoolean()) {
            inboundOrOutbound = true;
        }
        if (this.getInboundResourceadapter() != null && this.getInboundResourceadapter().validationAsBoolean() && this.getResourceadapterClass() != null) {
            inboundOrOutbound = true;
        }
        if (!inboundOrOutbound && (XsdString.isNull((XsdString)this.resourceadapterClass) || this.resourceadapterClass.getValue().trim().equals(""))) {
            throw new ValidateException(bundle.invalidMetadataForResourceAdapter());
        }
    }

    public ResourceAdapter merge(MergeableMetadata<?> jmd) throws Exception {
        if (jmd instanceof ResourceAdapterImpl) {
            ResourceAdapterImpl inputRA = (ResourceAdapterImpl)jmd;
            InboundResourceAdapter newInboundResourceadapter = this.inboundResourceadapter == null ? inputRA.inboundResourceadapter : (InboundResourceAdapter)this.inboundResourceadapter.merge((MergeableMetadata)inputRA.inboundResourceadapter);
            OutboundResourceAdapter newOutboundResourceadapter = this.outboundResourceadapter == null ? inputRA.outboundResourceadapter : (OutboundResourceAdapter)this.outboundResourceadapter.merge((MergeableMetadata)inputRA.outboundResourceadapter);
            List newSecurityPermission = MergeUtil.mergeList(this.securityPermissions, inputRA.securityPermissions);
            List newConfigProperties = MergeUtil.mergeConfigList(this.configProperties, inputRA.configProperties);
            List newAdminobjects = MergeUtil.mergeList(this.adminobjects, inputRA.adminobjects);
            String newId = this.id == null ? inputRA.id : this.id;
            XsdString newResourceadapterClass = XsdString.isNull((XsdString)this.resourceadapterClass) ? inputRA.resourceadapterClass : this.resourceadapterClass;
            return new ResourceAdapterImpl(newResourceadapterClass, newConfigProperties, newOutboundResourceadapter, newInboundResourceadapter, newAdminobjects, newSecurityPermission, newId);
        }
        return this;
    }

    public CopyableMetaData copy() {
        return new ResourceAdapterImpl((XsdString)CopyUtil.clone((CopyableMetaData)this.resourceadapterClass), CopyUtil.cloneList(this.configProperties), (OutboundResourceAdapter)CopyUtil.clone((CopyableMetaData)this.outboundResourceadapter), (InboundResourceAdapter)CopyUtil.clone((CopyableMetaData)this.inboundResourceadapter), CopyUtil.cloneList(this.adminobjects), CopyUtil.cloneList(this.securityPermissions), CopyUtil.cloneString((String)this.id));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.adminobjects == null ? 0 : this.adminobjects.hashCode());
        result = 31 * result + (this.configProperties == null ? 0 : this.configProperties.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.inboundResourceadapter == null ? 0 : this.inboundResourceadapter.hashCode());
        result = 31 * result + (this.outboundResourceadapter == null ? 0 : this.outboundResourceadapter.hashCode());
        result = 31 * result + (this.resourceadapterClass == null ? 0 : this.resourceadapterClass.hashCode());
        result = 31 * result + (this.securityPermissions == null ? 0 : this.securityPermissions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceAdapterImpl)) {
            return false;
        }
        ResourceAdapterImpl other = (ResourceAdapterImpl)obj;
        if (this.adminobjects == null ? other.adminobjects != null : !this.adminobjects.equals(other.adminobjects)) {
            return false;
        }
        if (this.configProperties == null ? other.configProperties != null : !this.configProperties.equals(other.configProperties)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.inboundResourceadapter == null ? other.inboundResourceadapter != null : !this.inboundResourceadapter.equals(other.inboundResourceadapter)) {
            return false;
        }
        if (this.outboundResourceadapter == null ? other.outboundResourceadapter != null : !this.outboundResourceadapter.equals(other.outboundResourceadapter)) {
            return false;
        }
        if (this.resourceadapterClass == null ? other.resourceadapterClass != null : !this.resourceadapterClass.equals((Object)other.resourceadapterClass)) {
            return false;
        }
        return !(this.securityPermissions == null ? other.securityPermissions != null : !this.securityPermissions.equals(other.securityPermissions));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<").append("resourceadapter");
        if (this.id != null) {
            sb.append(" id=\"").append(this.id).append("\"");
        }
        sb.append(">");
        if (this.resourceadapterClass != null) {
            sb.append(this.resourceadapterClass);
        }
        if (this.configProperties != null) {
            for (ConfigProperty cp : this.configProperties) {
                sb.append(cp);
            }
        }
        if (this.outboundResourceadapter != null) {
            sb.append(this.outboundResourceadapter);
        }
        if (this.inboundResourceadapter != null) {
            sb.append(this.inboundResourceadapter);
        }
        if (this.adminobjects != null) {
            for (AdminObject ao : this.adminobjects) {
                sb.append(ao);
            }
        }
        if (this.securityPermissions != null) {
            for (SecurityPermission sp : this.securityPermissions) {
                sb.append(sp);
            }
        }
        sb.append("</resourceadapter>");
        return sb.toString();
    }
}

