/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.uri;

import java.io.NotSerializableException;
import java.net.URI;
import java.util.Map;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.JGroupsFileBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.JGroupsPropertiesBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.uri.AbstractServerLocatorSchema;
import org.apache.activemq.artemis.uri.ConnectionOptions;

public class JGroupsServerLocatorSchema
extends AbstractServerLocatorSchema {
    @Override
    public String getSchemaName() {
        return "jgroups";
    }

    @Override
    protected ServerLocator internalNewObject(URI uri, Map<String, String> query, String name) throws Exception {
        ConnectionOptions options = this.newConnectionOptions(uri, query);
        DiscoveryGroupConfiguration dcConfig = JGroupsServerLocatorSchema.getDiscoveryGroupConfiguration(uri, query, name);
        if (options.isHa()) {
            return ActiveMQClient.createServerLocatorWithHA(dcConfig);
        }
        return ActiveMQClient.createServerLocatorWithoutHA(dcConfig);
    }

    @Override
    protected URI internalNewURI(ServerLocator bean) throws Exception {
        String auth;
        DiscoveryGroupConfiguration dgc = bean.getDiscoveryGroupConfiguration();
        BroadcastEndpointFactory endpoint = dgc.getBroadcastEndpointFactory();
        if (endpoint instanceof JGroupsFileBroadcastEndpointFactory) {
            auth = ((JGroupsFileBroadcastEndpointFactory)endpoint).getChannelName();
        } else if (endpoint instanceof JGroupsPropertiesBroadcastEndpointFactory) {
            auth = ((JGroupsPropertiesBroadcastEndpointFactory)endpoint).getChannelName();
        } else {
            throw new NotSerializableException(endpoint + "not serializable");
        }
        String query = JGroupsServerLocatorSchema.getData(null, bean, dgc, endpoint);
        dgc.setBroadcastEndpointFactory(endpoint);
        return new URI("jgroups", null, auth, -1, null, query, null);
    }

    public static DiscoveryGroupConfiguration getDiscoveryGroupConfiguration(URI uri, Map<String, String> query, String name) throws Exception {
        BroadcastEndpointFactory endpointFactory = query.containsKey("file") ? new JGroupsFileBroadcastEndpointFactory().setChannelName(uri.getAuthority()) : new JGroupsPropertiesBroadcastEndpointFactory().setChannelName(uri.getAuthority());
        JGroupsServerLocatorSchema.setData(uri, endpointFactory, query);
        DiscoveryGroupConfiguration dcConfig = new DiscoveryGroupConfiguration().setName(name).setBroadcastEndpointFactory(endpointFactory);
        JGroupsServerLocatorSchema.setData(uri, dcConfig, query);
        return dcConfig;
    }
}

