/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.transaction.xa.Xid;
import org.infinispan.Cache;
import org.infinispan.atomic.Delta;
import org.infinispan.commands.CancelCommand;
import org.infinispan.commands.CancellationService;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.CreateCacheCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.functional.ReadOnlyKeyCommand;
import org.infinispan.commands.functional.ReadOnlyManyCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.module.ModuleCommandInitializer;
import org.infinispan.commands.read.DistributedExecuteCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.read.SizeCommand;
import org.infinispan.commands.remote.ClusteredGetAllCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.remote.recovery.CompleteTransactionCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTransactionsCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTxInfoCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderCommitCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderNonVersionedPrepareCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderRollbackCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderVersionedCommitCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderVersionedPrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.BackupAckCommand;
import org.infinispan.commands.write.BackupMultiKeyAckCommand;
import org.infinispan.commands.write.BackupPutMapRpcCommand;
import org.infinispan.commands.write.BackupWriteRpcCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.ExceptionAckCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.RemoveExpiredCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.LambdaExternalizer;
import org.infinispan.commons.marshall.SerializeFunctionWith;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.conflict.impl.StateReceiver;
import org.infinispan.container.DataContainer;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.group.impl.GroupManager;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.functional.impl.Params;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.marshall.core.GlobalMarshaller;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateChunk;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.statetransfer.StateProvider;
import org.infinispan.statetransfer.StateRequestCommand;
import org.infinispan.statetransfer.StateResponseCommand;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.stream.impl.ClusterStreamManager;
import org.infinispan.stream.impl.LocalStreamManager;
import org.infinispan.stream.impl.StreamRequestCommand;
import org.infinispan.stream.impl.StreamResponseCommand;
import org.infinispan.stream.impl.StreamSegmentResponseCommand;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CommandAckCollector;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.BackupSender;
import org.infinispan.xsite.SingleXSiteRpcCommand;
import org.infinispan.xsite.XSiteAdminCommand;
import org.infinispan.xsite.statetransfer.XSiteState;
import org.infinispan.xsite.statetransfer.XSiteStateConsumer;
import org.infinispan.xsite.statetransfer.XSiteStateProvider;
import org.infinispan.xsite.statetransfer.XSiteStatePushCommand;
import org.infinispan.xsite.statetransfer.XSiteStateTransferControlCommand;
import org.infinispan.xsite.statetransfer.XSiteStateTransferManager;

public class CommandsFactoryImpl
implements CommandsFactory {
    private static final Log log = LogFactory.getLog(CommandsFactoryImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private DataContainer dataContainer;
    private CacheNotifier<Object, Object> notifier;
    private Cache<Object, Object> cache;
    private ByteString cacheName;
    private boolean transactional;
    private boolean totalOrderProtocol;
    private AsyncInterceptorChain interceptorChain;
    private DistributionManager distributionManager;
    private InvocationContextFactory icf;
    private TransactionTable txTable;
    private Configuration configuration;
    private RecoveryManager recoveryManager;
    private StateProvider stateProvider;
    private StateConsumer stateConsumer;
    private LockManager lockManager;
    private InternalEntryFactory entryFactory;
    private StateTransferManager stateTransferManager;
    private BackupSender backupSender;
    private CancellationService cancellationService;
    private XSiteStateProvider xSiteStateProvider;
    private XSiteStateConsumer xSiteStateConsumer;
    private XSiteStateTransferManager xSiteStateTransferManager;
    private GroupManager groupManager;
    private LocalStreamManager localStreamManager;
    private ClusterStreamManager clusterStreamManager;
    private ClusteringDependentLogic clusteringDependentLogic;
    private CommandAckCollector commandAckCollector;
    private StateReceiver stateReceiver;
    private Map<Byte, ModuleCommandInitializer> moduleCommandInitializers;
    private StreamingMarshaller marshaller;

    @Inject
    public void setupDependencies(DataContainer container, CacheNotifier<Object, Object> notifier, Cache<Object, Object> cache, AsyncInterceptorChain interceptorChain, DistributionManager distributionManager, InvocationContextFactory icf, TransactionTable txTable, Configuration configuration, @ComponentName(value="org.infinispan.modules.command.initializers") Map<Byte, ModuleCommandInitializer> moduleCommandInitializers, RecoveryManager recoveryManager, StateProvider stateProvider, StateConsumer stateConsumer, LockManager lockManager, InternalEntryFactory entryFactory, StateTransferManager stm, BackupSender backupSender, CancellationService cancellationService, XSiteStateProvider xSiteStateProvider, XSiteStateConsumer xSiteStateConsumer, XSiteStateTransferManager xSiteStateTransferManager, GroupManager groupManager, LocalStreamManager localStreamManager, ClusterStreamManager clusterStreamManager, ClusteringDependentLogic clusteringDependentLogic, StreamingMarshaller marshaller, CommandAckCollector commandAckCollector, StateReceiver stateReceiver) {
        this.dataContainer = container;
        this.notifier = notifier;
        this.cache = cache;
        this.interceptorChain = interceptorChain;
        this.distributionManager = distributionManager;
        this.icf = icf;
        this.txTable = txTable;
        this.configuration = configuration;
        this.moduleCommandInitializers = moduleCommandInitializers;
        this.recoveryManager = recoveryManager;
        this.stateProvider = stateProvider;
        this.stateConsumer = stateConsumer;
        this.lockManager = lockManager;
        this.entryFactory = entryFactory;
        this.stateTransferManager = stm;
        this.backupSender = backupSender;
        this.cancellationService = cancellationService;
        this.xSiteStateConsumer = xSiteStateConsumer;
        this.xSiteStateProvider = xSiteStateProvider;
        this.xSiteStateTransferManager = xSiteStateTransferManager;
        this.groupManager = groupManager;
        this.localStreamManager = localStreamManager;
        this.clusterStreamManager = clusterStreamManager;
        this.clusteringDependentLogic = clusteringDependentLogic;
        this.marshaller = marshaller;
        this.commandAckCollector = commandAckCollector;
        this.stateReceiver = stateReceiver;
    }

    @Start(priority=1)
    public void start() {
        this.cacheName = ByteString.fromString(this.cache.getName());
        this.transactional = this.configuration.transaction().transactionMode().isTransactional();
        this.totalOrderProtocol = this.configuration.transaction().transactionProtocol().isTotalOrder();
    }

    @Override
    public PutKeyValueCommand buildPutKeyValueCommand(Object key, Object value, Metadata metadata, long flagsBitSet) {
        boolean reallyTransactional = this.transactional && !EnumUtil.containsAny((long)flagsBitSet, (long)FlagBitSets.PUT_FOR_EXTERNAL_READ);
        return new PutKeyValueCommand(key, value, false, this.notifier, metadata, flagsBitSet, this.generateUUID(reallyTransactional));
    }

    @Override
    public RemoveCommand buildRemoveCommand(Object key, Object value, long flagsBitSet) {
        return new RemoveCommand(key, value, this.notifier, flagsBitSet, this.generateUUID(this.transactional));
    }

    @Override
    public InvalidateCommand buildInvalidateCommand(long flagsBitSet, Object ... keys) {
        return new InvalidateCommand(this.notifier, flagsBitSet, this.generateUUID(false), keys);
    }

    @Override
    public InvalidateCommand buildInvalidateFromL1Command(long flagsBitSet, Collection<Object> keys) {
        return new InvalidateL1Command(this.dataContainer, this.distributionManager, this.notifier, flagsBitSet, keys, this.generateUUID(this.transactional));
    }

    @Override
    public InvalidateCommand buildInvalidateFromL1Command(Address origin, long flagsBitSet, Collection<Object> keys) {
        return new InvalidateL1Command(origin, this.dataContainer, this.distributionManager, this.notifier, flagsBitSet, keys, this.generateUUID(false));
    }

    @Override
    public RemoveExpiredCommand buildRemoveExpiredCommand(Object key, Object value, Long lifespan) {
        return new RemoveExpiredCommand(key, value, lifespan, this.notifier, this.generateUUID(this.transactional));
    }

    @Override
    public ReplaceCommand buildReplaceCommand(Object key, Object oldValue, Object newValue, Metadata metadata, long flagsBitSet) {
        return new ReplaceCommand(key, oldValue, newValue, this.notifier, metadata, flagsBitSet, this.generateUUID(this.transactional));
    }

    @Override
    public SizeCommand buildSizeCommand(long flagsBitSet) {
        return new SizeCommand(this.cache, flagsBitSet);
    }

    @Override
    public KeySetCommand buildKeySetCommand(long flagsBitSet) {
        return new KeySetCommand<Object, Object>(this.cache, flagsBitSet);
    }

    @Override
    public EntrySetCommand buildEntrySetCommand(long flagsBitSet) {
        return new EntrySetCommand<Object, Object>(this.cache, flagsBitSet);
    }

    @Override
    public GetKeyValueCommand buildGetKeyValueCommand(Object key, long flagsBitSet) {
        return new GetKeyValueCommand(key, flagsBitSet);
    }

    @Override
    public GetAllCommand buildGetAllCommand(Collection<?> keys, long flagsBitSet, boolean returnEntries) {
        return new GetAllCommand(keys, flagsBitSet, returnEntries, this.entryFactory);
    }

    @Override
    public PutMapCommand buildPutMapCommand(Map<?, ?> map, Metadata metadata, long flagsBitSet) {
        return new PutMapCommand(map, this.notifier, metadata, flagsBitSet, this.generateUUID(this.transactional));
    }

    @Override
    public ClearCommand buildClearCommand(long flagsBitSet) {
        return new ClearCommand(this.notifier, this.dataContainer, flagsBitSet);
    }

    @Override
    public EvictCommand buildEvictCommand(Object key, long flagsBitSet) {
        return new EvictCommand(key, this.notifier, flagsBitSet, this.generateUUID(this.transactional), this.entryFactory);
    }

    @Override
    public PrepareCommand buildPrepareCommand(GlobalTransaction gtx, List<WriteCommand> modifications, boolean onePhaseCommit) {
        return this.totalOrderProtocol ? new TotalOrderNonVersionedPrepareCommand(this.cacheName, gtx, modifications) : new PrepareCommand(this.cacheName, gtx, modifications, onePhaseCommit);
    }

    @Override
    public VersionedPrepareCommand buildVersionedPrepareCommand(GlobalTransaction gtx, List<WriteCommand> modifications, boolean onePhase) {
        return this.totalOrderProtocol ? new TotalOrderVersionedPrepareCommand(this.cacheName, gtx, modifications, onePhase) : new VersionedPrepareCommand(this.cacheName, gtx, modifications, onePhase);
    }

    @Override
    public CommitCommand buildCommitCommand(GlobalTransaction gtx) {
        return this.totalOrderProtocol ? new TotalOrderCommitCommand(this.cacheName, gtx) : new CommitCommand(this.cacheName, gtx);
    }

    @Override
    public VersionedCommitCommand buildVersionedCommitCommand(GlobalTransaction gtx) {
        return this.totalOrderProtocol ? new TotalOrderVersionedCommitCommand(this.cacheName, gtx) : new VersionedCommitCommand(this.cacheName, gtx);
    }

    @Override
    public RollbackCommand buildRollbackCommand(GlobalTransaction gtx) {
        return this.totalOrderProtocol ? new TotalOrderRollbackCommand(this.cacheName, gtx) : new RollbackCommand(this.cacheName, gtx);
    }

    @Override
    public SingleRpcCommand buildSingleRpcCommand(ReplicableCommand call) {
        return new SingleRpcCommand(this.cacheName, call);
    }

    @Override
    public ClusteredGetCommand buildClusteredGetCommand(Object key, long flagsBitSet) {
        return new ClusteredGetCommand(key, this.cacheName, flagsBitSet);
    }

    @Override
    public void initializeReplicableCommand(ReplicableCommand c, boolean isRemote) {
        if (c == null) {
            return;
        }
        switch (c.getCommandId()) {
            case 8: {
                ((PutKeyValueCommand)c).init(this.notifier);
                break;
            }
            case 11: {
                ((ReplaceCommand)c).init(this.notifier);
                break;
            }
            case 9: {
                ((PutMapCommand)c).init(this.notifier);
                break;
            }
            case 10: {
                ((RemoveCommand)c).init(this.notifier);
                break;
            }
            case 1: {
                SingleRpcCommand src = (SingleRpcCommand)c;
                src.init(this.interceptorChain, this.icf);
                if (src.getCommand() == null) break;
                this.initializeReplicableCommand(src.getCommand(), false);
                break;
            }
            case 6: {
                InvalidateCommand ic = (InvalidateCommand)c;
                ic.init(this.notifier);
                break;
            }
            case 7: {
                InvalidateL1Command ilc = (InvalidateL1Command)c;
                ilc.init(this.distributionManager, this.notifier, this.dataContainer);
                break;
            }
            case 12: 
            case 26: 
            case 38: 
            case 39: {
                PrepareCommand pc = (PrepareCommand)c;
                pc.init(this.interceptorChain, this.icf, this.txTable);
                pc.initialize(this.notifier, this.recoveryManager);
                if (pc.getModifications() != null) {
                    for (WriteCommand nested : pc.getModifications()) {
                        this.initializeReplicableCommand(nested, false);
                    }
                }
                pc.markTransactionAsRemote(isRemote);
                break;
            }
            case 14: 
            case 27: 
            case 35: 
            case 36: {
                CommitCommand commitCommand = (CommitCommand)c;
                commitCommand.init(this.interceptorChain, this.icf, this.txTable);
                commitCommand.markTransactionAsRemote(isRemote);
                break;
            }
            case 13: 
            case 37: {
                RollbackCommand rollbackCommand = (RollbackCommand)c;
                rollbackCommand.init(this.interceptorChain, this.icf, this.txTable);
                rollbackCommand.markTransactionAsRemote(isRemote);
                break;
            }
            case 5: {
                ClearCommand cc = (ClearCommand)c;
                cc.init(this.notifier, this.dataContainer);
                break;
            }
            case 16: {
                ClusteredGetCommand clusteredGetCommand = (ClusteredGetCommand)c;
                clusteredGetCommand.initialize(this.icf, this, this.entryFactory, this.interceptorChain);
                break;
            }
            case 3: {
                LockControlCommand lcc = (LockControlCommand)c;
                lcc.init(this.interceptorChain, this.icf, this.txTable);
                lcc.markTransactionAsRemote(isRemote);
                break;
            }
            case 15: {
                ((StateRequestCommand)c).init(this.stateProvider);
                break;
            }
            case 20: {
                ((StateResponseCommand)c).init(this.stateConsumer, this.stateReceiver);
                break;
            }
            case 21: {
                GetInDoubtTransactionsCommand gptx = (GetInDoubtTransactionsCommand)c;
                gptx.init(this.recoveryManager);
                break;
            }
            case 22: {
                TxCompletionNotificationCommand ftx = (TxCompletionNotificationCommand)c;
                ftx.init(this.txTable, this.lockManager, this.recoveryManager, this.stateTransferManager);
                break;
            }
            case 19: {
                DistributedExecuteCommand dec = (DistributedExecuteCommand)c;
                dec.init(this.cache);
                break;
            }
            case 23: {
                GetInDoubtTxInfoCommand gidTxInfoCommand = (GetInDoubtTxInfoCommand)c;
                gidTxInfoCommand.init(this.recoveryManager);
                break;
            }
            case 24: {
                CompleteTransactionCommand ccc = (CompleteTransactionCommand)c;
                ccc.init(this.recoveryManager);
                break;
            }
            case 25: {
                break;
            }
            case 29: {
                CreateCacheCommand createCacheCommand = (CreateCacheCommand)c;
                createCacheCommand.init(this.cache.getCacheManager());
                break;
            }
            case 32: {
                XSiteAdminCommand xSiteAdminCommand = (XSiteAdminCommand)c;
                xSiteAdminCommand.init(this.backupSender);
                break;
            }
            case 34: {
                CancelCommand cancelCommand = (CancelCommand)c;
                cancelCommand.init(this.cancellationService);
                break;
            }
            case 28: {
                XSiteStateTransferControlCommand xSiteStateTransferControlCommand = (XSiteStateTransferControlCommand)c;
                xSiteStateTransferControlCommand.initialize(this.xSiteStateProvider, this.xSiteStateConsumer, this.xSiteStateTransferManager);
                break;
            }
            case 33: {
                XSiteStatePushCommand xSiteStatePushCommand = (XSiteStatePushCommand)c;
                xSiteStatePushCommand.initialize(this.xSiteStateConsumer);
                break;
            }
            case 43: {
                GetKeysInGroupCommand getKeysInGroupCommand = (GetKeysInGroupCommand)c;
                getKeysInGroupCommand.setGroupManager(this.groupManager);
                break;
            }
            case 46: {
                ClusteredGetAllCommand clusteredGetAllCommand = (ClusteredGetAllCommand)c;
                clusteredGetAllCommand.init(this.icf, this, this.entryFactory, this.interceptorChain, this.txTable);
                break;
            }
            case 47: {
                StreamRequestCommand streamRequestCommand = (StreamRequestCommand)c;
                streamRequestCommand.inject(this.localStreamManager);
                break;
            }
            case 48: {
                StreamResponseCommand streamResponseCommand = (StreamResponseCommand)c;
                streamResponseCommand.inject(this.clusterStreamManager);
                break;
            }
            case 49: {
                StreamSegmentResponseCommand streamSegmentResponseCommand = (StreamSegmentResponseCommand)c;
                streamSegmentResponseCommand.inject(this.clusterStreamManager);
                break;
            }
            case 58: {
                RemoveExpiredCommand removeExpiredCommand = (RemoveExpiredCommand)c;
                removeExpiredCommand.init(this.notifier);
                break;
            }
            case 2: {
                BackupAckCommand command = (BackupAckCommand)c;
                command.setCommandAckCollector(this.commandAckCollector);
                break;
            }
            case 61: {
                BackupWriteRpcCommand bwc = (BackupWriteRpcCommand)c;
                bwc.init(this.icf, this.interceptorChain, this.notifier);
                break;
            }
            case 41: {
                ((BackupMultiKeyAckCommand)c).setCommandAckCollector(this.commandAckCollector);
                break;
            }
            case 42: {
                ((ExceptionAckCommand)c).setCommandAckCollector(this.commandAckCollector);
                break;
            }
            case 66: {
                ((BackupPutMapRpcCommand)c).init(this.icf, this.interceptorChain, this.notifier);
                break;
            }
            default: {
                ModuleCommandInitializer mci = this.moduleCommandInitializers.get(c.getCommandId());
                if (mci != null) {
                    mci.initializeReplicableCommand(c, isRemote);
                    break;
                }
                if (!trace) break;
                log.tracef("Nothing to initialize for command: %s", c);
            }
        }
    }

    @Override
    public LockControlCommand buildLockControlCommand(Collection<?> keys, long flagsBitSet, GlobalTransaction gtx) {
        return new LockControlCommand(keys, this.cacheName, flagsBitSet, gtx);
    }

    @Override
    public LockControlCommand buildLockControlCommand(Object key, long flagsBitSet, GlobalTransaction gtx) {
        return new LockControlCommand(key, this.cacheName, flagsBitSet, gtx);
    }

    @Override
    public LockControlCommand buildLockControlCommand(Collection<?> keys, long flagsBitSet) {
        return new LockControlCommand(keys, this.cacheName, flagsBitSet, null);
    }

    @Override
    public StateRequestCommand buildStateRequestCommand(StateRequestCommand.Type subtype, Address sender, int viewId, Set<Integer> segments) {
        return new StateRequestCommand(this.cacheName, subtype, sender, viewId, segments);
    }

    @Override
    public StateResponseCommand buildStateResponseCommand(Address sender, int topologyId, Collection<StateChunk> stateChunks, boolean applyState) {
        return new StateResponseCommand(this.cacheName, sender, topologyId, stateChunks, applyState);
    }

    @Override
    public String getCacheName() {
        return this.cacheName.toString();
    }

    @Override
    public GetInDoubtTransactionsCommand buildGetInDoubtTransactionsCommand() {
        return new GetInDoubtTransactionsCommand(this.cacheName);
    }

    @Override
    public TxCompletionNotificationCommand buildTxCompletionNotificationCommand(Xid xid, GlobalTransaction globalTransaction) {
        return new TxCompletionNotificationCommand(xid, globalTransaction, this.cacheName);
    }

    @Override
    public TxCompletionNotificationCommand buildTxCompletionNotificationCommand(long internalId) {
        return new TxCompletionNotificationCommand(internalId, this.cacheName);
    }

    @Override
    public <T> DistributedExecuteCommand<T> buildDistributedExecuteCommand(Callable<T> callable, Address sender, Collection keys) {
        return new DistributedExecuteCommand<T>(this.cacheName, keys, callable);
    }

    @Override
    public GetInDoubtTxInfoCommand buildGetInDoubtTxInfoCommand() {
        return new GetInDoubtTxInfoCommand(this.cacheName);
    }

    @Override
    public CompleteTransactionCommand buildCompleteTransactionCommand(Xid xid, boolean commit) {
        return new CompleteTransactionCommand(this.cacheName, xid, commit);
    }

    @Override
    public ApplyDeltaCommand buildApplyDeltaCommand(Object deltaAwareValueKey, Delta delta, Collection keys) {
        return new ApplyDeltaCommand(deltaAwareValueKey, delta, keys, this.generateUUID(this.transactional));
    }

    @Override
    public CreateCacheCommand buildCreateCacheCommand(String cacheNameToCreate, String cacheConfigurationName) {
        return new CreateCacheCommand(this.cacheName, cacheNameToCreate, cacheConfigurationName);
    }

    @Override
    public CreateCacheCommand buildCreateCacheCommand(String cacheNameToCreate, String cacheConfigurationName, int size) {
        return new CreateCacheCommand(this.cacheName, cacheNameToCreate, cacheConfigurationName, size);
    }

    @Override
    public CancelCommand buildCancelCommandCommand(UUID commandUUID) {
        return new CancelCommand(this.cacheName, commandUUID);
    }

    @Override
    public XSiteStateTransferControlCommand buildXSiteStateTransferControlCommand(XSiteStateTransferControlCommand.StateTransferControl control, String siteName) {
        return new XSiteStateTransferControlCommand(this.cacheName, control, siteName);
    }

    @Override
    public XSiteAdminCommand buildXSiteAdminCommand(String siteName, XSiteAdminCommand.AdminOperation op, Integer afterFailures, Long minTimeToWait) {
        return new XSiteAdminCommand(this.cacheName, siteName, op, afterFailures, minTimeToWait);
    }

    @Override
    public XSiteStatePushCommand buildXSiteStatePushCommand(XSiteState[] chunk, long timeoutMillis) {
        return new XSiteStatePushCommand(this.cacheName, chunk, timeoutMillis);
    }

    @Override
    public SingleXSiteRpcCommand buildSingleXSiteRpcCommand(VisitableCommand command) {
        return new SingleXSiteRpcCommand(this.cacheName, command);
    }

    @Override
    public GetKeysInGroupCommand buildGetKeysInGroupCommand(long flagsBitSet, Object groupName) {
        return new GetKeysInGroupCommand(flagsBitSet, groupName).setGroupManager(this.groupManager);
    }

    @Override
    public <K> StreamRequestCommand<K> buildStreamRequestCommand(Object id, boolean parallelStream, StreamRequestCommand.Type type, Set<Integer> segments, Set<K> keys, Set<K> excludedKeys, boolean includeLoader, Object terminalOperation) {
        return new StreamRequestCommand<K>(this.cacheName, this.cache.getCacheManager().getAddress(), id, parallelStream, type, segments, keys, excludedKeys, includeLoader, terminalOperation);
    }

    @Override
    public <R> StreamResponseCommand<R> buildStreamResponseCommand(Object identifier, boolean complete, Set<Integer> lostSegments, R response) {
        if (lostSegments.isEmpty()) {
            return new StreamResponseCommand<R>(this.cacheName, this.cache.getCacheManager().getAddress(), identifier, complete, response);
        }
        return new StreamSegmentResponseCommand<R>(this.cacheName, this.cache.getCacheManager().getAddress(), identifier, complete, response, lostSegments);
    }

    @Override
    public GetCacheEntryCommand buildGetCacheEntryCommand(Object key, long flagsBitSet) {
        return new GetCacheEntryCommand(key, flagsBitSet, this.entryFactory);
    }

    @Override
    public ClusteredGetAllCommand buildClusteredGetAllCommand(List<?> keys, long flagsBitSet, GlobalTransaction gtx) {
        return new ClusteredGetAllCommand(this.cacheName, keys, flagsBitSet, gtx);
    }

    private CommandInvocationId generateUUID(boolean tx) {
        if (tx) {
            return CommandInvocationId.DUMMY_INVOCATION_ID;
        }
        return CommandInvocationId.generateId(this.clusteringDependentLogic.getAddress());
    }

    @Override
    public <K, V, R> ReadOnlyKeyCommand<K, V, R> buildReadOnlyKeyCommand(K key, Function<EntryView.ReadEntryView<K, V>, R> f, Params params) {
        return new ReadOnlyKeyCommand<K, V, R>(key, f, params);
    }

    @Override
    public <K, V, R> ReadOnlyManyCommand<K, V, R> buildReadOnlyManyCommand(Collection<? extends K> keys, Function<EntryView.ReadEntryView<K, V>, R> f, Params params) {
        return new ReadOnlyManyCommand<K, V, R>(keys, f, params);
    }

    @Override
    public <K, V, R> ReadWriteKeyValueCommand<K, V, R> buildReadWriteKeyValueCommand(K key, V value, BiFunction<V, EntryView.ReadWriteEntryView<K, V>, R> f, Params params) {
        return new ReadWriteKeyValueCommand<K, V, R>(key, value, f, this.generateUUID(this.transactional), this.getValueMatcher(f), params);
    }

    @Override
    public <K, V, R> ReadWriteKeyCommand<K, V, R> buildReadWriteKeyCommand(K key, Function<EntryView.ReadWriteEntryView<K, V>, R> f, Params params) {
        return new ReadWriteKeyCommand<K, V, R>(key, f, this.generateUUID(this.transactional), this.getValueMatcher(f), params);
    }

    @Override
    public <K, V, R> ReadWriteManyCommand<K, V, R> buildReadWriteManyCommand(Collection<? extends K> keys, Function<EntryView.ReadWriteEntryView<K, V>, R> f, Params params) {
        return new ReadWriteManyCommand<K, V, R>(keys, f, params, this.generateUUID(this.transactional));
    }

    @Override
    public <K, V, R> ReadWriteManyEntriesCommand<K, V, R> buildReadWriteManyEntriesCommand(Map<? extends K, ? extends V> entries, BiFunction<V, EntryView.ReadWriteEntryView<K, V>, R> f, Params params) {
        return new ReadWriteManyEntriesCommand<K, V, R>(entries, f, params, this.generateUUID(this.transactional));
    }

    @Override
    public <K, V> WriteOnlyKeyCommand<K, V> buildWriteOnlyKeyCommand(K key, Consumer<EntryView.WriteEntryView<V>> f, Params params) {
        return new WriteOnlyKeyCommand<K, V>(key, f, this.generateUUID(this.transactional), this.getValueMatcher(f), params);
    }

    @Override
    public <K, V> WriteOnlyKeyValueCommand<K, V> buildWriteOnlyKeyValueCommand(K key, V value, BiConsumer<V, EntryView.WriteEntryView<V>> f, Params params) {
        return new WriteOnlyKeyValueCommand<K, V>(key, value, f, this.generateUUID(this.transactional), this.getValueMatcher(f), params);
    }

    @Override
    public <K, V> WriteOnlyManyCommand<K, V> buildWriteOnlyManyCommand(Collection<? extends K> keys, Consumer<EntryView.WriteEntryView<V>> f, Params params) {
        return new WriteOnlyManyCommand<K, V>(keys, f, params, this.generateUUID(this.transactional));
    }

    @Override
    public <K, V> WriteOnlyManyEntriesCommand<K, V> buildWriteOnlyManyEntriesCommand(Map<? extends K, ? extends V> entries, BiConsumer<V, EntryView.WriteEntryView<V>> f, Params params) {
        return new WriteOnlyManyEntriesCommand<K, V>(entries, f, params, this.generateUUID(this.transactional));
    }

    @Override
    public BackupAckCommand buildBackupAckCommand(long id, int topologyId) {
        return new BackupAckCommand(this.cacheName, id, topologyId);
    }

    @Override
    public BackupMultiKeyAckCommand buildBackupMultiKeyAckCommand(long id, int segment, int topologyId) {
        return new BackupMultiKeyAckCommand(this.cacheName, id, segment, topologyId);
    }

    @Override
    public ExceptionAckCommand buildExceptionAckCommand(long id, Throwable throwable, int topologyId) {
        return new ExceptionAckCommand(this.cacheName, id, throwable, topologyId);
    }

    @Override
    public BackupWriteRpcCommand buildBackupWriteRpcCommand(DataWriteCommand command) {
        BackupWriteRpcCommand cmd = new BackupWriteRpcCommand(this.cacheName);
        command.initBackupWriteRpcCommand(cmd);
        return cmd;
    }

    @Override
    public BackupPutMapRpcCommand buildBackupPutMapRpcCommand(PutMapCommand command) {
        return new BackupPutMapRpcCommand(this.cacheName, command);
    }

    private ValueMatcher getValueMatcher(Object o) {
        SerializeFunctionWith ann = o.getClass().getAnnotation(SerializeFunctionWith.class);
        if (ann != null) {
            return ValueMatcher.valueOf(ann.valueMatcher().toString());
        }
        Externalizer ext = ((GlobalMarshaller)this.marshaller).findExternalizerFor(o);
        if (ext != null && ext instanceof LambdaExternalizer) {
            return ValueMatcher.valueOf(((LambdaExternalizer)ext).valueMatcher(o).toString());
        }
        return ValueMatcher.MATCH_ALWAYS;
    }
}

