/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.AbstractDelegatingCache;
import org.infinispan.cache.impl.DecoratedCache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commons.api.functional.FunctionalMap;
import org.infinispan.commons.api.functional.Param;
import org.infinispan.commons.api.functional.Status;
import org.infinispan.commons.util.Experimental;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.impl.FunctionalNotifier;
import org.infinispan.functional.impl.Params;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.lifecycle.ComponentStatus;

@Experimental
public final class FunctionalMapImpl<K, V>
implements FunctionalMap<K, V> {
    final Params params;
    final AdvancedCache<K, V> cache;
    final AsyncInterceptorChain chain;
    final CommandsFactory commandsFactory;
    final InvocationContextFactory invCtxFactory;
    final Object lockOwner;
    final FunctionalNotifier notifier;

    public static <K, V> FunctionalMapImpl<K, V> create(Params params, AdvancedCache<K, V> cache) {
        params = params.addAll(Params.fromFlagsBitSet(FunctionalMapImpl.getFlagsBitSet(cache)));
        return new FunctionalMapImpl<K, V>(params, cache);
    }

    public static <K, V> FunctionalMapImpl<K, V> create(AdvancedCache<K, V> cache) {
        Params params = Params.fromFlagsBitSet(FunctionalMapImpl.getFlagsBitSet(cache));
        return new FunctionalMapImpl<K, V>(params, cache);
    }

    private static <K, V> long getFlagsBitSet(Cache<K, V> cache) {
        long flagsBitSet = 0L;
        while (true) {
            if (cache instanceof DecoratedCache) {
                flagsBitSet |= ((DecoratedCache)cache).getFlagsBitSet();
            }
            if (!(cache instanceof AbstractDelegatingCache)) break;
            cache = ((AbstractDelegatingCache)cache).getDelegate();
        }
        return flagsBitSet;
    }

    private DecoratedCache<K, V> findDecoratedCache(Cache<K, V> cache) {
        if (cache instanceof AbstractDelegatingCache) {
            if (cache instanceof DecoratedCache) {
                return (DecoratedCache)cache;
            }
            return this.findDecoratedCache(((AbstractDelegatingCache)cache).getDelegate());
        }
        return null;
    }

    private FunctionalMapImpl(Params params, AdvancedCache<K, V> cache) {
        this.params = params;
        this.cache = cache;
        ComponentRegistry componentRegistry = cache.getComponentRegistry();
        this.chain = componentRegistry.getComponent(AsyncInterceptorChain.class);
        this.invCtxFactory = componentRegistry.getComponent(InvocationContextFactory.class);
        DecoratedCache<K, V> decoratedCache = this.findDecoratedCache(cache);
        this.lockOwner = decoratedCache == null ? null : decoratedCache.getLockOwner();
        this.commandsFactory = componentRegistry.getComponent(CommandsFactory.class);
        this.notifier = componentRegistry.getComponent(FunctionalNotifier.class);
    }

    public FunctionalMapImpl<K, V> withParams(Param<?> ... ps) {
        if (ps == null || ps.length == 0) {
            return this;
        }
        if (this.params.containsAll(ps)) {
            return this;
        }
        return FunctionalMapImpl.create(this.params.addAll(ps), this.cache);
    }

    public String getName() {
        return this.cache.getName();
    }

    public Status getStatus() {
        return FunctionalMapImpl.toStatus(this.cache.getStatus());
    }

    public void close() throws Exception {
        this.cache.stop();
    }

    private static Status toStatus(ComponentStatus cacheStatus) {
        return Status.valueOf((String)cacheStatus.name());
    }
}

