/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager.impl;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.impl.AbstractClusterExecutor;
import org.infinispan.manager.impl.ClusterExecutors;
import org.infinispan.manager.impl.ReplicableCommandManagerFunction;
import org.infinispan.manager.impl.ReplicableCommandRunnable;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.CommandAwareRpcDispatcher;
import org.infinispan.remoting.transport.jgroups.JGroupsAddressCache;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.remoting.transport.jgroups.SingleResponseFuture;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.function.TriConsumer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.util.Rsp;

class AllClusterExecutor
extends AbstractClusterExecutor<AllClusterExecutor> {
    private static final Log log = LogFactory.getLog(AllClusterExecutor.class);
    private static final boolean isTrace = log.isTraceEnabled();

    AllClusterExecutor(Predicate<? super Address> predicate, EmbeddedCacheManager manager, JGroupsTransport transport, long time, TimeUnit unit, Executor localExecutor, ScheduledExecutorService timeoutExecutor) {
        super(predicate, manager, transport, time, unit, localExecutor, timeoutExecutor);
    }

    @Override
    public Log getLog() {
        return log;
    }

    @Override
    protected AllClusterExecutor sameClusterExecutor(Predicate<? super Address> predicate, long time, TimeUnit unit) {
        return new AllClusterExecutor(predicate, this.manager, this.transport, time, unit, this.localExecutor, this.timeoutExecutor);
    }

    private <T> CompletableFuture<Void> startLocalInvocation(Function<? super EmbeddedCacheManager, ? extends T> callable, TriConsumer<? super Address, ? super T, ? super Throwable> triConsumer) {
        if (this.me == null || this.predicate == null || this.predicate.test(this.me)) {
            if (isTrace) {
                log.trace("Submitting callable to local node on executor thread! - Usually remote command thread pool");
            }
            return super.submitConsumer(callable, triConsumer);
        }
        return null;
    }

    protected CompletableFuture<Void> startLocalInvocation(Runnable runnable) {
        if (this.me == null || this.predicate == null || this.predicate.test(this.me)) {
            if (isTrace) {
                log.trace("Submitting runnable to local node on executor thread! - Usually remote command thread pool");
            }
            return super.submit(runnable);
        }
        return null;
    }

    @Override
    public void execute(Runnable runnable) {
        this.executeRunnable(runnable, ResponseMode.GET_ALL);
    }

    private CompletableFuture<?> executeRunnable(Runnable runnable, ResponseMode mode) {
        CompletableFuture remoteFuture;
        CompletableFuture<Void> localFuture = this.startLocalInvocation(runnable);
        List<org.jgroups.Address> targets = this.getJGroupsTargets(false);
        int size = targets.size();
        if (size == 1) {
            org.jgroups.Address target = targets.get(0);
            if (isTrace) {
                log.tracef("Submitting runnable to single remote node - JGroups Address %s", target);
            }
            CommandAwareRpcDispatcher card = this.transport.getCommandAwareRpcDispatcher();
            remoteFuture = new CompletableFuture();
            card.invokeRemoteCommand(target, new ReplicableCommandRunnable(runnable), mode, this.unit.toMillis(this.time), DeliverOrder.NONE).handle((r, t) -> {
                if (t != null) {
                    remoteFuture.completeExceptionally((Throwable)t);
                } else {
                    this.consumeResponse((Rsp<Response>)r, target, remoteFuture::completeExceptionally);
                    remoteFuture.complete(null);
                }
                return null;
            });
        } else if (size > 1) {
            CommandAwareRpcDispatcher card = this.transport.getCommandAwareRpcDispatcher();
            remoteFuture = new CompletableFuture();
            card.invokeRemoteCommands(targets, new ReplicableCommandRunnable(runnable), mode, this.unit.toMillis(this.time), null, DeliverOrder.NONE).handle((r, t) -> {
                if (t != null) {
                    remoteFuture.completeExceptionally((Throwable)t);
                } else {
                    r.forEach(e -> this.consumeResponse((Rsp<Response>)((Rsp)e.getValue()), (org.jgroups.Address)e.getKey(), remoteFuture::completeExceptionally));
                    remoteFuture.complete(null);
                }
                return null;
            });
        } else {
            if (localFuture != null) {
                return localFuture;
            }
            return CompletableFutures.completedExceptionFuture((Throwable)((Object)new SuspectException("No available nodes!")));
        }
        if (localFuture != null && mode != ResponseMode.GET_NONE) {
            CompletableFuture future = new CompletableFuture();
            CompletableFuture.allOf(localFuture, remoteFuture).whenComplete((v, t) -> {
                if (t != null) {
                    if (t instanceof CompletionException) {
                        future.completeExceptionally(t.getCause());
                    } else {
                        future.completeExceptionally((Throwable)t);
                    }
                } else {
                    future.complete(null);
                }
            });
            return future;
        }
        return remoteFuture;
    }

    @Override
    public CompletableFuture<Void> submit(Runnable command) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.executeRunnable(command, ResponseMode.GET_ALL).handle((r, t) -> {
            if (t != null) {
                future.completeExceptionally((Throwable)t);
            }
            future.complete(null);
            return null;
        });
        return future;
    }

    @Override
    public <V> CompletableFuture<Void> submitConsumer(Function<? super EmbeddedCacheManager, ? extends V> function, TriConsumer<? super Address, ? super V, ? super Throwable> triConsumer) {
        CompletableFuture<Void> localFuture = this.startLocalInvocation(function, triConsumer);
        List<org.jgroups.Address> targets = this.getJGroupsTargets(false);
        int size = targets.size();
        if (size > 0) {
            CompletableFuture[] futures = new CompletableFuture[size];
            for (int i = 0; i < size; ++i) {
                CommandAwareRpcDispatcher card = this.transport.getCommandAwareRpcDispatcher();
                org.jgroups.Address target = targets.get(i);
                if (isTrace) {
                    log.tracef("Submitting consumer to single remote node - JGroups Address %s", target);
                }
                SingleResponseFuture srf = card.invokeRemoteCommand(target, new ReplicableCommandManagerFunction(function), ResponseMode.GET_ALL, this.unit.toMillis(this.time), DeliverOrder.NONE);
                futures[i] = srf.whenComplete((r, t) -> {
                    if (t != null) {
                        triConsumer.accept(JGroupsAddressCache.fromJGroupsAddress(target), (Object)null, (Throwable)t);
                    } else {
                        this.consumeResponse((Rsp<Response>)r, target, v -> triConsumer.accept(JGroupsAddressCache.fromJGroupsAddress(target), (Object)v, (Throwable)null), throwable -> triConsumer.accept(JGroupsAddressCache.fromJGroupsAddress(target), (Object)null, (Throwable)throwable), srf::obtrudeException);
                    }
                });
            }
            CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
            CompletableFuture<Void> remoteFutures = CompletableFuture.allOf(futures);
            ((CompletableFuture)(localFuture != null ? localFuture.thenCombine(remoteFutures, (t, u) -> null) : remoteFutures)).whenComplete((v, t) -> {
                if (t != null) {
                    if (t instanceof CompletionException) {
                        resultFuture.completeExceptionally(t.getCause());
                    }
                } else {
                    resultFuture.complete(null);
                }
            });
            return resultFuture;
        }
        if (localFuture != null) {
            return localFuture;
        }
        return CompletableFutures.completedExceptionFuture((Throwable)((Object)new SuspectException("No available nodes!")));
    }

    @Override
    public ClusterExecutor singleNodeSubmission() {
        return ClusterExecutors.singleNodeSubmissionExecutor(this.predicate, this.manager, this.transport, this.time, this.unit, this.localExecutor, this.timeoutExecutor, 0);
    }

    @Override
    public ClusterExecutor singleNodeSubmission(int failOverCount) {
        return ClusterExecutors.singleNodeSubmissionExecutor(this.predicate, this.manager, this.transport, this.time, this.unit, this.localExecutor, this.timeoutExecutor, failOverCount);
    }

    @Override
    public ClusterExecutor allNodeSubmission() {
        return this;
    }
}

