/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager.impl;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.impl.AbstractClusterExecutor;
import org.infinispan.manager.impl.ClusterExecutors;
import org.infinispan.manager.impl.ReplicableCommandManagerFunction;
import org.infinispan.manager.impl.ReplicableCommandRunnable;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.JGroupsAddressCache;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.function.TriConsumer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.util.Rsp;

class SingleClusterExecutor
extends AbstractClusterExecutor<SingleClusterExecutor> {
    private static final Log log = LogFactory.getLog(SingleClusterExecutor.class);
    private static final boolean isTrace = log.isTraceEnabled();

    SingleClusterExecutor(Predicate<? super Address> predicate, EmbeddedCacheManager manager, JGroupsTransport transport, long time, TimeUnit unit, Executor localExecutor, ScheduledExecutorService timeoutExecutor) {
        super(predicate, manager, transport, time, unit, localExecutor, timeoutExecutor);
    }

    @Override
    public Log getLog() {
        return log;
    }

    @Override
    protected SingleClusterExecutor sameClusterExecutor(Predicate<? super Address> predicate, long time, TimeUnit unit) {
        return new SingleClusterExecutor(predicate, this.manager, this.transport, time, unit, this.localExecutor, this.timeoutExecutor);
    }

    private org.jgroups.Address findTarget() {
        List<org.jgroups.Address> possibleTargets = this.getJGroupsTargets(true);
        int size = possibleTargets.size();
        org.jgroups.Address target = size == 0 ? null : (size == 1 ? possibleTargets.get(0) : possibleTargets.get(ThreadLocalRandom.current().nextInt(size)));
        return target;
    }

    @Override
    public void execute(Runnable runnable) {
        org.jgroups.Address target = this.findTarget();
        if (target != null) {
            if (isTrace) {
                log.tracef("Submitting runnable to single remote node - JGroups Address %s", target);
            }
            if (target == SingleClusterExecutor.convertToJGroupsAddress(this.me)) {
                super.execute(runnable);
            } else {
                this.transport.getCommandAwareRpcDispatcher().invokeRemoteCommand(target, new ReplicableCommandRunnable(runnable), ResponseMode.GET_NONE, this.unit.toMillis(this.time), DeliverOrder.NONE);
            }
        }
    }

    @Override
    public CompletableFuture<Void> submit(Runnable command) {
        org.jgroups.Address target = this.findTarget();
        if (target == null) {
            return CompletableFutures.completedExceptionFuture((Throwable)((Object)new SuspectException("No available nodes!")));
        }
        if (isTrace) {
            log.tracef("Submitting runnable to single remote node - JGroups Address %s", target);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (target == SingleClusterExecutor.convertToJGroupsAddress(this.me)) {
            return super.submit(command);
        }
        this.transport.getCommandAwareRpcDispatcher().invokeRemoteCommand(target, new ReplicableCommandRunnable(command), ResponseMode.GET_FIRST, this.unit.toMillis(this.time), DeliverOrder.NONE).whenComplete((r, t) -> {
            if (t != null) {
                future.completeExceptionally((Throwable)t);
            } else {
                this.consumeResponse((Rsp<Response>)r, target, future::completeExceptionally);
                future.complete(null);
            }
        });
        return future;
    }

    @Override
    public <V> CompletableFuture<Void> submitConsumer(Function<? super EmbeddedCacheManager, ? extends V> function, TriConsumer<? super Address, ? super V, ? super Throwable> triConsumer) {
        org.jgroups.Address target = this.findTarget();
        if (target == null) {
            return CompletableFutures.completedExceptionFuture((Throwable)((Object)new SuspectException("No available nodes!")));
        }
        if (isTrace) {
            log.tracef("Submitting runnable to single remote node - JGroups Address %s", target);
        }
        if (target == SingleClusterExecutor.convertToJGroupsAddress(this.me)) {
            return super.submitConsumer(function, triConsumer);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.transport.getCommandAwareRpcDispatcher().invokeRemoteCommand(target, new ReplicableCommandManagerFunction(function), ResponseMode.GET_ALL, this.unit.toMillis(this.time), DeliverOrder.NONE).whenComplete((r, t) -> {
            try {
                if (t != null) {
                    triConsumer.accept(JGroupsAddressCache.fromJGroupsAddress(target), (Object)null, (Throwable)t);
                } else {
                    this.consumeResponse((Rsp<Response>)r, target, v -> triConsumer.accept(JGroupsAddressCache.fromJGroupsAddress(target), (Object)v, (Throwable)null), throwable -> triConsumer.accept(JGroupsAddressCache.fromJGroupsAddress(target), (Object)null, (Throwable)throwable), future::completeExceptionally);
                }
                future.complete(null);
            }
            catch (Throwable throwable2) {
                future.completeExceptionally(throwable2);
            }
        });
        return future;
    }

    @Override
    public ClusterExecutor singleNodeSubmission() {
        return this;
    }

    @Override
    public ClusterExecutor singleNodeSubmission(int failOverCount) {
        if (failOverCount == 0) {
            return this;
        }
        return ClusterExecutors.singleNodeSubmissionExecutor(this.predicate, this.manager, this.transport, this.time, this.unit, this.localExecutor, this.timeoutExecutor, failOverCount);
    }

    @Override
    public ClusterExecutor allNodeSubmission() {
        return ClusterExecutors.allSubmissionExecutor(this.predicate, this.manager, this.transport, this.time, this.unit, this.localExecutor, this.timeoutExecutor);
    }
}

