/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.RpcException;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.statetransfer.AllOwnersLostException;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PartitionHandlingInterceptor
extends DDAsyncInterceptor {
    private static final Log log = LogFactory.getLog(PartitionHandlingInterceptor.class);
    private PartitionHandlingManager partitionHandlingManager;
    private Transport transport;
    private StateTransferManager stateTransferManager;
    private DistributionManager distributionManager;

    @Inject
    void init(PartitionHandlingManager partitionHandlingManager, Transport transport, StateTransferManager stateTransferManager, DistributionManager distributionManager) {
        this.partitionHandlingManager = partitionHandlingManager;
        this.transport = transport;
        this.stateTransferManager = stateTransferManager;
        this.distributionManager = distributionManager;
    }

    private boolean performPartitionCheck(InvocationContext ctx, FlagAffectedCommand command) {
        if (!ctx.isOriginLocal()) {
            return true;
        }
        return !command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    protected Object handleSingleWrite(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            this.partitionHandlingManager.checkWrite(command.getKey());
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            for (Object k : command.getAffectedKeys()) {
                this.partitionHandlingManager.checkWrite(k);
            }
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            this.partitionHandlingManager.checkClear();
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    @Override
    public Object visitKeySetCommand(InvocationContext ctx, KeySetCommand command) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            this.partitionHandlingManager.checkBulkRead();
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public Object visitEntrySetCommand(InvocationContext ctx, EntrySetCommand command) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            this.partitionHandlingManager.checkBulkRead();
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public final Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.handleDataReadCommand(ctx, command);
    }

    @Override
    public final Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        return this.handleDataReadCommand(ctx, command);
    }

    private Object handleDataReadCommand(InvocationContext ctx, DataCommand command) {
        return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> {
            DataCommand dataCommand = (DataCommand)rCommand;
            if (t != null) {
                if (t instanceof RpcException && this.performPartitionCheck(rCtx, dataCommand)) {
                    throw log.degradedModeKeyUnavailable(dataCommand.getKey());
                }
                if (t instanceof AllOwnersLostException && this.performPartitionCheck(rCtx, dataCommand)) {
                    List<Address> owners = this.distributionManager.getCacheTopology().getDistribution(dataCommand.getKey()).readOwners();
                    CacheTopology cacheTopology = this.stateTransferManager.getCacheTopology();
                    if (cacheTopology == null || cacheTopology.getTopologyId() != dataCommand.getTopologyId()) {
                        throw t;
                    }
                    if (!InfinispanCollections.containsAny(this.transport.getMembers(), owners)) {
                        throw log.degradedModeKeyUnavailable(dataCommand.getKey());
                    }
                }
                throw t;
            }
            this.postOperationPartitionCheck(rCtx, dataCommand, dataCommand.getKey());
        });
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!ctx.isOriginLocal()) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextThenAccept(ctx, command, (rCtx, rCommand, rv) -> this.postTxCommandCheck((TxInvocationContext)rCtx));
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (!ctx.isOriginLocal()) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextThenAccept(ctx, command, (rCtx, rCommand, rv) -> this.postTxCommandCheck((TxInvocationContext)rCtx));
    }

    protected void postTxCommandCheck(TxInvocationContext ctx) {
        if (ctx.hasModifications() && this.partitionHandlingManager.getAvailabilityMode() != AvailabilityMode.AVAILABLE && !this.partitionHandlingManager.isTransactionPartiallyCommitted(ctx.getGlobalTransaction())) {
            for (Object key : ctx.getAffectedKeys()) {
                this.partitionHandlingManager.checkWrite(key);
            }
        }
    }

    private void postOperationPartitionCheck(InvocationContext ctx, DataCommand command, Object key) throws Throwable {
        if (this.performPartitionCheck(ctx, command)) {
            this.partitionHandlingManager.checkRead(key);
        }
    }

    @Override
    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> {
            GetAllCommand getAllCommand = (GetAllCommand)rCommand;
            if (t != null) {
                if (t instanceof RpcException && this.performPartitionCheck(rCtx, getAllCommand)) {
                    throw log.degradedModeKeysUnavailable(((GetAllCommand)rCommand).getKeys());
                }
                throw t;
            }
            if (this.performPartitionCheck(rCtx, getAllCommand)) {
                for (Object key : getAllCommand.getKeys()) {
                    this.partitionHandlingManager.checkRead(key);
                }
                Map result = (Map)rv;
                if (result.size() != getAllCommand.getKeys().size()) {
                    HashSet missingKeys = new HashSet(getAllCommand.getKeys());
                    missingKeys.removeAll(result.keySet());
                    Iterator it = missingKeys.iterator();
                    while (it.hasNext()) {
                        Object key = it.next();
                        List<Address> readOwners = this.distributionManager.getCacheTopology().getDistribution(key).readOwners();
                        if (!InfinispanCollections.containsAny(this.transport.getMembers(), readOwners)) continue;
                        it.remove();
                    }
                    if (!missingKeys.isEmpty()) {
                        throw log.degradedModeKeysUnavailable(missingKeys);
                    }
                }
            }
        });
    }
}

