/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import org.infinispan.commons.util.CloseableIterator;

public class DistinctKeyDoubleEntryCloseableIterator<E, K>
implements CloseableIterator<E> {
    private final CloseableIterator<E> iterator1;
    private final CloseableIterator<E> iterator2;
    private final Function<? super E, K> function;
    private final Set<K> keysSeenInFirst;
    private boolean completedFirst = false;
    private E iterator2Next;

    public DistinctKeyDoubleEntryCloseableIterator(CloseableIterator<E> first, CloseableIterator<E> second, Function<? super E, K> function, Set<K> seenKeys) {
        this.iterator1 = first;
        this.iterator2 = second;
        this.function = function;
        this.keysSeenInFirst = seenKeys;
    }

    public void close() {
        try {
            this.iterator1.close();
        }
        finally {
            this.iterator2.close();
        }
    }

    public boolean hasNext() {
        if (!this.completedFirst) {
            boolean hasNext = this.iterator1.hasNext();
            if (hasNext) {
                return hasNext;
            }
            this.completedFirst = true;
        }
        while (this.iterator2.hasNext()) {
            Object e = this.iterator2.next();
            if (this.keysSeenInFirst.remove(this.function.apply(e))) continue;
            this.iterator2Next = e;
            break;
        }
        return this.iterator2Next != null;
    }

    public E next() {
        if (!this.completedFirst) {
            if (this.iterator1.hasNext()) {
                Object next = this.iterator1.next();
                this.keysSeenInFirst.add(this.function.apply(next));
                return (E)next;
            }
            this.completedFirst = true;
        }
        if (this.iterator2Next != null) {
            E e = this.iterator2Next;
            this.iterator2Next = null;
            return e;
        }
        while (this.iterator2.hasNext()) {
            Object e = this.iterator2.next();
            if (this.keysSeenInFirst.remove(this.function.apply(e))) continue;
            return (E)e;
        }
        throw new NoSuchElementException();
    }
}

