/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.common;

import io.undertow.util.AttachmentKey;
import org.jboss.logging.Logger;
import org.jboss.security.negotiation.NegotiationMessage;

public class NegotiationContext {
    public static final AttachmentKey<NegotiationContext> ATTACHMENT_KEY = AttachmentKey.create(NegotiationContext.class);
    private static final Logger log = Logger.getLogger(NegotiationContext.class);
    private static final ThreadLocal<NegotiationContext> negotiationContext = new ThreadLocal();
    private String username;
    private boolean authenticated = false;
    private String authenticationMethod;
    private NegotiationMessage requestMessage = null;
    private NegotiationMessage responseMessage = null;
    private Object schemeContext = null;
    private boolean continuationRequired = false;

    public static NegotiationContext getCurrentNegotiationContext() {
        return negotiationContext.get();
    }

    public void associate() {
        log.tracef("associate %h", (Object)this);
        negotiationContext.set(this);
    }

    public void clear() {
        log.tracef("clear %h", (Object)this);
        this.requestMessage = null;
        this.responseMessage = null;
        this.continuationRequired = false;
        negotiationContext.remove();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(String authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public NegotiationMessage getRequestMessage() {
        return this.requestMessage;
    }

    public void setRequestMessage(NegotiationMessage requestMessage) {
        this.requestMessage = requestMessage;
    }

    public NegotiationMessage getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(NegotiationMessage responseMessage) {
        this.responseMessage = responseMessage;
    }

    public Object getSchemeContext() {
        return this.schemeContext;
    }

    public void setSchemeContext(Object schemeContext) {
        this.schemeContext = schemeContext;
    }

    public boolean isContinuationRequired() {
        return this.continuationRequired;
    }

    public void setContinuationRequired(boolean continuationRequired) {
        this.continuationRequired = continuationRequired;
    }
}

