/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.function.Supplier;
import org.jgroups.Header;
import org.jgroups.util.Util;

public class EncryptHeader
extends Header {
    public static final byte ENCRYPT = 1;
    public static final byte SECRET_KEY_REQ = 2;
    public static final byte SECRET_KEY_RSP = 4;
    protected byte type;
    protected byte[] version;
    protected byte[] signature;

    public EncryptHeader() {
    }

    public EncryptHeader(byte type, byte[] version) {
        this.type = type;
        this.version = version;
    }

    public byte type() {
        return this.type;
    }

    public byte[] version() {
        return this.version;
    }

    public byte[] signature() {
        return this.signature;
    }

    public EncryptHeader signature(byte[] s) {
        this.signature = s;
        return this;
    }

    @Override
    public short getMagicId() {
        return 88;
    }

    @Override
    public Supplier<? extends Header> create() {
        return EncryptHeader::new;
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        out.writeByte(this.type);
        Util.writeByteBuffer(this.version, 0, this.version != null ? this.version.length : 0, out);
        Util.writeByteBuffer(this.signature, 0, this.signature != null ? this.signature.length : 0, out);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        this.type = in.readByte();
        this.version = Util.readByteBuffer(in);
        this.signature = Util.readByteBuffer(in);
    }

    @Override
    public String toString() {
        return String.format("[%s version=%s]", EncryptHeader.typeToString(this.type), this.version != null ? this.version.length + " bytes" : "n/a");
    }

    @Override
    public int serializedSize() {
        return 1 + Util.size(this.version) + Util.size(this.signature);
    }

    protected static String typeToString(byte type) {
        switch (type) {
            case 1: {
                return "ENCRYPT";
            }
            case 2: {
                return "SECRET_KEY_REQ";
            }
            case 4: {
                return "SECRET_KEY_RSP";
            }
        }
        return "<unrecognized type " + type;
    }
}

