/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.TCP;
import org.jgroups.stack.Protocol;
import org.jgroups.util.BoundedList;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

@Experimental
@MBean(description="Failure detection based on simple heartbeat protocol")
public class FD_ALL2
extends Protocol {
    @Property(description="Interval at which a HEARTBEAT is sent to the cluster")
    protected long interval = 8000L;
    @Property(description="Timeout after which a node P is suspected if neither a heartbeat nor data were received from P")
    protected long timeout = 40000L;
    @Property(description="Treat messages received from members as heartbeats. Note that this means we're updating a value in a hashmap every time a message is passing up the stack through FD_ALL2, which is costly. Default is false")
    protected boolean msg_counts_as_heartbeat = false;
    @ManagedAttribute(description="Number of heartbeats sent")
    protected int num_heartbeats_sent;
    @ManagedAttribute(description="Number of heartbeats received")
    protected int num_heartbeats_received;
    @ManagedAttribute(description="Number of suspected events received")
    protected int num_suspect_events;
    protected final ConcurrentMap<Address, AtomicBoolean> timestamps = Util.createConcurrentMap();
    protected Address local_addr;
    protected final List<Address> members = new ArrayList<Address>();
    protected final Set<Address> suspected_mbrs = new HashSet<Address>();
    @ManagedAttribute(description="Shows whether there are currently any suspected members")
    protected volatile boolean has_suspected_mbrs;
    protected TimeScheduler timer;
    protected Future<?> heartbeat_sender_future;
    protected Future<?> timeout_checker_future;
    protected final Lock lock = new ReentrantLock();
    protected final Predicate<Message> HAS_HEADER = msg -> msg.getHeader(this.id) != null;
    protected final BoundedList<Tuple<Address, Long>> suspect_history = new BoundedList(20);

    @ManagedAttribute(description="Member address")
    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    @ManagedAttribute(description="Lists members of a cluster")
    public String getMembers() {
        return Util.printListWithDelimiter(this.members, ",");
    }

    @ManagedAttribute(description="Currently suspected members")
    public synchronized String getSuspectedMembers() {
        return this.suspected_mbrs.toString();
    }

    public int getHeartbeatsSent() {
        return this.num_heartbeats_sent;
    }

    public int getHeartbeatsReceived() {
        return this.num_heartbeats_received;
    }

    public int getSuspectEventsSent() {
        return this.num_suspect_events;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    @ManagedAttribute(description="Are heartbeat tasks running")
    public boolean isRunning() {
        this.lock.lock();
        try {
            boolean bl = this.isTimeoutCheckerRunning() && this.isHeartbeatSenderRunning();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @ManagedOperation(description="Prints suspect history")
    public String printSuspectHistory() {
        StringBuilder sb = new StringBuilder();
        for (Tuple tuple : this.suspect_history) {
            sb.append(new Date((Long)tuple.getVal2())).append(": ").append(tuple.getVal1()).append("\n");
        }
        return sb.toString();
    }

    @ManagedOperation(description="Prints timestamps")
    public String printTimestamps() {
        return this._printTimestamps();
    }

    @ManagedOperation(description="Stops checking for crashed members")
    public void stopFailureDetection() {
        this.stopTimeoutChecker();
    }

    @ManagedOperation(description="Resumes checking for crashed members")
    public void startFailureDetection() {
        this.startTimeoutChecker();
    }

    @Override
    public void resetStats() {
        this.num_suspect_events = 0;
        this.num_heartbeats_received = 0;
        this.num_heartbeats_sent = 0;
        this.suspect_history.clear();
    }

    @Override
    public void init() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer not set");
        }
        this.suspected_mbrs.clear();
        this.has_suspected_mbrs = false;
    }

    @Override
    public synchronized void stop() {
        this.stopHeartbeatSender();
        this.stopTimeoutChecker();
        this.suspected_mbrs.clear();
        this.has_suspected_mbrs = false;
    }

    @Override
    public Object up(Message msg) {
        Address sender = msg.getSrc();
        Object hdr = msg.getHeader(this.id);
        if (hdr != null) {
            this.update(sender);
            ++this.num_heartbeats_received;
            this.unsuspect(sender);
            return null;
        }
        if (this.msg_counts_as_heartbeat) {
            this.update(sender);
            if (this.has_suspected_mbrs) {
                this.unsuspect(sender);
            }
        }
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        int matched_msgs = batch.replaceIf(this.HAS_HEADER, null, true);
        if (matched_msgs > 0 || this.msg_counts_as_heartbeat) {
            this.update(batch.sender());
            ++this.num_heartbeats_received;
            if (this.has_suspected_mbrs) {
                this.unsuspect(batch.sender());
            }
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.down_prot.down(evt);
                View v = (View)evt.getArg();
                this.handleViewChange(v);
                return null;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 51: {
                Address mbr = (Address)evt.getArg();
                this.unsuspect(mbr);
                this.update(mbr);
            }
        }
        return this.down_prot.down(evt);
    }

    protected void startTimeoutChecker() {
        this.lock.lock();
        try {
            if (!this.isTimeoutCheckerRunning()) {
                this.timeout_checker_future = this.timer.scheduleWithFixedDelay(new TimeoutChecker(), this.timeout, this.timeout, TimeUnit.MILLISECONDS, false);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void stopTimeoutChecker() {
        this.lock.lock();
        try {
            if (this.timeout_checker_future != null) {
                this.timeout_checker_future.cancel(true);
                this.timeout_checker_future = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void startHeartbeatSender() {
        this.lock.lock();
        try {
            if (!this.isHeartbeatSenderRunning()) {
                this.heartbeat_sender_future = this.timer.scheduleWithFixedDelay(new HeartbeatSender(), 1000L, this.interval, TimeUnit.MILLISECONDS, this.getTransport() instanceof TCP);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void stopHeartbeatSender() {
        this.lock.lock();
        try {
            if (this.heartbeat_sender_future != null) {
                this.heartbeat_sender_future.cancel(true);
                this.heartbeat_sender_future = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected boolean isTimeoutCheckerRunning() {
        return this.timeout_checker_future != null && !this.timeout_checker_future.isDone();
    }

    protected boolean isHeartbeatSenderRunning() {
        return this.heartbeat_sender_future != null && !this.heartbeat_sender_future.isDone();
    }

    protected void update(Address sender) {
        if (sender != null && !sender.equals(this.local_addr)) {
            AtomicBoolean heartbeat_received = (AtomicBoolean)this.timestamps.get(sender);
            if (heartbeat_received != null) {
                heartbeat_received.compareAndSet(false, true);
            } else {
                this.timestamps.putIfAbsent(sender, new AtomicBoolean(true));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleViewChange(View v) {
        List<Address> mbrs = v.getMembers();
        FD_ALL2 fD_ALL2 = this;
        synchronized (fD_ALL2) {
            this.members.clear();
            this.members.addAll(mbrs);
            if (this.suspected_mbrs.retainAll(mbrs)) {
                this.has_suspected_mbrs = !this.suspected_mbrs.isEmpty();
            }
            this.timestamps.keySet().retainAll(mbrs);
        }
        mbrs.forEach(this::update);
        if (mbrs.size() > 1) {
            this.startHeartbeatSender();
            this.startTimeoutChecker();
        } else {
            this.stopHeartbeatSender();
            this.stopTimeoutChecker();
        }
    }

    protected String _printTimestamps() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.timestamps.entrySet()) {
            sb.append(entry.getKey()).append(": received=").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspect(List<Address> suspects) {
        Address first;
        if (suspects == null || suspects.isEmpty()) {
            return;
        }
        this.num_suspect_events += suspects.size();
        ArrayList<Address> eligible_mbrs = new ArrayList<Address>();
        FD_ALL2 fD_ALL2 = this;
        synchronized (fD_ALL2) {
            for (Address suspect : suspects) {
                this.suspect_history.add(new Tuple<Address, Long>(suspect, System.currentTimeMillis()));
                this.suspected_mbrs.add(suspect);
            }
            eligible_mbrs.addAll(this.members);
            eligible_mbrs.removeAll(this.suspected_mbrs);
            this.has_suspected_mbrs = !this.suspected_mbrs.isEmpty();
        }
        if (this.local_addr != null && !eligible_mbrs.isEmpty() && this.local_addr.equals(first = (Address)eligible_mbrs.get(0))) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("suspecting " + this.getSuspectedMembers());
            }
            for (Address suspect : suspects) {
                this.up_prot.up(new Event(9, suspect));
                this.down_prot.down(new Event(9, suspect));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean unsuspect(Address mbr) {
        boolean do_unsuspect;
        if (mbr == null) {
            return false;
        }
        FD_ALL2 fD_ALL2 = this;
        synchronized (fD_ALL2) {
            boolean bl = do_unsuspect = !this.suspected_mbrs.isEmpty() && this.suspected_mbrs.remove(mbr);
            if (do_unsuspect) {
                this.has_suspected_mbrs = !this.suspected_mbrs.isEmpty();
            }
        }
        if (do_unsuspect) {
            this.up_prot.up(new Event(51, mbr));
            this.down_prot.down(new Event(51, mbr));
        }
        return do_unsuspect;
    }

    class TimeoutChecker
    implements Runnable {
        TimeoutChecker() {
        }

        @Override
        public void run() {
            LinkedList<Address> suspects = new LinkedList<Address>();
            Iterator it = FD_ALL2.this.timestamps.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Address key = (Address)entry.getKey();
                AtomicBoolean val = (AtomicBoolean)entry.getValue();
                if (val == null) {
                    it.remove();
                    continue;
                }
                if (val.compareAndSet(true, false)) continue;
                FD_ALL2.this.log.debug("%s: haven't received a heartbeat from %s in timeout period (%d ms), adding it to suspect list", FD_ALL2.this.local_addr, key, FD_ALL2.this.timeout);
                suspects.add(key);
            }
            if (!suspects.isEmpty()) {
                FD_ALL2.this.suspect(suspects);
            }
        }

        public String toString() {
            return FD_ALL2.class.getSimpleName() + ": " + this.getClass().getSimpleName() + " (timeout=" + FD_ALL2.this.timeout + " ms)";
        }
    }

    class HeartbeatSender
    implements Runnable {
        HeartbeatSender() {
        }

        @Override
        public void run() {
            Message heartbeat = new Message().setFlag(Message.Flag.INTERNAL).putHeader(FD_ALL2.this.id, new HeartbeatHeader());
            FD_ALL2.this.down_prot.down(heartbeat);
            ++FD_ALL2.this.num_heartbeats_sent;
        }

        public String toString() {
            return FD_ALL2.class.getSimpleName() + ": " + this.getClass().getSimpleName();
        }
    }

    public static class HeartbeatHeader
    extends Header {
        @Override
        public short getMagicId() {
            return 63;
        }

        @Override
        public Supplier<? extends Header> create() {
            return HeartbeatHeader::new;
        }

        @Override
        public String toString() {
            return "heartbeat";
        }

        @Override
        public int serializedSize() {
            return 0;
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
        }
    }
}

