/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.ArrayList;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.HashIndex;
import org.h2.index.IndexType;
import org.h2.index.NonUniqueHashCursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.IndexColumn;
import org.h2.table.RegularTable;
import org.h2.util.New;
import org.h2.util.ValueHashMap;
import org.h2.value.Value;

public class NonUniqueHashIndex
extends HashIndex {
    private ValueHashMap<ArrayList<Long>> rows;
    private final RegularTable tableData;
    private long rowCount;

    public NonUniqueHashIndex(RegularTable regularTable, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType) {
        super(regularTable, n, string, indexColumnArray, indexType);
        this.tableData = regularTable;
        this.reset();
    }

    private void reset() {
        this.rows = ValueHashMap.newInstance();
        this.rowCount = 0L;
    }

    @Override
    public void truncate(Session session) {
        this.reset();
    }

    @Override
    public void add(Session session, Row row) {
        Value value = row.getValue(this.indexColumn);
        ArrayList<Long> arrayList = this.rows.get(value);
        if (arrayList == null) {
            arrayList = New.arrayList();
            this.rows.put(value, arrayList);
        }
        arrayList.add(row.getKey());
        ++this.rowCount;
    }

    @Override
    public void remove(Session session, Row row) {
        if (this.rowCount == 1L) {
            this.reset();
        } else {
            Value value = row.getValue(this.indexColumn);
            ArrayList<Long> arrayList = this.rows.get(value);
            if (arrayList.size() == 1) {
                this.rows.remove(value);
            } else {
                arrayList.remove(row.getKey());
            }
            --this.rowCount;
        }
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        if (searchRow == null || searchRow2 == null) {
            throw DbException.throwInternalError();
        }
        if (searchRow != searchRow2 && this.compareKeys(searchRow, searchRow2) != 0) {
            throw DbException.throwInternalError();
        }
        ArrayList<Long> arrayList = this.rows.get(searchRow.getValue(this.indexColumn));
        return new NonUniqueHashCursor(session, this.tableData, arrayList);
    }

    @Override
    public long getRowCount(Session session) {
        return this.rowCount;
    }

    @Override
    public long getRowCountApproximation() {
        return this.rowCount;
    }
}

