/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.el.cache;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.el.cache.BeanPropertiesCache;

public class FactoryFinderCache {
    private static final Map<CacheKey, String> CLASS_CACHE = new ConcurrentHashMap<CacheKey, String>();

    public static void addCacheEntry(ClassLoader classLoader, String factoryId, String factoryClassName) {
        if (factoryClassName == null) {
            CLASS_CACHE.put(new CacheKey(classLoader, factoryId), "");
        } else {
            CLASS_CACHE.put(new CacheKey(classLoader, factoryId), factoryClassName);
        }
    }

    public static void clearClassLoader(ClassLoader classLoader) {
        BeanPropertiesCache.clear(classLoader);
        Iterator<Map.Entry<CacheKey, String>> it = CLASS_CACHE.entrySet().iterator();
        while (it.hasNext()) {
            CacheKey key = it.next().getKey();
            if (key.loader != classLoader) continue;
            it.remove();
        }
    }

    public static String loadImplementationClassName(String factoryId, ClassLoader classLoader) {
        String value;
        Map<CacheKey, String> classCache = CLASS_CACHE;
        if (classCache != null && (value = classCache.get(new CacheKey(classLoader, factoryId))) != null) {
            if (value.equals("")) {
                return null;
            }
            return value;
        }
        String serviceId = "META-INF/services/" + factoryId;
        try {
            InputStream is = null;
            is = classLoader == null ? ClassLoader.getSystemResourceAsStream(serviceId) : classLoader.getResourceAsStream(serviceId);
            if (is != null) {
                BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                String factoryClassName = rd.readLine();
                rd.close();
                if (factoryClassName != null && !"".equals(factoryClassName)) {
                    if (classCache != null) {
                        classCache.put(new CacheKey(classLoader, factoryId), factoryClassName);
                    }
                    return factoryClassName;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (classCache != null) {
            classCache.put(new CacheKey(classLoader, factoryId), "");
        }
        return null;
    }

    private static class CacheKey {
        private final ClassLoader loader;
        private final String className;

        private CacheKey(ClassLoader loader, String className) {
            this.loader = loader;
            this.className = className;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.className != null ? !this.className.equals(cacheKey.className) : cacheKey.className != null) {
                return false;
            }
            return !(this.loader != null ? !this.loader.equals(cacheKey.loader) : cacheKey.loader != null);
        }

        public int hashCode() {
            int result = this.loader != null ? this.loader.hashCode() : 0;
            result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
            return result;
        }
    }
}

