/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.remoting;

import java.security.Permission;
import org.jboss.as.security.remoting.RemotingPermission;
import org.jboss.remoting3.Connection;

public class RemotingContext {
    private static final RemotingPermission CLEAR_CONNECTION = new RemotingPermission("clearConnection");
    private static final RemotingPermission GET_CONNECTION = new RemotingPermission("getConnection");
    private static final RemotingPermission IS_CONNECTION_SET = new RemotingPermission("isConnectionSet");
    private static final RemotingPermission SET_CONNECTION = new RemotingPermission("setConnection");
    private static ThreadLocal<Connection> connection = new ThreadLocal();

    public static void setConnection(Connection connection) {
        RemotingContext.checkPermission(SET_CONNECTION);
        RemotingContext.connection.set(connection);
    }

    public static void clear() {
        RemotingContext.checkPermission(CLEAR_CONNECTION);
        connection.set(null);
    }

    public static Connection getConnection() {
        RemotingContext.checkPermission(GET_CONNECTION);
        return connection.get();
    }

    public static boolean isSet() {
        RemotingContext.checkPermission(IS_CONNECTION_SET);
        return connection.get() != null;
    }

    private static void checkPermission(Permission permission) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(permission);
        }
    }
}

