/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.cursor.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.NonExistentPage;
import org.apache.activemq.artemis.core.paging.cursor.PageCache;
import org.apache.activemq.artemis.core.paging.cursor.PageCursorProvider;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.PagedReference;
import org.apache.activemq.artemis.core.paging.cursor.PagedReferenceImpl;
import org.apache.activemq.artemis.core.paging.cursor.impl.PageCacheImpl;
import org.apache.activemq.artemis.core.paging.cursor.impl.PagePositionImpl;
import org.apache.activemq.artemis.core.paging.cursor.impl.PageSubscriptionImpl;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.utils.FutureLatch;
import org.apache.activemq.artemis.utils.SoftValueHashMap;
import org.jboss.logging.Logger;

public class PageCursorProviderImpl
implements PageCursorProvider {
    private static final Logger logger = Logger.getLogger(PageCursorProviderImpl.class);
    protected final AtomicInteger scheduledCleanup = new AtomicInteger(0);
    protected volatile boolean cleanupEnabled = true;
    protected final PagingStore pagingStore;
    protected final StorageManager storageManager;
    private final Executor executor;
    private final SoftValueHashMap<Long, PageCache> softCache;
    private final ConcurrentMap<Long, PageSubscription> activeCursors = new ConcurrentHashMap<Long, PageSubscription>();

    public PageCursorProviderImpl(PagingStore pagingStore, StorageManager storageManager, Executor executor, int maxCacheSize) {
        this.pagingStore = pagingStore;
        this.storageManager = storageManager;
        this.executor = executor;
        this.softCache = new SoftValueHashMap(maxCacheSize);
    }

    @Override
    public synchronized PageSubscription createSubscription(long cursorID, Filter filter, boolean persistent) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(this.pagingStore.getAddress() + " creating subscription " + cursorID + " with filter " + filter), (Throwable)new Exception("trace"));
        }
        if (this.activeCursors.containsKey(cursorID)) {
            throw new IllegalStateException("Cursor " + cursorID + " had already been created");
        }
        PageSubscriptionImpl activeCursor = new PageSubscriptionImpl(this, this.pagingStore, this.storageManager, this.executor, filter, cursorID, persistent);
        this.activeCursors.put(cursorID, activeCursor);
        return activeCursor;
    }

    @Override
    public synchronized PageSubscription getSubscription(long cursorID) {
        return (PageSubscription)this.activeCursors.get(cursorID);
    }

    @Override
    public PagedMessage getMessage(PagePosition pos) {
        PageCache cache = this.getPageCache(pos.getPageNr());
        if (cache == null || pos.getMessageNr() >= cache.getNumberOfMessages()) {
            throw new NonExistentPage("Invalid messageNumber passed = " + pos + " on " + cache);
        }
        return cache.getMessage(pos.getMessageNr());
    }

    @Override
    public PagedReference newReference(PagePosition pos, PagedMessage msg, PageSubscription subscription) {
        return new PagedReferenceImpl(pos, msg, subscription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageCache getPageCache(long pageId) {
        try {
            PageCache cache;
            SoftValueHashMap<Long, PageCache> softValueHashMap = this.softCache;
            synchronized (softValueHashMap) {
                if (pageId > (long)this.pagingStore.getCurrentWritingPage()) {
                    return null;
                }
                cache = (PageCache)this.softCache.get((Object)pageId);
                if (cache == null) {
                    if (!this.pagingStore.checkPageFileExists((int)pageId)) {
                        return null;
                    }
                    cache = this.createPageCache(pageId);
                    logger.tracef("adding pageCache pageNr=%d into cursor = %s", (Object)pageId, (Object)this.pagingStore.getAddress());
                    this.readPage((int)pageId, cache);
                    this.softCache.put((Object)pageId, (SoftValueHashMap.ValueCache)cache);
                }
            }
            return cache;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPage(int pageId, PageCache cache) throws Exception {
        Page page = null;
        try {
            page = this.pagingStore.createPage(pageId);
            this.storageManager.beforePageRead();
            page.open();
            List<PagedMessage> pgdMessages = page.read(this.storageManager);
            cache.setMessages(pgdMessages.toArray(new PagedMessage[pgdMessages.size()]));
        }
        finally {
            try {
                if (page != null) {
                    page.close(false);
                }
            }
            catch (Throwable ignored) {}
            this.storageManager.afterPageRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPageCache(PageCache cache) {
        logger.tracef("Add page cache %s", (Object)cache);
        SoftValueHashMap<Long, PageCache> softValueHashMap = this.softCache;
        synchronized (softValueHashMap) {
            this.softCache.put((Object)cache.getPageId(), (SoftValueHashMap.ValueCache)cache);
        }
    }

    @Override
    public void setCacheMaxSize(int size) {
        this.softCache.setMaxElements(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCacheSize() {
        SoftValueHashMap<Long, PageCache> softValueHashMap = this.softCache;
        synchronized (softValueHashMap) {
            return this.softCache.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        SoftValueHashMap<Long, PageCache> softValueHashMap = this.softCache;
        synchronized (softValueHashMap) {
            this.softCache.clear();
        }
    }

    @Override
    public void processReload() throws Exception {
        long cursorsMinPage;
        Collection<PageSubscription> cursorList = this.activeCursors.values();
        for (PageSubscription cursor : cursorList) {
            cursor.processReload();
        }
        if (!cursorList.isEmpty() && (cursorsMinPage = this.checkMinPage(cursorList)) != Long.MAX_VALUE) {
            for (long startPage = this.pagingStore.getFirstPage(); startPage < cursorsMinPage; ++startPage) {
                for (PageSubscription cursor : cursorList) {
                    cursor.reloadPageInfo(startPage);
                }
            }
        }
        this.cleanup();
    }

    @Override
    public void stop() {
        for (PageSubscription cursor : this.activeCursors.values()) {
            cursor.stop();
        }
        this.waitForFuture();
    }

    private void waitForFuture() {
        FutureLatch future = new FutureLatch();
        this.executor.execute((Runnable)future);
        while (!future.await(10000L)) {
            ActiveMQServerLogger.LOGGER.timedOutStoppingPagingCursor(future, this.executor);
        }
    }

    @Override
    public void flushExecutors() {
        for (PageSubscription cursor : this.activeCursors.values()) {
            cursor.flushExecutors();
        }
        this.waitForFuture();
    }

    @Override
    public void close(PageSubscription cursor) {
        this.activeCursors.remove(cursor.getId());
        this.scheduleCleanup();
    }

    @Override
    public void scheduleCleanup() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"scheduling cleanup", (Throwable)new Exception("trace"));
        }
        if (!this.cleanupEnabled || this.scheduledCleanup.intValue() > 2) {
            return;
        }
        this.scheduledCleanup.incrementAndGet();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                PageCursorProviderImpl.this.storageManager.setContext(PageCursorProviderImpl.this.storageManager.newSingleThreadContext());
                try {
                    if (PageCursorProviderImpl.this.cleanupEnabled) {
                        PageCursorProviderImpl.this.cleanup();
                    }
                }
                finally {
                    PageCursorProviderImpl.this.storageManager.clearContext();
                    PageCursorProviderImpl.this.scheduledCleanup.decrementAndGet();
                }
            }
        });
    }

    @Override
    public void onPageModeCleared() {
        ArrayList<PageSubscription> subscriptions = this.cloneSubscriptions();
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        for (PageSubscription sub : subscriptions) {
            try {
                sub.onPageModeCleared(tx);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.warn("Error while cleaning paging on queue " + sub.getQueue().getName(), e);
            }
        }
        try {
            tx.commit();
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.warn("Error while cleaning page, during the commit", e);
        }
    }

    @Override
    public void disableCleanup() {
        this.cleanupEnabled = false;
    }

    @Override
    public void resumeCleanup() {
        this.cleanupEnabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void cleanup() {
        ArrayList<Page> depagedPages;
        block19: {
            logger.tracef("performing page cleanup %s", (Object)this);
            depagedPages = new ArrayList<Page>();
            do {
                if (!this.pagingStore.lock(100L)) continue;
                logger.tracef("%s locked", (Object)this);
                PageCursorProviderImpl pageCursorProviderImpl = this;
                synchronized (pageCursorProviderImpl) {
                    try {
                        Page page;
                        if (!this.pagingStore.isStarted()) {
                            return;
                        }
                        if (this.pagingStore.getNumberOfPages() == 0) {
                            return;
                        }
                        ArrayList<PageSubscription> cursorList = this.cloneSubscriptions();
                        long minPage = this.checkMinPage(cursorList);
                        logger.debugf("Asserting cleanup for address %s, firstPage=%d", (Object)this.pagingStore.getAddress(), (Object)minPage);
                        if (minPage == (long)this.pagingStore.getCurrentWritingPage() && this.pagingStore.getCurrentPage().getNumberOfMessages() > 0) {
                            boolean complete = this.checkPageCompletion(cursorList, minPage);
                            if (!this.pagingStore.isStarted()) {
                                return;
                            }
                            if (complete) {
                                this.cleanupComplete(cursorList);
                            }
                        }
                        for (long i = this.pagingStore.getFirstPage(); i < minPage && this.checkPageCompletion(cursorList, i) && (page = this.pagingStore.depage()) != null; ++i) {
                            depagedPages.add(page);
                        }
                        if (this.pagingStore.getNumberOfPages() == 0 || this.pagingStore.getNumberOfPages() == 1 && this.pagingStore.getCurrentPage().getNumberOfMessages() == 0) {
                            this.pagingStore.stopPaging();
                            break block19;
                        }
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("Couldn't cleanup page on address " + this.pagingStore.getAddress() + " as numberOfPages == " + this.pagingStore.getNumberOfPages() + " and currentPage.numberOfMessages = " + this.pagingStore.getCurrentPage().getNumberOfMessages()));
                        }
                        break block19;
                    }
                    catch (Exception ex) {
                        ActiveMQServerLogger.LOGGER.problemCleaningPageAddress(ex, this.pagingStore.getAddress());
                        return;
                    }
                }
            } while (this.pagingStore.isStarted());
            return;
            {
                finally {
                    this.pagingStore.unlock();
                }
            }
        }
        this.finishCleanup(depagedPages);
    }

    protected void cleanupComplete(ArrayList<PageSubscription> cursorList) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Address " + this.pagingStore.getAddress() + " is leaving page mode as all messages are consumed and acknowledged from the page store"));
        }
        this.pagingStore.forceAnotherPage();
        Page currentPage = this.pagingStore.getCurrentPage();
        this.storeBookmark(cursorList, currentPage);
        this.pagingStore.stopPaging();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void finishCleanup(ArrayList<Page> depagedPages) {
        logger.tracef("this(%s) finishing cleanup on %s", (Object)this, depagedPages);
        try {
            Iterator<Page> iterator = depagedPages.iterator();
            while (iterator.hasNext()) {
                PagedMessage[] pgdMessages;
                Page depagedPage = iterator.next();
                SoftValueHashMap<Long, PageCache> softValueHashMap = this.softCache;
                // MONITORENTER : softValueHashMap
                PageCache cache = (PageCache)this.softCache.get((Object)depagedPage.getPageId());
                // MONITOREXIT : softValueHashMap
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Removing pageNr=" + depagedPage.getPageId() + " from page-cache"));
                }
                if (cache == null) {
                    this.storageManager.beforePageRead();
                    List<PagedMessage> pgdMessagesList = null;
                    try {
                        depagedPage.open();
                        pgdMessagesList = depagedPage.read(this.storageManager);
                    }
                    finally {
                        try {
                            depagedPage.close(false);
                        }
                        catch (Exception e) {}
                        this.storageManager.afterPageRead();
                    }
                    depagedPage.close(false);
                    pgdMessages = pgdMessagesList.toArray(new PagedMessage[pgdMessagesList.size()]);
                } else {
                    pgdMessages = cache.getMessages();
                }
                depagedPage.delete(pgdMessages);
                this.onDeletePage(depagedPage);
                softValueHashMap = this.softCache;
                // MONITORENTER : softValueHashMap
                this.softCache.remove((Object)depagedPage.getPageId());
                // MONITOREXIT : softValueHashMap
            }
            return;
        }
        catch (Exception ex) {
            ActiveMQServerLogger.LOGGER.problemCleaningPageAddress(ex, this.pagingStore.getAddress());
            return;
        }
    }

    private boolean checkPageCompletion(ArrayList<PageSubscription> cursorList, long minPage) {
        logger.tracef("checkPageCompletion(%d)", (Object)minPage);
        boolean complete = true;
        for (PageSubscription cursor : cursorList) {
            if (!cursor.isComplete(minPage)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Cursor " + cursor + " was considered incomplete at pageNr=" + minPage));
                }
                complete = false;
                break;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Cursor " + cursor + " was considered **complete** at pageNr=" + minPage));
        }
        return complete;
    }

    private synchronized ArrayList<PageSubscription> cloneSubscriptions() {
        ArrayList<PageSubscription> cursorList = new ArrayList<PageSubscription>(this.activeCursors.values());
        return cursorList;
    }

    protected void onDeletePage(Page deletedPage) throws Exception {
        ArrayList<PageSubscription> subscriptions = this.cloneSubscriptions();
        for (PageSubscription subs : subscriptions) {
            subs.onDeletePage(deletedPage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeBookmark(ArrayList<PageSubscription> cursorList, Page currentPage) throws Exception {
        try {
            for (PageSubscription cursor : cursorList) {
                cursor.confirmPosition(new PagePositionImpl(currentPage.getPageId(), -1));
            }
            while (!this.storageManager.waitOnOperations(5000L)) {
                ActiveMQServerLogger.LOGGER.problemCompletingOperations(this.storageManager.getContext());
            }
        }
        finally {
            for (PageSubscription cursor : cursorList) {
                cursor.enableAutoCleanup();
            }
        }
    }

    @Override
    public void printDebug() {
        System.out.println("Debug information for PageCursorProviderImpl:");
        for (PageCache cache : this.softCache.values()) {
            System.out.println("Cache " + cache);
        }
    }

    public String toString() {
        return "PageCursorProviderImpl{pagingStore=" + this.pagingStore + '}';
    }

    protected PageCacheImpl createPageCache(long pageId) throws Exception {
        return new PageCacheImpl(this.pagingStore.createPage((int)pageId));
    }

    private long checkMinPage(Collection<PageSubscription> cursorList) {
        long minPage = Long.MAX_VALUE;
        for (PageSubscription cursor : cursorList) {
            long firstPage = cursor.getFirstPage();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.pagingStore.getAddress() + " has a cursor " + cursor + " with first page=" + firstPage));
            }
            if (firstPage < 0L || firstPage >= minPage) continue;
            minPage = firstPage;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.pagingStore.getAddress() + " has minPage=" + minPage));
        }
        return minPage;
    }
}

