/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.filter.impl.FilterImpl;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscriptionCounter;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.persistence.GroupingInfo;
import org.apache.activemq.artemis.core.persistence.QueueBindingInfo;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.PageCountPending;
import org.apache.activemq.artemis.core.persistence.impl.journal.AddMessageRecord;
import org.apache.activemq.artemis.core.postoffice.DuplicateIDCache;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueFactory;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.core.server.group.GroupingHandler;
import org.apache.activemq.artemis.core.server.group.impl.GroupBinding;
import org.apache.activemq.artemis.core.server.impl.AutoCreatedQueueManagerImpl;
import org.apache.activemq.artemis.core.server.impl.JournalLoader;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.transaction.ResourceManager;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.jboss.logging.Logger;

public class PostOfficeJournalLoader
implements JournalLoader {
    private static final Logger logger = Logger.getLogger(PostOfficeJournalLoader.class);
    protected final PostOffice postOffice;
    protected final PagingManager pagingManager;
    private StorageManager storageManager;
    private final QueueFactory queueFactory;
    protected final NodeManager nodeManager;
    private final ManagementService managementService;
    private final GroupingHandler groupingHandler;
    private Configuration configuration;
    private Map<Long, Queue> queues;

    public PostOfficeJournalLoader(PostOffice postOffice, PagingManager pagingManager, StorageManager storageManager, QueueFactory queueFactory, NodeManager nodeManager, ManagementService managementService, GroupingHandler groupingHandler, Configuration configuration) {
        this.postOffice = postOffice;
        this.pagingManager = pagingManager;
        this.storageManager = storageManager;
        this.queueFactory = queueFactory;
        this.nodeManager = nodeManager;
        this.managementService = managementService;
        this.groupingHandler = groupingHandler;
        this.configuration = configuration;
        this.queues = new HashMap<Long, Queue>();
    }

    public PostOfficeJournalLoader(PostOffice postOffice, PagingManager pagingManager, StorageManager storageManager, QueueFactory queueFactory, NodeManager nodeManager, ManagementService managementService, GroupingHandler groupingHandler, Configuration configuration, Map<Long, Queue> queues) {
        this(postOffice, pagingManager, storageManager, queueFactory, nodeManager, managementService, groupingHandler, configuration);
        this.queues = queues;
    }

    @Override
    public void initQueues(Map<Long, QueueBindingInfo> queueBindingInfosMap, List<QueueBindingInfo> queueBindingInfos) throws Exception {
        int duplicateID = 0;
        for (QueueBindingInfo queueBindingInfo : queueBindingInfos) {
            boolean isTopicIdentification;
            queueBindingInfosMap.put(queueBindingInfo.getId(), queueBindingInfo);
            Filter filter = FilterImpl.createFilter(queueBindingInfo.getFilterString());
            boolean bl = isTopicIdentification = filter != null && filter.getFilterString() != null && filter.getFilterString().toString().equals("__AMQX=-1");
            if (this.postOffice.getBinding(queueBindingInfo.getQueueName()) != null) {
                if (isTopicIdentification) {
                    long tx = this.storageManager.generateID();
                    this.storageManager.deleteQueueBinding(tx, queueBindingInfo.getId());
                    this.storageManager.commitBindings(tx);
                    continue;
                }
                SimpleString newName = queueBindingInfo.getQueueName().concat("-" + duplicateID++);
                ActiveMQServerLogger.LOGGER.queueDuplicatedRenaming(queueBindingInfo.getQueueName().toString(), newName.toString());
                queueBindingInfo.replaceQueueName(newName);
            }
            PageSubscription subscription = null;
            if (!isTopicIdentification) {
                subscription = this.pagingManager.getPageStore(queueBindingInfo.getAddress()).getCursorProvider().createSubscription(queueBindingInfo.getId(), filter, true);
            }
            Queue queue = this.queueFactory.createQueue(queueBindingInfo.getId(), queueBindingInfo.getAddress(), queueBindingInfo.getQueueName(), filter, subscription, queueBindingInfo.getUser(), true, false, queueBindingInfo.isAutoCreated());
            if (queueBindingInfo.isAutoCreated()) {
                queue.setConsumersRefCount(new AutoCreatedQueueManagerImpl(((PostOfficeImpl)this.postOffice).getServer(), queueBindingInfo.getQueueName()));
            }
            LocalQueueBinding binding = new LocalQueueBinding(queueBindingInfo.getAddress(), queue, this.nodeManager.getNodeId());
            this.queues.put(queueBindingInfo.getId(), queue);
            this.postOffice.addBinding(binding);
            this.managementService.registerAddress(queueBindingInfo.getAddress());
            this.managementService.registerQueue(queue, queueBindingInfo.getAddress(), this.storageManager);
        }
    }

    @Override
    public void handleAddMessage(Map<Long, Map<Long, AddMessageRecord>> queueMap) throws Exception {
        for (Map.Entry<Long, Map<Long, AddMessageRecord>> entry : queueMap.entrySet()) {
            long queueID = entry.getKey();
            Map<Long, AddMessageRecord> queueRecords = entry.getValue();
            Queue queue = this.queues.get(queueID);
            if (queue == null) {
                if (queueRecords.values().size() == 0) continue;
                ActiveMQServerLogger.LOGGER.journalCannotFindQueueForMessage(queueID);
                continue;
            }
            queue.pause();
            Collection<AddMessageRecord> valueRecords = queueRecords.values();
            long currentTime = System.currentTimeMillis();
            for (AddMessageRecord record : valueRecords) {
                long scheduledDeliveryTime = record.getScheduledDeliveryTime();
                if (scheduledDeliveryTime != 0L && scheduledDeliveryTime <= currentTime) {
                    scheduledDeliveryTime = 0L;
                    record.getMessage().removeProperty(Message.HDR_SCHEDULED_DELIVERY_TIME);
                }
                if (scheduledDeliveryTime != 0L) {
                    record.getMessage().putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, scheduledDeliveryTime);
                }
                MessageReference ref = this.postOffice.reroute(record.getMessage(), queue, null);
                ref.setDeliveryCount(record.getDeliveryCount());
                if (scheduledDeliveryTime == 0L) continue;
                record.getMessage().removeProperty(Message.HDR_SCHEDULED_DELIVERY_TIME);
            }
        }
    }

    @Override
    public void handleNoMessageReferences(Map<Long, ServerMessage> messages) {
        for (ServerMessage msg : messages.values()) {
            if (msg.getRefCount() != 0) continue;
            ActiveMQServerLogger.LOGGER.journalUnreferencedMessage(msg.getMessageID());
            try {
                this.storageManager.deleteMessage(msg.getMessageID());
            }
            catch (Exception ignored) {
                ActiveMQServerLogger.LOGGER.journalErrorDeletingMessage(ignored, msg.getMessageID());
            }
        }
    }

    @Override
    public void handleGroupingBindings(List<GroupingInfo> groupingInfos) {
        for (GroupingInfo groupingInfo : groupingInfos) {
            if (this.groupingHandler == null) continue;
            this.groupingHandler.addGroupBinding(new GroupBinding(groupingInfo.getId(), groupingInfo.getGroupId(), groupingInfo.getClusterName()));
        }
    }

    @Override
    public void handleDuplicateIds(Map<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap) throws Exception {
        for (Map.Entry<SimpleString, List<Pair<byte[], Long>>> entry : duplicateIDMap.entrySet()) {
            SimpleString address = entry.getKey();
            DuplicateIDCache cache = this.postOffice.getDuplicateIDCache(address);
            if (!this.configuration.isPersistIDCache()) continue;
            cache.load(entry.getValue());
        }
    }

    @Override
    public void postLoad(Journal messageJournal, ResourceManager resourceManager, Map<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap) throws Exception {
        for (Queue queue : this.queues.values()) {
            queue.resume();
        }
        if (System.getProperty("org.apache.activemq.opt.directblast") != null) {
            messageJournal.runDirectJournalBlast();
        }
    }

    @Override
    public void handlePreparedSendMessage(ServerMessage message, Transaction tx, long queueID) throws Exception {
        Queue queue = this.queues.get(queueID);
        if (queue == null) {
            ActiveMQServerLogger.LOGGER.journalMessageInPreparedTX(queueID);
            return;
        }
        this.postOffice.reroute(message, queue, tx);
    }

    @Override
    public void handlePreparedAcknowledge(long messageID, List<MessageReference> referencesToAck, long queueID) throws Exception {
        Queue queue = this.queues.get(queueID);
        if (queue == null) {
            throw new IllegalStateException("Cannot find queue with id " + queueID);
        }
        MessageReference removed = queue.removeReferenceWithID(messageID);
        if (removed == null) {
            ActiveMQServerLogger.LOGGER.journalErrorRemovingRef(messageID);
        } else {
            referencesToAck.add(removed);
        }
    }

    @Override
    public void handlePreparedTransaction(Transaction tx, List<MessageReference> referencesToAck, Xid xid, ResourceManager resourceManager) throws Exception {
        for (MessageReference ack : referencesToAck) {
            ack.getQueue().reacknowledge(tx, ack);
        }
        tx.setState(Transaction.State.PREPARED);
        resourceManager.putTransaction(xid, tx);
    }

    @Override
    public void recoverPendingPageCounters(List<PageCountPending> pendingNonTXPageCounter) throws Exception {
        TransactionImpl txRecoverCounter = new TransactionImpl(this.storageManager);
        Map<SimpleString, Map<Long, Map<Long, List<PageCountPending>>>> perAddressMap = this.generateMapsOnPendingCount(this.queues, pendingNonTXPageCounter, txRecoverCounter);
        for (SimpleString address : perAddressMap.keySet()) {
            PagingStore store = this.pagingManager.getPageStore(address);
            Map<Long, Map<Long, List<PageCountPending>>> perPageMap = perAddressMap.get(address);
            assert (perPageMap != null);
            for (Long pageId : perPageMap.keySet()) {
                Map<Long, List<PageCountPending>> perQueue = perPageMap.get(pageId);
                assert (perQueue != null);
                if (store.checkPageFileExists(pageId.intValue())) {
                    Page pg = store.createPage(pageId.intValue());
                    pg.open();
                    List<PagedMessage> pgMessages = pg.read(this.storageManager);
                    HashMap<Long, AtomicInteger> countsPerQueueOnPage = new HashMap<Long, AtomicInteger>();
                    for (PagedMessage pagedMessage : pgMessages) {
                        if (pagedMessage.getTransactionID() > 0L) continue;
                        for (long q : pagedMessage.getQueueIDs()) {
                            AtomicInteger countQ = (AtomicInteger)countsPerQueueOnPage.get(q);
                            if (countQ == null) {
                                countQ = new AtomicInteger(0);
                                countsPerQueueOnPage.put(q, countQ);
                            }
                            countQ.incrementAndGet();
                        }
                    }
                    for (Map.Entry entry : perQueue.entrySet()) {
                        Object object = ((List)entry.getValue()).iterator();
                        while (object.hasNext()) {
                            PageCountPending record = (PageCountPending)object.next();
                            logger.debug((Object)("Deleting pg tempCount " + record.getID()));
                            this.storageManager.deletePendingPageCounter(txRecoverCounter.getID(), record.getID());
                        }
                        PageSubscriptionCounter counter = store.getCursorProvider().getSubscription((Long)entry.getKey()).getCounter();
                        AtomicInteger value = (AtomicInteger)countsPerQueueOnPage.get(entry.getKey());
                        if (value == null) {
                            logger.debug((Object)("Page " + entry.getKey() + " wasn't open, so we will just ignore"));
                            continue;
                        }
                        logger.debug((Object)("Replacing counter " + value.get()));
                        counter.increment(txRecoverCounter, value.get());
                    }
                    continue;
                }
                logger.debug((Object)("Page " + pageId + " didn't exist on address " + address + ", so we are just removing records"));
                for (List<PageCountPending> records : perQueue.values()) {
                    for (PageCountPending record : records) {
                        logger.debug((Object)("Removing pending page counter " + record.getID()));
                        this.storageManager.deletePendingPageCounter(txRecoverCounter.getID(), record.getID());
                        txRecoverCounter.setContainsPersistent();
                    }
                }
            }
        }
        txRecoverCounter.commit();
    }

    @Override
    public void cleanUp() {
        this.queues.clear();
    }

    private Map<SimpleString, Map<Long, Map<Long, List<PageCountPending>>>> generateMapsOnPendingCount(Map<Long, Queue> queues, List<PageCountPending> pendingNonTXPageCounter, Transaction txRecoverCounter) throws Exception {
        HashMap<SimpleString, Map<Long, Map<Long, List<PageCountPending>>>> perAddressMap = new HashMap<SimpleString, Map<Long, Map<Long, List<PageCountPending>>>>();
        for (PageCountPending pgCount : pendingNonTXPageCounter) {
            LinkedList<PageCountPending> pendingCounters;
            HashMap<Long, LinkedList<PageCountPending>> perQueueMap;
            long queueID = pgCount.getQueueID();
            long pageID = pgCount.getPageID();
            Queue queue = queues.get(queueID);
            if (queue == null) {
                logger.debug((Object)("removing pending page counter id = " + pgCount.getID() + " as queueID=" + pgCount.getID() + " no longer exists"));
                this.storageManager.deletePendingPageCounter(txRecoverCounter.getID(), pgCount.getID());
                txRecoverCounter.setContainsPersistent();
                continue;
            }
            SimpleString address = queue.getAddress();
            HashMap perPageMap = (HashMap)perAddressMap.get(address);
            if (perPageMap == null) {
                perPageMap = new HashMap();
                perAddressMap.put(address, perPageMap);
            }
            if ((perQueueMap = (HashMap<Long, LinkedList<PageCountPending>>)perPageMap.get(pageID)) == null) {
                perQueueMap = new HashMap<Long, LinkedList<PageCountPending>>();
                perPageMap.put(pageID, perQueueMap);
            }
            if ((pendingCounters = (LinkedList<PageCountPending>)perQueueMap.get(queueID)) == null) {
                pendingCounters = new LinkedList<PageCountPending>();
                perQueueMap.put(queueID, pendingCounters);
            }
            pendingCounters.add(pgCount);
            perQueueMap.put(queueID, pendingCounters);
        }
        return perAddressMap;
    }
}

