/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.analyzer.impl;

import com.google.gson.JsonElement;
import java.util.Map;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.CharFilterDef;
import org.hibernate.search.annotations.NormalizerDef;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.elasticsearch.analyzer.definition.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.elasticsearch.settings.impl.model.AnalysisDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.AnalyzerDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.CharFilterDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.NormalizerDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.TokenFilterDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.TokenizerDefinition;
import org.hibernate.search.elasticsearch.settings.impl.translation.ElasticsearchAnalyzerDefinitionTranslator;

public class TranslatingElasticsearchAnalysisDefinitionRegistryPopulator {
    private final ElasticsearchAnalysisDefinitionRegistry registry;
    private final ElasticsearchAnalyzerDefinitionTranslator translator;

    public TranslatingElasticsearchAnalysisDefinitionRegistryPopulator(ElasticsearchAnalysisDefinitionRegistry registry, ElasticsearchAnalyzerDefinitionTranslator translator) {
        this.registry = registry;
        this.translator = translator;
    }

    public void registerAnalyzerDef(AnalyzerDef hibernateSearchDefinition) {
        String localName;
        AnalyzerDefinition elasticsearchDefinition = new AnalyzerDefinition();
        String remoteName = localName = hibernateSearchDefinition.name();
        TokenizerDef hibernateSearchTokenizerDef = hibernateSearchDefinition.tokenizer();
        String tokenizerName = this.registerTokenizerDef(localName, hibernateSearchTokenizerDef);
        elasticsearchDefinition.setTokenizer(tokenizerName);
        for (CharFilterDef charFilterDef : hibernateSearchDefinition.charFilters()) {
            String charFilterName = this.registerCharFilterDef(localName, charFilterDef);
            elasticsearchDefinition.addCharFilter(charFilterName);
        }
        for (CharFilterDef charFilterDef : hibernateSearchDefinition.filters()) {
            String tokenFilterName = this.registerTokenFilterDef(localName, (TokenFilterDef)charFilterDef);
            elasticsearchDefinition.addTokenFilter(tokenFilterName);
        }
        this.registry.register(remoteName, elasticsearchDefinition);
    }

    public void registerNormalizerDef(NormalizerDef hibernateSearchDefinition) {
        String localName;
        NormalizerDefinition elasticsearchDefinition = new NormalizerDefinition();
        String remoteName = localName = hibernateSearchDefinition.name();
        for (CharFilterDef charFilterDef : hibernateSearchDefinition.charFilters()) {
            String charFilterName = this.registerCharFilterDef(localName, charFilterDef);
            elasticsearchDefinition.addCharFilter(charFilterName);
        }
        for (CharFilterDef charFilterDef : hibernateSearchDefinition.filters()) {
            String tokenFilterName = this.registerTokenFilterDef(localName, (TokenFilterDef)charFilterDef);
            elasticsearchDefinition.addTokenFilter(tokenFilterName);
        }
        this.registry.register(remoteName, elasticsearchDefinition);
    }

    private String registerTokenizerDef(String analyzerDefinitionName, TokenizerDef hibernateSearchDef) {
        String remoteName = hibernateSearchDef.name();
        TokenizerDefinition elasticsearchDefinition = this.translator.translate(hibernateSearchDef);
        if (remoteName.isEmpty() && !this.hasParameters(elasticsearchDefinition)) {
            remoteName = elasticsearchDefinition.getType();
        } else {
            if (remoteName.isEmpty()) {
                remoteName = analyzerDefinitionName + "_" + hibernateSearchDef.factory().getSimpleName();
            }
            this.registry.register(remoteName, elasticsearchDefinition);
        }
        return remoteName;
    }

    private String registerCharFilterDef(String analyzerDefinitionName, CharFilterDef hibernateSearchDef) {
        String remoteName = hibernateSearchDef.name();
        CharFilterDefinition elasticsearchDefinition = this.translator.translate(hibernateSearchDef);
        if (remoteName.isEmpty() && !this.hasParameters(elasticsearchDefinition)) {
            remoteName = elasticsearchDefinition.getType();
        } else {
            if (remoteName.isEmpty()) {
                remoteName = analyzerDefinitionName + "_" + hibernateSearchDef.factory().getSimpleName();
            }
            this.registry.register(remoteName, elasticsearchDefinition);
        }
        return remoteName;
    }

    private String registerTokenFilterDef(String analyzerDefinitionName, TokenFilterDef hibernateSearchDef) {
        String remoteName = hibernateSearchDef.name();
        TokenFilterDefinition elasticsearchDefinition = this.translator.translate(hibernateSearchDef);
        if (remoteName.isEmpty() && !this.hasParameters(elasticsearchDefinition)) {
            remoteName = elasticsearchDefinition.getType();
        } else {
            if (remoteName.isEmpty()) {
                remoteName = analyzerDefinitionName + "_" + hibernateSearchDef.factory().getSimpleName();
            }
            this.registry.register(remoteName, elasticsearchDefinition);
        }
        return remoteName;
    }

    private boolean hasParameters(AnalysisDefinition definition) {
        Map<String, JsonElement> parameters = definition.getParameters();
        return parameters != null && !parameters.isEmpty();
    }
}

