/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.bridge.builtin.time.impl;

import java.time.DateTimeException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.util.Locale;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchTemporalAccessorStringBridge;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchLocalTimeBridge
extends ElasticsearchTemporalAccessorStringBridge<LocalTime> {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 3, 9, true).toFormatter(Locale.ROOT).withResolverStyle(ResolverStyle.STRICT);
    public static final ElasticsearchLocalTimeBridge INSTANCE = new ElasticsearchLocalTimeBridge();

    private ElasticsearchLocalTimeBridge() {
        super(FORMATTER, LocalTime.class);
    }

    @Override
    LocalTime parse(DateTimeFormatter formatter, String stringValue) throws DateTimeException {
        return LocalTime.parse(stringValue, formatter);
    }

    @Override
    protected IllegalArgumentException createInvalidIndexNullAsException(String indexNullAs, DateTimeException e) {
        return LOG.invalidNullMarkerForLocalTime(e);
    }
}

