/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.bridge.builtin.time.impl;

import java.time.DateTimeException;
import java.time.Year;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Locale;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchTemporalAccessorStringBridge;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchYearBridge
extends ElasticsearchTemporalAccessorStringBridge<Year> {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 9, SignStyle.EXCEEDS_PAD).toFormatter(Locale.ROOT).withResolverStyle(ResolverStyle.STRICT);
    public static final ElasticsearchYearBridge INSTANCE = new ElasticsearchYearBridge();

    private ElasticsearchYearBridge() {
        super(FORMATTER, Year.class);
    }

    @Override
    Year parse(DateTimeFormatter formatter, String stringValue) throws DateTimeException {
        return Year.parse(stringValue, formatter);
    }

    @Override
    protected IllegalArgumentException createInvalidIndexNullAsException(String indexNullAs, DateTimeException e) {
        return LOG.invalidNullMarkerForYear(e);
    }
}

